/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.dau;

import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.dau.DAUUtils;
import com.vaadin.flow.server.dau.DauEnforcementException;
import com.vaadin.pro.licensechecker.dau.DauIntegration;
import com.vaadin.pro.licensechecker.dau.EnforcementException;
import jakarta.servlet.http.Cookie;
import java.time.Instant;
import java.util.function.Predicate;

public final class FlowDauIntegration {
    private FlowDauIntegration() {
    }

    public static Cookie generateNewCookie(VaadinRequest request) {
        String cookieValue = DauIntegration.newTrackingHash() + "$" + Instant.now().toEpochMilli();
        Cookie cookie = new Cookie("DailyActiveUser", cookieValue);
        cookie.setHttpOnly(true);
        cookie.setSecure(request.isSecure());
        cookie.setMaxAge(86400);
        cookie.setPath("/");
        return cookie;
    }

    static void trackUser(VaadinRequest request, String trackingHash, String userIdentity) {
        if (HandlerHelper.isRequestType(request, HandlerHelper.RequestType.UIDL)) {
            request.setAttribute(TrackingDetails.class.getName(), new TrackingDetails(trackingHash, userIdentity));
        } else {
            try {
                DauIntegration.trackUser((String)trackingHash, (String)userIdentity);
            }
            catch (EnforcementException ex) {
                request.setAttribute(DAUUtils.ENFORCEMENT_EXCEPTION_KEY, (Object)ex);
            }
        }
    }

    static boolean shouldEnforce() {
        return DauIntegration.shouldEnforce();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyEnforcement(VaadinRequest request, Predicate<VaadinRequest> enforceableRequest) {
        block7: {
            TrackingDetails trackingDetails = (TrackingDetails)request.getAttribute(TrackingDetails.class.getName());
            EnforcementException enforcementException = (EnforcementException)((Object)request.getAttribute(DAUUtils.ENFORCEMENT_EXCEPTION_KEY));
            try {
                if (enforcementException == null && trackingDetails == null || !enforceableRequest.test(request)) break block7;
                if (trackingDetails != null) {
                    try {
                        DauIntegration.trackUser((String)trackingDetails.trackingHash(), (String)trackingDetails.userIdentity());
                    }
                    catch (EnforcementException ex) {
                        enforcementException = ex;
                    }
                }
                if (enforcementException != null) {
                    throw new DauEnforcementException(enforcementException);
                }
            }
            finally {
                request.removeAttribute(DAUUtils.ENFORCEMENT_EXCEPTION_KEY);
                request.removeAttribute(TrackingDetails.class.getName());
            }
        }
    }

    private record TrackingDetails(String trackingHash, String userIdentity) {
    }
}

