/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.VaadinService;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.UUID;
import org.slf4j.LoggerFactory;

public class DevToolsToken
implements Serializable {
    private static String randomDevToolsToken = UUID.randomUUID().toString();

    static synchronized void init(VaadinService vaadinService) {
        File projectFolder = vaadinService.getDeploymentConfiguration().getProjectFolder();
        if (projectFolder != null) {
            String uniqueUid = UUID.nameUUIDFromBytes(projectFolder.getAbsolutePath().getBytes(StandardCharsets.UTF_8)).toString();
            File tokenFile = new File(System.getProperty("java.io.tmpdir"), uniqueUid);
            if (tokenFile.exists()) {
                try {
                    randomDevToolsToken = UUID.fromString(Files.readString(tokenFile.toPath())).toString();
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(DevToolsToken.class).debug("Cannot read dev-tools token file, using a random new token. Browser page might need a reload to make dev-tools websocket establish a connection.", (Throwable)e);
                }
            } else {
                try {
                    Files.writeString(tokenFile.toPath(), (CharSequence)randomDevToolsToken, new OpenOption[0]);
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(DevToolsToken.class).debug("Cannot write dev-tools token file. A new token will be generated on server restart.", (Throwable)e);
                }
            }
        }
    }

    public static String getToken() {
        return randomDevToolsToken;
    }
}

