/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.Locale;

public class ScrollOptions
implements Serializable {
    private Behavior behavior = Behavior.SMOOTH;
    private Alignment block = Alignment.START;
    private Alignment inline = Alignment.NEAREST;

    public ScrollOptions() {
    }

    public ScrollOptions(Behavior behavior) {
        this.behavior = behavior;
    }

    public ScrollOptions(Behavior behavior, Alignment block, Alignment inline) {
        this.behavior = behavior;
        this.block = block;
        this.inline = inline;
    }

    public void setBehavior(Behavior behavior) {
        this.behavior = behavior;
    }

    public Behavior getBehavior() {
        return this.behavior;
    }

    public void setBlock(Alignment block) {
        this.block = block;
    }

    public Alignment getBlock() {
        return this.block;
    }

    public void setInline(Alignment inline) {
        this.inline = inline;
    }

    public Alignment getInline() {
        return this.inline;
    }

    public String toJson() {
        JsonObject json = Json.createObject();
        if (this.behavior != Behavior.AUTO) {
            json.put("behavior", this.behavior.name().toLowerCase(Locale.ENGLISH));
        }
        if (this.block != Alignment.START) {
            json.put("block", this.block.name().toLowerCase(Locale.ENGLISH));
        }
        if (this.inline != Alignment.NEAREST) {
            json.put("inline", this.inline.name().toLowerCase(Locale.ENGLISH));
        }
        return json.toString();
    }

    public static enum Behavior {
        AUTO,
        SMOOTH;

    }

    public static enum Alignment {
        START,
        CENTER,
        END,
        NEAREST;

    }
}

