/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.flow.theme.AbstractTheme;
import java.io.Serializable;
import java.util.Objects;

final class ThemeData
implements Serializable {
    String themeClass;
    String variant = "";
    String themeName = "";
    boolean notheme;

    ThemeData(String themeClass, String variant, String themeName) {
        this.themeClass = themeClass.equals(AbstractTheme.class.getName()) ? "com.vaadin.flow.theme.lumo.Lumo" : themeClass;
        this.variant = variant;
        this.themeName = themeName;
    }

    ThemeData() {
    }

    String getThemeClass() {
        return this.themeClass;
    }

    String getVariant() {
        return this.variant;
    }

    public String getThemeName() {
        return this.themeName;
    }

    boolean isNotheme() {
        return this.notheme;
    }

    static ThemeData createNoTheme() {
        ThemeData data = new ThemeData();
        data.notheme = true;
        return data;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof ThemeData)) {
            return false;
        }
        ThemeData that = (ThemeData)other;
        return this.notheme == that.notheme && Objects.equals(this.themeClass, that.themeClass) && Objects.equals(this.themeName, that.themeName);
    }

    public int hashCode() {
        return Objects.hash(this.themeClass, this.notheme, this.themeName);
    }

    public String toString() {
        return " notheme: " + this.notheme + "\n themeClass:" + this.themeClass + "\n variant: " + this.variant + "\n themeName: " + this.themeName;
    }
}

