/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.ConstantPoolKey;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class ConstantPool
implements Serializable {
    private Set<String> knownValues = new HashSet<String>();
    private Set<ConstantPoolKey> newKeys = new HashSet<ConstantPoolKey>();

    public String getConstantId(ConstantPoolKey constant) {
        assert (constant != null);
        String id = constant.getId();
        if (this.knownValues.add(id)) {
            this.newKeys.add(constant);
        }
        return id;
    }

    public boolean hasNewConstants() {
        return !this.newKeys.isEmpty();
    }

    public JsonObject dumpConstants() {
        JsonObject json = Json.createObject();
        this.newKeys.forEach(key -> key.export(json));
        this.newKeys.clear();
        return json;
    }
}

