/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.menu;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.internal.menu.MenuRegistry;
import com.vaadin.flow.router.internal.PathUtil;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.menu.AvailableViewInfo;
import com.vaadin.flow.server.menu.MenuEntry;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class MenuConfiguration {
    private static final String STATISTICS_DYNAMIC_MENU_ENTRIES = "flow/dynamic-menu-entries";

    public static List<MenuEntry> getMenuEntries() {
        UsageStatistics.markAsUsed(STATISTICS_DYNAMIC_MENU_ENTRIES, null);
        return MenuRegistry.collectMenuItemsList().stream().map(MenuConfiguration::createMenuEntry).toList();
    }

    public static List<MenuEntry> getMenuEntries(Locale locale) {
        UsageStatistics.markAsUsed(STATISTICS_DYNAMIC_MENU_ENTRIES, null);
        return MenuRegistry.collectMenuItemsList(locale).stream().map(MenuConfiguration::createMenuEntry).toList();
    }

    public static Optional<String> getPageHeader(Component content) {
        if (MenuConfiguration.isServerSideContent(content)) {
            Optional<String> maybeTitle;
            UI ui = UI.getCurrent();
            if (ui != null && (maybeTitle = RouteUtil.getDynamicTitle(ui)).isPresent()) {
                return maybeTitle;
            }
            return Optional.of(MenuRegistry.getTitle(content.getClass()));
        }
        return MenuConfiguration.getPageHeaderFromMenuItems();
    }

    public static Optional<String> getPageHeader() {
        return MenuConfiguration.getPageHeader(null);
    }

    private static boolean isServerSideContent(Component content) {
        if (content == null) {
            return false;
        }
        Tag tag = content.getClass().getAnnotation(Tag.class);
        return tag == null || !"react-router-outlet".equals(tag.value());
    }

    private static Optional<String> getPageHeaderFromMenuItems() {
        UI ui = UI.getCurrent();
        if (ui != null) {
            Optional<String> maybeTitle = RouteUtil.getDynamicTitle(ui);
            if (maybeTitle.isPresent()) {
                return maybeTitle;
            }
            String activeLocation = PathUtil.trimPath(ui.getInternals().getActiveViewLocation().getPath());
            Map<String, AvailableViewInfo> menuItems = MenuRegistry.getMenuItems(false);
            return menuItems.entrySet().stream().filter(menuEntry -> PathUtil.trimPath((String)menuEntry.getKey()).equals(activeLocation)).map(Map.Entry::getValue).map(AvailableViewInfo::title).filter(Objects::nonNull).findFirst();
        }
        return Optional.empty();
    }

    private static MenuEntry createMenuEntry(AvailableViewInfo viewInfo) {
        if (viewInfo.menu() == null) {
            return new MenuEntry(viewInfo.route(), viewInfo.title(), null, false, null, null);
        }
        return new MenuEntry(viewInfo.route(), viewInfo.menu().title() != null && !viewInfo.menu().title().isBlank() ? viewInfo.menu().title() : viewInfo.title(), viewInfo.menu().order(), viewInfo.menu().exclude(), viewInfo.menu().icon(), viewInfo.menu().menuClass());
    }
}

