/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.server.Attributes;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.DefaultErrorHandler;
import com.vaadin.flow.server.ErrorHandler;
import com.vaadin.flow.server.FutureAccess;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.SessionDestroyListener;
import com.vaadin.flow.server.SessionLockCheckStrategy;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSessionState;
import com.vaadin.flow.server.WebBrowser;
import com.vaadin.flow.server.WrappedSession;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.shared.communication.PushMode;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionBindingListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaadinSession
implements HttpSessionBindingListener,
Serializable {
    private static final String SESSION_NOT_LOCKED_MESSAGE = "Cannot access state in VaadinSession or UI without locking the session.";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)VaadinSession.class.getName());
    volatile boolean sessionClosedExplicitly = false;
    final List<SessionDestroyListener> destroyListeners = new CopyOnWriteArrayList<SessionDestroyListener>();
    private DeploymentConfiguration configuration;
    private Locale locale = Locale.getDefault();
    private ErrorHandler errorHandler = new DefaultErrorHandler();
    private LinkedList<RequestHandler> requestHandlers = new LinkedList();
    private int nextUIId = 0;
    private transient Map<Integer, UI> uIs = new HashMap<Integer, UI>();
    protected WebBrowser browser = new WebBrowser();
    private long cumulativeRequestDuration = 0L;
    private long lastRequestDuration = -1L;
    private long lastRequestTimestamp = System.currentTimeMillis();
    private VaadinSessionState state = VaadinSessionState.OPEN;
    private transient WrappedSession session;
    private transient VaadinService service;
    private transient Lock lock;
    private SessionLockCheckStrategy sessionLockCheckStrategy = SessionLockCheckStrategy.ASSERT;
    private transient ConcurrentLinkedQueue<FutureAccess> pendingAccessQueue = new ConcurrentLinkedQueue();
    private final String pushId = UUID.randomUUID().toString();
    private final Attributes attributes = new Attributes();
    private transient StreamResourceRegistry resourceRegistry;
    private long lastUnlocked;
    private long lastLocked;

    public VaadinSession(VaadinService service) {
        this.service = service;
        this.resourceRegistry = this.createStreamResourceRegistry();
    }

    protected StreamResourceRegistry createStreamResourceRegistry() {
        return new StreamResourceRegistry(this);
    }

    public void valueBound(HttpSessionBindingEvent arg0) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        if (!this.isInitialized()) {
            this.getLogger().debug("A VaadinSession instance not associated to any service is getting unbound. Session destroy events will not be fired and UIs in the session will not get detached. This might happen if a session is deserialized but never used before it expires.");
            return;
        }
        if (VaadinService.getCurrentRequest() != null && VaadinSession.getCurrent() == this) {
            this.checkHasLock();
            if (this.getAttribute(VaadinService.PRESERVE_UNBOUND_SESSION_ATTRIBUTE) == Boolean.TRUE) {
                return;
            }
            if (this.getState() == VaadinSessionState.OPEN) {
                this.close();
            }
        } else {
            this.service.fireSessionDestroy(this);
        }
        if (!this.sessionClosedExplicitly) {
            this.session = null;
        }
        this.sessionClosedExplicitly = false;
    }

    public WebBrowser getBrowser() {
        this.checkHasLock();
        return this.browser;
    }

    public void setBrowser(WebBrowser browser) {
        this.checkHasLock();
        this.browser = browser;
    }

    public long getCumulativeRequestDuration() {
        this.checkHasLock();
        return this.cumulativeRequestDuration;
    }

    public void setLastRequestDuration(long time) {
        this.checkHasLock();
        this.lastRequestDuration = time;
        this.cumulativeRequestDuration += time;
    }

    public long getLastRequestDuration() {
        this.checkHasLock();
        return this.lastRequestDuration;
    }

    public void setLastRequestTimestamp(long timestamp) {
        this.checkHasLock();
        this.lastRequestTimestamp = timestamp;
    }

    public long getLastRequestTimestamp() {
        this.checkHasLock();
        return this.lastRequestTimestamp;
    }

    public WrappedSession getSession() {
        return this.session;
    }

    public static Collection<VaadinSession> getAllSessions(HttpSession httpSession) {
        HashSet<VaadinSession> sessions = new HashSet<VaadinSession>();
        Enumeration attributeNames = httpSession.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            Object value;
            String attributeName = (String)attributeNames.nextElement();
            if (!attributeName.startsWith(VaadinSession.class.getName() + ".") || !((value = httpSession.getAttribute(attributeName)) instanceof VaadinSession)) continue;
            sessions.add((VaadinSession)value);
        }
        return sessions;
    }

    private void refreshLock() {
        assert (this.lock == null || this.lock == this.service.getSessionLock(this.session)) : "Cannot change the lock from one instance to another";
        assert (VaadinSession.hasLock(this.service, this.session));
        this.lock = this.service.getSessionLock(this.session);
    }

    public void setConfiguration(DeploymentConfiguration configuration) {
        this.checkHasLock();
        if (configuration == null) {
            throw new IllegalArgumentException("Can not set to null");
        }
        this.checkSetConfiguration();
        this.configuration = configuration;
        SessionLockCheckStrategy sessionLockCheckStrategy = this.sessionLockCheckStrategy = configuration.isProductionMode() ? configuration.getSessionLockCheckStrategy() : SessionLockCheckStrategy.THROW;
        assert (this.sessionLockCheckStrategy != null);
    }

    protected void checkSetConfiguration() {
        assert (this.configuration == null) : "Configuration can only be set once";
    }

    public DeploymentConfiguration getConfiguration() {
        this.checkHasLock();
        return this.configuration;
    }

    public Locale getLocale() {
        this.checkHasLock();
        return this.locale;
    }

    public void setLocale(Locale locale) {
        assert (locale != null) : "Null locale is not supported!";
        this.checkHasLock();
        this.locale = locale;
        this.getUIs().forEach(ui -> {
            Map<Class<?>, CurrentInstance> oldInstances = CurrentInstance.setCurrent(ui);
            try {
                ui.setLocale(locale);
            }
            finally {
                CurrentInstance.restoreInstances(oldInstances);
            }
        });
    }

    public ErrorHandler getErrorHandler() {
        this.checkHasLock();
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        Objects.requireNonNull(errorHandler, "errorHandler can not be null!");
        this.checkHasLock();
        this.errorHandler = errorHandler;
    }

    public void addRequestHandler(RequestHandler handler) {
        this.checkHasLock();
        this.requestHandlers.addFirst(handler);
    }

    public void removeRequestHandler(RequestHandler handler) {
        this.checkHasLock();
        this.requestHandlers.remove(handler);
    }

    public Collection<RequestHandler> getRequestHandlers() {
        this.checkHasLock();
        return Collections.unmodifiableCollection(this.requestHandlers);
    }

    public Registration addSessionDestroyListener(SessionDestroyListener listener) {
        return Registration.addAndRemove(this.destroyListeners, listener);
    }

    public static VaadinSession getCurrent() {
        return CurrentInstance.get(VaadinSession.class);
    }

    public static void setCurrent(VaadinSession session) {
        CurrentInstance.set(VaadinSession.class, session);
    }

    public Collection<UI> getUIs() {
        this.checkHasLock();
        return Collections.unmodifiableCollection(this.uIs.values());
    }

    public UI getUIById(int uiId) {
        this.checkHasLock();
        return this.uIs.get(uiId);
    }

    public boolean hasLock() {
        ReentrantLock l = (ReentrantLock)this.getLockInstance();
        return l.isHeldByCurrentThread();
    }

    public void checkHasLock(String message) {
        this.sessionLockCheckStrategy.checkHasLock(this, message);
    }

    public void checkHasLock() {
        this.checkHasLock(SESSION_NOT_LOCKED_MESSAGE);
    }

    protected static boolean hasLock(VaadinService service, WrappedSession session) {
        ReentrantLock l = (ReentrantLock)service.getSessionLock(session);
        return l.isHeldByCurrentThread();
    }

    public void removeUI(UI ui) {
        this.checkHasLock();
        assert (UI.getCurrent() != null) : "Current UI cannot be null";
        assert (ui != null) : "Removed UI cannot be null";
        assert (UI.getCurrent().getUIId() == ui.getUIId()) : "UIs don't match";
        ui.getInternals().setSession(null);
        this.uIs.remove(ui.getUIId());
    }

    public Lock getLockInstance() {
        return this.lock;
    }

    public void lock() {
        this.getLockInstance().lock();
        this.lastLocked = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        this.checkHasLock();
        boolean ultimateRelease = false;
        try {
            if (((ReentrantLock)this.getLockInstance()).getHoldCount() == 1) {
                ultimateRelease = true;
                this.getService().runPendingAccessTasks(this);
                for (UI ui : this.getUIs()) {
                    if (ui.getPushConfiguration().getPushMode() != PushMode.AUTOMATIC) continue;
                    Map<Class<?>, CurrentInstance> oldCurrent = CurrentInstance.setCurrent(ui);
                    try {
                        ui.push();
                    }
                    finally {
                        CurrentInstance.restoreInstances(oldCurrent);
                    }
                }
                this.lastUnlocked = System.currentTimeMillis();
            }
        }
        finally {
            this.getLockInstance().unlock();
        }
        if (ultimateRelease && !this.getPendingAccessQueue().isEmpty()) {
            this.getService().ensureAccessQueuePurged(this);
        }
    }

    public void setAttribute(String name, Object value) {
        this.checkHasLock();
        this.attributes.setAttribute(name, value);
    }

    public <T> void setAttribute(Class<T> type, T value) {
        this.checkHasLock();
        this.attributes.setAttribute(type, value);
    }

    public Object getAttribute(String name) {
        this.checkHasLock();
        return this.attributes.getAttribute(name);
    }

    public <T> T getAttribute(Class<T> type) {
        this.checkHasLock();
        return this.attributes.getAttribute(type);
    }

    public int getNextUIid() {
        this.checkHasLock();
        return this.nextUIId++;
    }

    public void addUI(UI ui) {
        this.checkHasLock();
        if (ui.getUIId() == -1) {
            throw new IllegalArgumentException("Can not add an UI that has not been initialized.");
        }
        if (ui.getSession() != this) {
            throw new IllegalArgumentException("The UI belongs to a different session");
        }
        this.uIs.put(ui.getUIId(), ui);
    }

    public VaadinService getService() {
        return this.service;
    }

    public void close() {
        this.checkHasLock();
        this.state = VaadinSessionState.CLOSING;
    }

    public VaadinSessionState getState() {
        this.checkHasLock();
        return this.state;
    }

    protected void setState(VaadinSessionState state) {
        this.checkHasLock();
        assert (this.isValidChange(state)) : "Invalid session state change " + this.state + "->" + state;
        this.state = state;
        if (VaadinSessionState.CLOSED.equals((Object)state)) {
            this.session = null;
        }
    }

    private boolean isValidChange(VaadinSessionState newState) {
        return this.state == VaadinSessionState.OPEN && newState == VaadinSessionState.CLOSING || this.state == VaadinSessionState.CLOSING && newState == VaadinSessionState.CLOSED;
    }

    Logger getLogger() {
        return LOGGER;
    }

    public void accessSynchronously(Command command) {
        VaadinService.verifyNoOtherSessionLocked(this);
        Map<Class<?>, CurrentInstance> old = null;
        this.lock();
        try {
            old = CurrentInstance.setCurrent(this);
            command.execute();
        }
        finally {
            this.unlock();
            if (old != null) {
                CurrentInstance.restoreInstances(old);
            }
        }
    }

    public Future<Void> access(Command command) {
        return this.getService().accessSession(this, command);
    }

    public Queue<FutureAccess> getPendingAccessQueue() {
        return this.pendingAccessQueue;
    }

    public String getPushId() {
        this.checkHasLock();
        return this.pushId;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        Map<Class<?>, CurrentInstance> old = CurrentInstance.setCurrent(this);
        try {
            stream.defaultReadObject();
            this.requestHandlers.remove(null);
            this.destroyListeners.remove(null);
            this.uIs = (Map)stream.readObject();
            this.resourceRegistry = (StreamResourceRegistry)stream.readObject();
            this.pendingAccessQueue = new ConcurrentLinkedQueue();
        }
        finally {
            CurrentInstance.restoreInstances(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        Map<Class<?>, CurrentInstance> instanceMap = CurrentInstance.setCurrent(this);
        try {
            ApplicationConfiguration appConfiguration;
            boolean serializeUIs = true;
            if (this.getService() != null && !(appConfiguration = ApplicationConfiguration.get(this.getService().getContext())).isProductionMode() && !appConfiguration.isDevModeSessionSerializationEnabled()) {
                serializeUIs = false;
            }
            stream.defaultWriteObject();
            if (serializeUIs) {
                stream.writeObject(this.uIs);
                stream.writeObject(this.resourceRegistry);
            } else {
                stream.writeObject(new HashMap());
                stream.writeObject(new StreamResourceRegistry(this));
            }
        }
        finally {
            CurrentInstance.restoreInstances(instanceMap);
        }
    }

    public void refreshTransients(WrappedSession wrappedSession, VaadinService vaadinService) {
        this.session = wrappedSession;
        this.service = vaadinService;
        this.refreshLock();
    }

    public StreamResourceRegistry getResourceRegistry() {
        return this.resourceRegistry;
    }

    private boolean isInitialized() {
        boolean isInitialized;
        boolean bl = isInitialized = this.service != null;
        assert (isInitialized || this.session == null) : "The wrapped session must be null if the service is null (which happens after deserialization)";
        return isInitialized;
    }

    public long getLastLocked() {
        return this.lastLocked;
    }

    public long getLastUnlocked() {
        return this.lastUnlocked;
    }

    public Element findElement(int uiId, int nodeId) throws IllegalArgumentException {
        this.checkHasLock();
        UI ui = this.getUIById(uiId);
        if (ui == null) {
            throw new IllegalArgumentException("Unable to find the UI for UI id " + uiId);
        }
        StateNode node = ui.getInternals().getStateTree().getNodeById(nodeId);
        if (node == null) {
            throw new IllegalArgumentException("Unable to find the component for node " + nodeId + " in the UI " + uiId);
        }
        return Element.get(node);
    }
}

