/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.hotswap;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.hotswap.HotswapCompleteEvent;
import com.vaadin.flow.hotswap.VaadinHotswapper;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.BrowserLiveReloadAccessor;
import com.vaadin.flow.router.internal.RouteTarget;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.ServiceDestroyEvent;
import com.vaadin.flow.server.ServiceDestroyListener;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.SessionDestroyEvent;
import com.vaadin.flow.server.SessionDestroyListener;
import com.vaadin.flow.server.SessionInitEvent;
import com.vaadin.flow.server.SessionInitListener;
import com.vaadin.flow.server.UIInitEvent;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import elemental.json.Json;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hotswapper
implements ServiceDestroyListener,
SessionInitListener,
SessionDestroyListener,
UIInitListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(Hotswapper.class);
    private final Set<VaadinSession> sessions = ConcurrentHashMap.newKeySet();
    private final VaadinService vaadinService;
    private final BrowserLiveReload liveReload;
    private volatile boolean serviceDestroyed = false;

    Hotswapper(VaadinService vaadinService) {
        this.vaadinService = Objects.requireNonNull(vaadinService, "VaadinService instance is mandatory");
        this.liveReload = BrowserLiveReloadAccessor.getLiveReloadFromService(vaadinService).orElse(null);
    }

    public void onHotswap(String[] classes, Boolean redefined) {
        if (this.serviceDestroyed) {
            LOGGER.debug("Hotswap classes change event ignored because VaadinService has been destroyed.");
            return;
        }
        if (classes == null || classes.length == 0) {
            LOGGER.debug("Hotswap event ignored because Hotswapper has been called without changes to apply.");
            return;
        }
        this.onHotswapInternal(Arrays.stream(classes).map(Hotswapper::resolveClass).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new)), redefined);
    }

    public void onHotswap(URI[] createdResources, URI[] modifiedResources, URI[] deletedResources) {
        if (this.serviceDestroyed) {
            LOGGER.debug("Hotswap resources change event ignored because VaadinService has been destroyed.");
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Created resources: {}, modified resources: {}, deletedResources: {}.", new Object[]{createdResources, modifiedResources, deletedResources});
        }
        if (this.anyMatches(".*/vaadin-i18n/.*\\.properties", createdResources, modifiedResources, deletedResources)) {
            ResourceBundle.clearCache();
            this.liveReload.sendHmrEvent("translations-update", Json.createObject());
            EnumMap<UIRefreshStrategy, List<UI>> refreshActions = new EnumMap<UIRefreshStrategy, List<UI>>(UIRefreshStrategy.class);
            this.forEachActiveUI(ui -> {
                UIRefreshStrategy strategy = ui.getPushConfiguration().getPushMode().isEnabled() ? UIRefreshStrategy.PUSH_REFRESH_CHAIN : UIRefreshStrategy.REFRESH;
                refreshActions.computeIfAbsent(strategy, k -> new ArrayList()).add(ui);
            });
            this.triggerClientUpdate(refreshActions, false);
        }
    }

    private boolean anyMatches(String regexp, URI[] ... resources) {
        URI[][] uRIArray = resources;
        int n = uRIArray.length;
        for (int i = 0; i < n; ++i) {
            URI[] uris;
            for (URI uri : uris = uRIArray[i]) {
                if (!uri.toString().matches(regexp)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onHotswapInternal(HashSet<Class<?>> classes, Boolean redefined) {
        boolean uiTreeNeedsRefresh;
        if (classes == null || classes.isEmpty()) {
            LOGGER.debug("Hotswap event ignored because Hotswapper has been called without changes to apply.");
            return;
        }
        Lookup lookup = this.vaadinService.getContext().getAttribute(Lookup.class);
        if (lookup == null) {
            throw new IllegalStateException("Lookup not found in VaadinContext");
        }
        boolean forceBrowserReload = false;
        Collection<VaadinHotswapper> hotSwappers = lookup.lookupAll(VaadinHotswapper.class);
        for (VaadinHotswapper vaadinHotswapper : hotSwappers) {
            try {
                forceBrowserReload |= vaadinHotswapper.onClassLoadEvent(this.vaadinService, classes, (boolean)redefined);
            }
            catch (Exception ex) {
                LOGGER.debug("Global hotswap failed executing {}", (Object)vaadinHotswapper, (Object)ex);
            }
        }
        Set<VaadinSession> vaadinSessions = Set.copyOf(this.sessions);
        for (VaadinSession vaadinSession : vaadinSessions) {
            try {
                vaadinSession.getLockInstance().lock();
                for (VaadinHotswapper hotSwapper : hotSwappers) {
                    try {
                        forceBrowserReload |= hotSwapper.onClassLoadEvent(vaadinSession, classes, (boolean)redefined);
                    }
                    catch (Exception ex) {
                        LOGGER.debug("Hotswap failed executing {} for Vaadin session {}", new Object[]{hotSwapper, vaadinSession.getSession().getId(), ex});
                    }
                }
            }
            finally {
                vaadinSession.getLockInstance().unlock();
            }
        }
        EnumMap<UIRefreshStrategy, List<UI>> enumMap = this.computeRefreshStrategies(vaadinSessions, classes);
        boolean bl = uiTreeNeedsRefresh = !enumMap.isEmpty();
        if (forceBrowserReload || uiTreeNeedsRefresh) {
            this.triggerClientUpdate(enumMap, forceBrowserReload);
        }
        HotswapCompleteEvent event = new HotswapCompleteEvent(this.vaadinService, classes, redefined);
        for (VaadinHotswapper hotSwapper : hotSwappers) {
            try {
                hotSwapper.onHotswapComplete(event);
            }
            catch (Exception ex) {
                LOGGER.debug("Hotswap complete event handling failed for {}", (Object)hotSwapper, (Object)ex);
            }
        }
    }

    private EnumMap<UIRefreshStrategy, List<UI>> computeRefreshStrategies(Set<VaadinSession> vaadinSessions, Set<Class<?>> changedClasses) {
        EnumMap<UIRefreshStrategy, List<UI>> uisToRefresh = new EnumMap<UIRefreshStrategy, List<UI>>(UIRefreshStrategy.class);
        this.forEachActiveUI(ui -> uisToRefresh.computeIfAbsent(this.computeRefreshStrategy((UI)ui, changedClasses), k -> new ArrayList()).add(ui));
        uisToRefresh.remove((Object)UIRefreshStrategy.SKIP);
        return uisToRefresh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forEachActiveUI(Consumer<UI> consumer) {
        for (VaadinSession session : Set.copyOf(this.sessions)) {
            session.getLockInstance().lock();
            try {
                session.getUIs().stream().filter(ui -> !ui.isClosing()).forEach(consumer);
            }
            finally {
                session.getLockInstance().unlock();
            }
        }
    }

    private UIRefreshStrategy computeRefreshStrategy(UI ui, Set<Class<?>> changedClasses) {
        UIRefreshStrategy refreshStrategy;
        boolean pushEnabled;
        block5: {
            block6: {
                String currentPath;
                RouteRegistry registry;
                RouteTarget routeTarget;
                ArrayList<HasElement> targetsChain = new ArrayList<HasElement>(ui.getActiveRouterTargetsChain());
                if (targetsChain.isEmpty()) {
                    return UIRefreshStrategy.SKIP;
                }
                HasElement route = (HasElement)targetsChain.get(0);
                pushEnabled = ui.getPushConfiguration().getPushMode().isEnabled();
                List targetChainChangedItems = changedClasses.stream().flatMap(clazz -> targetsChain.stream().filter(chainItem -> clazz.isAssignableFrom(chainItem.getClass()))).distinct().toList();
                refreshStrategy = !targetChainChangedItems.isEmpty() ? (targetChainChangedItems.stream().allMatch(chainItem -> chainItem == route) ? UIRefreshStrategy.PUSH_REFRESH_ROUTE : UIRefreshStrategy.PUSH_REFRESH_CHAIN) : Hotswapper.computeRefreshStrategyForUITree(ui, changedClasses, targetsChain, route);
                if (refreshStrategy != UIRefreshStrategy.SKIP || (routeTarget = (registry = ui.getInternals().getRouter().getRegistry()).getNavigationRouteTarget(currentPath = ui.getActiveViewLocation().getPath()).getRouteTarget()) == null) break block5;
                if (routeTarget.getParentLayouts().stream().anyMatch(changedClasses::contains)) break block6;
                if (!RouteUtil.isAutolayoutEnabled(routeTarget.getTarget(), currentPath) || !registry.hasLayout(currentPath)) break block5;
                if (!RouteUtil.collectRouteParentLayouts(registry.getLayout(currentPath)).stream().anyMatch(changedClasses::contains)) break block5;
            }
            refreshStrategy = UIRefreshStrategy.PUSH_REFRESH_CHAIN;
        }
        if (refreshStrategy != UIRefreshStrategy.SKIP && !pushEnabled) {
            refreshStrategy = UIRefreshStrategy.REFRESH;
        }
        return refreshStrategy;
    }

    private static UIRefreshStrategy computeRefreshStrategyForUITree(UI ui, Set<Class<?>> changedClasses, List<HasElement> targetsChain, HasElement route) {
        UIRefreshStrategy refreshStrategy = UIRefreshStrategy.SKIP;
        LinkedList stack = new LinkedList();
        ui.getChildren().forEach(stack::add);
        while (!stack.isEmpty()) {
            Component child = (Component)stack.removeFirst();
            if (changedClasses.stream().anyMatch(clazz -> clazz.isAssignableFrom(child.getClass()))) {
                Component parent = child.getParent().orElse(null);
                while (parent != null) {
                    if (!targetsChain.contains(parent)) {
                        parent = parent.getParent().orElse(null);
                        continue;
                    }
                    if (parent == route) {
                        refreshStrategy = UIRefreshStrategy.PUSH_REFRESH_ROUTE;
                        parent = null;
                        continue;
                    }
                    refreshStrategy = UIRefreshStrategy.PUSH_REFRESH_CHAIN;
                    parent = null;
                    stack.clear();
                }
                continue;
            }
            child.getChildren().forEach(stack::add);
        }
        return refreshStrategy;
    }

    private void triggerClientUpdate(EnumMap<UIRefreshStrategy, List<UI>> uisToRefresh, boolean forceReload) {
        boolean refreshRequested = uisToRefresh.containsKey((Object)UIRefreshStrategy.REFRESH);
        if (forceReload || refreshRequested) {
            if (this.liveReload == null) {
                LOGGER.debug("A change to one or more classes requires a browser page reload, but BrowserLiveReload is not available. Please reload the browser page manually to make changes effective.");
            } else if (forceReload) {
                LOGGER.debug("Triggering browser live reload because of classes changes");
                this.liveReload.reload();
            } else {
                LOGGER.debug("Triggering browser live refresh because of classes changes");
                this.liveReload.refresh(true);
            }
        } else {
            LOGGER.debug("Triggering re-navigation to current route for UIs affected by classes changes.");
            for (UIRefreshStrategy action : uisToRefresh.keySet()) {
                uisToRefresh.get((Object)action).forEach(ui -> ui.access(() -> ui.refreshCurrentRoute(action == UIRefreshStrategy.PUSH_REFRESH_CHAIN)));
            }
        }
    }

    private static Class<?> resolveClass(String className) {
        try {
            return Class.forName(className, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("Cannot resolve class {}", (Object)className, (Object)e);
            return null;
        }
    }

    @Override
    public void sessionInit(SessionInitEvent event) throws ServiceException {
        this.sessions.add(event.getSession());
    }

    @Override
    public void sessionDestroy(SessionDestroyEvent event) {
        this.sessions.remove(event.getSession());
    }

    @Override
    public void serviceDestroy(ServiceDestroyEvent event) {
        this.serviceDestroyed = true;
        this.sessions.clear();
    }

    @Override
    public void uiInit(UIInitEvent event) {
        this.sessions.add(event.getUI().getSession());
    }

    public static Optional<Hotswapper> register(VaadinService vaadinService) {
        if (!vaadinService.getDeploymentConfiguration().isProductionMode()) {
            Hotswapper hotswapper = new Hotswapper(vaadinService);
            vaadinService.addUIInitListener(hotswapper);
            vaadinService.addSessionInitListener(hotswapper);
            vaadinService.addSessionDestroyListener(hotswapper);
            vaadinService.addServiceDestroyListener(hotswapper);
            return Optional.of(hotswapper);
        }
        return Optional.empty();
    }

    private static enum UIRefreshStrategy {
        RELOAD,
        REFRESH,
        PUSH_REFRESH_ROUTE,
        PUSH_REFRESH_CHAIN,
        SKIP;

    }
}

