/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.internal.AbstractNavigationStateRenderer;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ComponentTracker {
    private static Map<Component, Location> createLocation = Collections.synchronizedMap(new WeakHashMap());
    private static Map<Component, Location> attachLocation = Collections.synchronizedMap(new WeakHashMap());
    private static Boolean disabled = null;
    private static String[] prefixesToSkip = new String[]{"com.vaadin.flow.component.", "com.vaadin.flow.di.", "com.vaadin.flow.dom.", "com.vaadin.flow.internal.", "com.vaadin.flow.spring.", "com.vaadin.cdi.", "java.", "jdk.", "org.springframework.beans.", "org.jboss.weld."};

    public static Location findCreate(Component component) {
        return createLocation.get(component);
    }

    public static void trackCreate(Component component) {
        if (ComponentTracker.isDisabled()) {
            return;
        }
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        Location location = ComponentTracker.findRelevantLocation(component.getClass(), stack, null);
        if (ComponentTracker.isNavigatorCreate(location)) {
            location = ComponentTracker.findRelevantLocation(null, stack, null);
        }
        createLocation.put(component, location);
    }

    public static Location findAttach(Component component) {
        return attachLocation.get(component);
    }

    public static void trackAttach(Component component) {
        if (ComponentTracker.isDisabled()) {
            return;
        }
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        Location location = ComponentTracker.findRelevantLocation(component.getClass(), stack, ComponentTracker.findCreate(component));
        if (ComponentTracker.isNavigatorCreate(location)) {
            location = createLocation.get(component);
        }
        attachLocation.put(component, location);
    }

    public static void refreshLocation(Location location, int offset) {
        ComponentTracker.refreshLocation(createLocation, location, offset);
        ComponentTracker.refreshLocation(attachLocation, location, offset);
    }

    private static void refreshLocation(Map<Component, Location> targetRef, Location location, int offset) {
        HashMap updatedLocations = new HashMap();
        targetRef.entrySet().stream().filter(e -> Objects.equals(((Location)e.getValue()).className, location.className)).filter(e -> ((Location)e.getValue()).lineNumber > location.lineNumber).forEach(e -> {
            Location l = (Location)e.getValue();
            updatedLocations.put((Component)e.getKey(), new Location(l.className, l.filename, l.methodName, l.lineNumber + offset));
        });
        targetRef.putAll(updatedLocations);
    }

    private static boolean isNavigatorCreate(Location location) {
        return location.className().equals(AbstractNavigationStateRenderer.class.getName());
    }

    private static Location findRelevantLocation(Class<? extends Component> excludeClass, StackTraceElement[] stack, Location preferredClass) {
        Optional<StackTraceElement> preferredCandidate;
        List candidates = Stream.of(stack).filter(e -> excludeClass == null || !e.getClassName().equals(excludeClass.getName())).filter(e -> {
            for (String prefixToSkip : prefixesToSkip) {
                if (!e.getClassName().startsWith(prefixToSkip)) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        if (preferredClass != null && (preferredCandidate = candidates.stream().filter(e -> e.getClassName().equals(preferredClass.className())).findFirst()).isPresent()) {
            return ComponentTracker.toLocation(preferredCandidate.get());
        }
        return ComponentTracker.toLocation(candidates.stream().findFirst().orElse(null));
    }

    private static boolean isDisabled() {
        if (disabled != null) {
            return disabled;
        }
        VaadinService service = VaadinService.getCurrent();
        if (service == null) {
            return true;
        }
        VaadinContext context = service.getContext();
        if (context == null) {
            return true;
        }
        ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.get(context);
        if (applicationConfiguration == null) {
            return true;
        }
        disabled = applicationConfiguration.isProductionMode() || !applicationConfiguration.getBooleanProperty("devmode.componentTracker.enabled", true);
        return disabled;
    }

    private static Location toLocation(StackTraceElement stackTraceElement) {
        if (stackTraceElement == null) {
            return null;
        }
        String className = stackTraceElement.getClassName();
        String fileName = stackTraceElement.getFileName();
        String methodName = stackTraceElement.getMethodName();
        int lineNumber = stackTraceElement.getLineNumber();
        return new Location(className, fileName, methodName, lineNumber);
    }

    public static class Location
    implements Serializable {
        private static final Pattern MAYBE_INNER_CLASS = Pattern.compile("(.*\\.[^$.]+)\\$[^.]+$");
        private final String className;
        private final String filename;
        private final String methodName;
        private final int lineNumber;

        public Location(String className, String filename, String methodName, int lineNumber) {
            this.className = className;
            this.filename = filename;
            this.methodName = methodName;
            this.lineNumber = lineNumber;
        }

        public String className() {
            return this.className;
        }

        public String filename() {
            return this.filename;
        }

        public String methodName() {
            return this.methodName;
        }

        public int lineNumber() {
            return this.lineNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Location location = (Location)o;
            if (this.lineNumber != location.lineNumber) {
                return false;
            }
            if (!Objects.equals(this.className, location.className)) {
                return false;
            }
            if (!Objects.equals(this.filename, location.filename)) {
                return false;
            }
            return Objects.equals(this.methodName, location.methodName);
        }

        public int hashCode() {
            int result = this.className != null ? this.className.hashCode() : 0;
            result = 31 * result + (this.filename != null ? this.filename.hashCode() : 0);
            result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
            result = 31 * result + this.lineNumber;
            return result;
        }

        public File findSourceFile(AbstractConfiguration configuration) {
            Matcher matcher;
            String cls = this.className();
            int indexOfExt = this.filename().lastIndexOf(".");
            String ext = this.filename().substring(indexOfExt);
            if (!ext.equals(".java") && !ext.equals(".kt")) {
                return null;
            }
            String filenameNoExt = this.filename().substring(0, indexOfExt);
            if (!cls.endsWith(filenameNoExt) && (matcher = MAYBE_INNER_CLASS.matcher(cls)).find()) {
                cls = matcher.group(1);
            }
            if (!cls.endsWith(filenameNoExt)) {
                return null;
            }
            File src = configuration.getJavaSourceFolder();
            String path = src.getPath().replaceAll("\\\\", "/");
            if (ext.equals(".kt") && path.endsWith("/java")) {
                src = new File(path.substring(0, path.lastIndexOf("/java")) + "/kotlin");
            }
            File javaFile = new File(src, cls.replace(".", File.separator) + ext);
            return javaFile;
        }

        @Deprecated
        public File findJavaFile(AbstractConfiguration configuration) {
            return this.findSourceFile(configuration);
        }

        public String toString() {
            return "Component '" + this.className + "' at '" + this.filename + "' (" + this.methodName + " LINE " + this.lineNumber + ")";
        }
    }
}

