/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.server.PWA;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.frontend.scanner.AbstractDependenciesScanner;
import com.vaadin.flow.server.frontend.scanner.ChunkInfo;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.CssData;
import com.vaadin.flow.server.frontend.scanner.ThemeData;
import com.vaadin.flow.server.frontend.scanner.ThemeWrapper;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.NoTheme;
import com.vaadin.flow.theme.Theme;
import com.vaadin.flow.theme.ThemeDefinition;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FullDependenciesScanner
extends AbstractDependenciesScanner {
    private static final String COULD_NOT_LOAD_ERROR_MSG = "Could not load annotation class ";
    private static final String VALUE = "value";
    private static final String DEVELOPMENT_ONLY = "developmentOnly";
    private static final String VERSION = "version";
    private ThemeDefinition themeDefinition;
    private AbstractTheme themeInstance;
    private PwaConfiguration pwaConfiguration;
    private Set<String> classes = new HashSet<String>();
    private Map<String, String> packages;
    private Map<String, String> devPackages;
    private List<CssData> cssData;
    private List<String> scripts;
    private List<String> scriptsDevelopment;
    private List<String> modules;
    private List<String> modulesDevelopment;
    private final Class<?> abstractTheme;
    private final SerializableBiFunction<Class<?>, Class<? extends Annotation>, List<? extends Annotation>> annotationFinder;

    FullDependenciesScanner(ClassFinder finder, FeatureFlags featureFlags) {
        this(finder, AnnotationReader::getAnnotationsFor, featureFlags);
    }

    FullDependenciesScanner(ClassFinder finder, SerializableBiFunction<Class<?>, Class<? extends Annotation>, List<? extends Annotation>> annotationFinder, FeatureFlags featureFlags) {
        super(finder, featureFlags);
        long start = System.currentTimeMillis();
        this.annotationFinder = (clazz, loadedAnnotation) -> {
            try {
                return (List)annotationFinder.apply((Class<?>)clazz, (Class<? extends Annotation>)loadedAnnotation);
            }
            catch (RuntimeException exception) {
                this.getLogger().error("Could not read {} annotation from class {}.", new Object[]{loadedAnnotation.getName(), clazz.getName(), exception});
                throw exception;
            }
        };
        try {
            this.abstractTheme = finder.loadClass(AbstractTheme.class.getName());
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException("Could not load " + AbstractTheme.class.getName() + " class", exception);
        }
        this.packages = new HashMap<String, String>();
        this.devPackages = new HashMap<String, String>();
        this.discoverPackages(this.packages, this.devPackages);
        LinkedHashSet<String> modulesSet = new LinkedHashSet<String>();
        LinkedHashSet<String> modulesSetDevelopment = new LinkedHashSet<String>();
        LinkedHashSet<String> scriptsSet = new LinkedHashSet<String>();
        LinkedHashSet<String> scriptsSetDevelopment = new LinkedHashSet<String>();
        this.discoverTheme();
        this.collectScripts(modulesSet, modulesSetDevelopment, JsModule.class);
        this.collectScripts(scriptsSet, scriptsSetDevelopment, JavaScript.class);
        this.cssData = this.discoverCss();
        this.modules = new ArrayList<String>(modulesSet);
        this.modulesDevelopment = new ArrayList<String>(modulesSetDevelopment);
        this.scripts = new ArrayList<String>(scriptsSet);
        this.scriptsDevelopment = new ArrayList<String>(scriptsSetDevelopment);
        this.pwaConfiguration = this.discoverPwa();
        this.getLogger().info("Visited {} classes. Took {} ms.", (Object)this.getClasses().size(), (Object)(System.currentTimeMillis() - start));
    }

    @Override
    public Map<String, String> getPackages() {
        return Collections.unmodifiableMap(this.packages);
    }

    @Override
    public Map<String, String> getDevPackages() {
        return Collections.unmodifiableMap(this.devPackages);
    }

    @Override
    public Map<ChunkInfo, List<String>> getModules() {
        return Collections.singletonMap(ChunkInfo.GLOBAL, Collections.unmodifiableList(this.modules));
    }

    @Override
    public Map<ChunkInfo, List<String>> getModulesDevelopment() {
        return Collections.singletonMap(ChunkInfo.GLOBAL, Collections.unmodifiableList(this.modulesDevelopment));
    }

    @Override
    public Map<ChunkInfo, List<String>> getScripts() {
        return Collections.singletonMap(ChunkInfo.GLOBAL, new ArrayList<String>(this.scripts));
    }

    @Override
    public Map<ChunkInfo, List<String>> getScriptsDevelopment() {
        return Collections.singletonMap(ChunkInfo.GLOBAL, new ArrayList<String>(this.scriptsDevelopment));
    }

    @Override
    public Map<ChunkInfo, List<CssData>> getCss() {
        return Collections.singletonMap(ChunkInfo.GLOBAL, new ArrayList<CssData>(this.cssData));
    }

    @Override
    public ThemeDefinition getThemeDefinition() {
        return this.themeDefinition;
    }

    @Override
    public AbstractTheme getTheme() {
        return this.themeInstance;
    }

    @Override
    public PwaConfiguration getPwaConfiguration() {
        return this.pwaConfiguration;
    }

    @Override
    public Set<String> getClasses() {
        return Collections.unmodifiableSet(this.classes);
    }

    private CssData createCssData(Annotation cssImport) {
        String id = this.adaptCssValue(cssImport, "id");
        String include = this.adaptCssValue(cssImport, "include");
        String themeFor = this.adaptCssValue(cssImport, "themeFor");
        String value = this.adaptCssValue(cssImport, VALUE);
        return new CssData(value, id, include, themeFor);
    }

    private String adaptCssValue(Annotation cssImport, String method) {
        String value = this.getAnnotationValueAsString(cssImport, method);
        if (value == null) {
            return value;
        }
        return value.isEmpty() ? null : value;
    }

    private void discoverPackages(Map<String, String> packages, Map<String, String> devPackages) {
        try {
            Class loadedAnnotation = this.getFinder().loadClass(NpmPackage.class.getName());
            Set<Class<?>> annotatedClasses = this.getFinder().getAnnotatedClasses(loadedAnnotation);
            HashSet<String> logs = new HashSet<String>();
            for (Class<?> clazz : annotatedClasses) {
                this.classes.add(clazz.getName());
                List packageAnnotations = (List)this.annotationFinder.apply(clazz, loadedAnnotation);
                packageAnnotations.forEach(annotation -> {
                    Map result;
                    String value = this.getAnnotationValueAsString((Annotation)annotation, VALUE);
                    String version = this.getAnnotationValueAsString((Annotation)annotation, VERSION);
                    boolean dev = this.getAnnotationValueAsBoolean((Annotation)annotation, "dev");
                    logs.add(value + " " + version + " " + clazz.getName());
                    Map map = result = dev ? devPackages : packages;
                    if (result.containsKey(value) && !((String)result.get(value)).equals(version)) {
                        String foundVersions = "[" + (String)result.get(value) + ", " + version + "]";
                        this.getLogger().warn("Multiple npm versions for {} found:  {}. First version found '{}' will be considered.", new Object[]{value, foundVersions, result.get(value)});
                    } else {
                        result.put(value, version);
                    }
                });
            }
            this.debug("npm dependencies", logs);
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException(COULD_NOT_LOAD_ERROR_MSG + NpmPackage.class.getName(), exception);
        }
    }

    private List<CssData> discoverCss() {
        try {
            Class loadedAnnotation = this.getFinder().loadClass(CssImport.class.getName());
            Set<Class<?>> annotatedClasses = this.getFinder().getAnnotatedClasses(loadedAnnotation);
            LinkedHashSet result = new LinkedHashSet();
            for (Class<?> clazz : annotatedClasses) {
                this.classes.add(clazz.getName());
                List imports = (List)this.annotationFinder.apply(clazz, loadedAnnotation);
                imports.stream().forEach(imp -> result.add(this.createCssData((Annotation)imp)));
            }
            return new ArrayList<CssData>(result);
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException(COULD_NOT_LOAD_ERROR_MSG + CssData.class.getName(), exception);
        }
    }

    private <T extends Annotation> void collectScripts(LinkedHashSet<String> target, LinkedHashSet<String> targetDevOnly, Class<T> annotationType) {
        try {
            HashSet<String> logs = new HashSet<String>();
            Class loadedAnnotation = this.getFinder().loadClass(annotationType.getName());
            Set<Class<?>> annotatedClasses = this.getFinder().getAnnotatedClasses(loadedAnnotation);
            annotatedClasses.stream().filter(c -> !this.isExperimental(c.getName())).forEach(clazz -> ((List)this.annotationFinder.apply((Class<?>)clazz, loadedAnnotation)).forEach(ann -> {
                String value = this.getAnnotationValueAsString((Annotation)ann, VALUE);
                Boolean developmentOnly = this.getAnnotationValueAsBoolean((Annotation)ann, DEVELOPMENT_ONLY);
                this.classes.add(clazz.getName());
                if (this.isNotActiveThemeClass((Class<?>)clazz)) {
                    return;
                }
                if (developmentOnly.booleanValue()) {
                    targetDevOnly.add(value);
                } else {
                    target.add(value);
                }
                logs.add(value + " " + clazz);
            }));
            this.debug("@" + annotationType.getSimpleName(), logs);
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException(COULD_NOT_LOAD_ERROR_MSG + annotationType.getName(), exception);
        }
    }

    private void debug(String label, Set<String> log) {
        if (this.getLogger().isDebugEnabled()) {
            log.add("\n List of " + label + " found in the project:");
            this.getLogger().debug(log.stream().sorted().collect(Collectors.joining("\n  - ")));
        }
    }

    private void discoverTheme() {
        ThemeData data = this.verifyTheme();
        if (data == null) {
            this.setupTheme(this.getLumoTheme(), "", "");
            return;
        }
        if (data.isNotheme()) {
            return;
        }
        try {
            Class theme = this.getFinder().loadClass(data.getThemeClass());
            this.setupTheme(theme, data.getVariant(), data.getThemeName());
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException("Could not load theme class " + data.getThemeClass(), exception);
        }
    }

    private void setupTheme(Class<? extends AbstractTheme> theme, String variant, String name) {
        if (theme != null) {
            this.themeDefinition = new ThemeDefinition(theme, variant, name);
            try {
                this.themeInstance = new ThemeWrapper(theme);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Unable to create a new '" + theme.getName() + "' theme instance", e);
            }
        }
    }

    private ThemeData verifyTheme() {
        try {
            Class loadedThemeAnnotation = this.getFinder().loadClass(Theme.class.getName());
            Set<Class<?>> annotatedClasses = this.getFinder().getAnnotatedClasses(loadedThemeAnnotation);
            Set<ThemeData> themes = annotatedClasses.stream().flatMap(clazz -> ((List)this.annotationFinder.apply((Class<?>)clazz, loadedThemeAnnotation)).stream()).map(theme -> new ThemeData(((Class)this.getAnnotationValue((Annotation)theme, "themeClass")).getName(), this.getAnnotationValueAsString((Annotation)theme, "variant"), this.getAnnotationValueAsString((Annotation)theme, VALUE))).collect(Collectors.toSet());
            Class loadedNoThemeAnnotation = this.getFinder().loadClass(NoTheme.class.getName());
            Set notThemeClasses = this.getFinder().getAnnotatedClasses(loadedNoThemeAnnotation).stream().collect(Collectors.toSet());
            if (themes.size() > 1) {
                throw new IllegalStateException("Using multiple different Theme configurations is not supported. The list of found themes:\n" + this.getThemesList(themes));
            }
            if (!themes.isEmpty() && !notThemeClasses.isEmpty()) {
                throw new IllegalStateException("@" + Theme.class.getSimpleName() + " (" + this.getThemesList(themes) + ") and @" + NoTheme.class.getSimpleName() + " annotations can't be used simultaneously.");
            }
            if (!notThemeClasses.isEmpty()) {
                return ThemeData.createNoTheme();
            }
            return themes.isEmpty() ? null : themes.iterator().next();
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException("Could not load theme annotation class", exception);
        }
    }

    private String getThemesList(Collection<ThemeData> themes) {
        return themes.stream().map(theme -> "themeClass = '" + theme.getThemeClass() + "' and variant = '" + theme.getVariant() + "' and name = '" + theme.getThemeName() + "'").collect(Collectors.joining(", "));
    }

    private boolean isNotActiveThemeClass(Class<?> clazz) {
        if (!this.abstractTheme.isAssignableFrom(clazz)) {
            return false;
        }
        ThemeDefinition themeDef = this.getThemeDefinition();
        if (themeDef == null) {
            return true;
        }
        return !themeDef.getTheme().getName().equals(clazz.getName());
    }

    private String getAnnotationValueAsString(Annotation target, String methodName) {
        Object result = this.getAnnotationValue(target, methodName);
        return result == null ? null : result.toString();
    }

    private Boolean getAnnotationValueAsBoolean(Annotation target, String methodName) {
        Object result = this.getAnnotationValue(target, methodName);
        return result == null ? null : (Boolean)result;
    }

    private Object getAnnotationValue(Annotation target, String methodName) {
        try {
            Object value = target.getClass().getDeclaredMethod(methodName, new Class[0]).invoke((Object)target, new Object[0]);
            if (value == null) {
                value = target.getClass().getDeclaredMethod(methodName, new Class[0]).getDefaultValue();
            }
            return value;
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(String.format("Failed to access method '%s' in annotation interface '%s', should not be happening due to JLS definition of annotation interface", methodName, target), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(String.format("Got an exception by invoking method '%s' from annotation '%s'", methodName, target), e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Annotation '%s' has no method named `%s", target, methodName), e);
        }
    }

    private PwaConfiguration discoverPwa() {
        try {
            Class loadedPWAAnnotation = this.getFinder().loadClass(PWA.class.getName());
            Set<Class<?>> annotatedClasses = this.getFinder().getAnnotatedClasses(loadedPWAAnnotation);
            if (annotatedClasses.isEmpty()) {
                return new PwaConfiguration();
            }
            if (annotatedClasses.size() != 1) {
                throw new IllegalStateException(ERROR_INVALID_PWA_ANNOTATION + " Found " + annotatedClasses.size() + " implementations: " + annotatedClasses);
            }
            Class<?> hopefullyAppShellClass = annotatedClasses.iterator().next();
            if (!Arrays.stream(hopefullyAppShellClass.getInterfaces()).map(Class::getName).collect(Collectors.toList()).contains(AppShellConfigurator.class.getName())) {
                throw new IllegalStateException(ERROR_INVALID_PWA_ANNOTATION + " " + hopefullyAppShellClass.getName() + " does not implement " + AppShellConfigurator.class.getSimpleName());
            }
            Annotation pwa = (Annotation)((List)this.annotationFinder.apply(hopefullyAppShellClass, loadedPWAAnnotation)).get(0);
            String name = this.getAnnotationValueAsString(pwa, "name");
            String shortName = this.getAnnotationValueAsString(pwa, "shortName");
            String description = this.getAnnotationValueAsString(pwa, "description");
            String backgroundColor = this.getAnnotationValueAsString(pwa, "backgroundColor");
            String themeColor = this.getAnnotationValueAsString(pwa, "themeColor");
            String iconPath = this.getAnnotationValueAsString(pwa, "iconPath");
            String manifestPath = this.getAnnotationValueAsString(pwa, "manifestPath");
            String offlinePath = this.getAnnotationValueAsString(pwa, "offlinePath");
            String display = this.getAnnotationValueAsString(pwa, "display");
            String startPath = this.getAnnotationValueAsString(pwa, "startPath");
            String[] offlineResources = (String[])this.getAnnotationValue(pwa, "offlineResources");
            boolean offline = (Boolean)this.getAnnotationValue(pwa, "offline");
            assert (shortName != null);
            return new PwaConfiguration(true, name, shortName, description, backgroundColor, themeColor, iconPath, manifestPath, offlinePath, display, startPath, offlineResources, offline);
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException("Could not load PWA annotation class", exception);
        }
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

