/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.router.RouteParameterFormatOption;
import com.vaadin.flow.router.RouteParameterRegex;
import com.vaadin.flow.router.internal.RouteSegment;
import java.io.Serializable;
import java.util.Optional;
import java.util.Set;

class RouteFormat
implements Serializable {
    RouteFormat() {
    }

    static boolean hasParameters(String template) {
        return template.contains(":");
    }

    static boolean hasRequiredParameter(String template) {
        int index = -1;
        while ((index = template.indexOf(58, index + 1)) >= 0) {
            int optional;
            int slashIndex;
            int regexIndex = template.indexOf(40, index);
            int parameterNameEnding = Math.min(regexIndex, slashIndex = template.indexOf(47, index));
            if (parameterNameEnding < 0) {
                int n = parameterNameEnding = regexIndex == -1 ? slashIndex : regexIndex;
            }
            if (parameterNameEnding < 0) {
                parameterNameEnding = template.length();
            }
            if (0 < (optional = template.indexOf(63, index)) && optional < parameterNameEnding) continue;
            int wildcard = template.indexOf(42, index);
            return 0 >= wildcard || wildcard >= parameterNameEnding;
        }
        return false;
    }

    static boolean isParameter(String segmentTemplate) {
        return segmentTemplate.startsWith(":");
    }

    static boolean isOptionalParameter(String segmentTemplate) {
        return RouteFormat.isParameter(segmentTemplate) && (segmentTemplate.endsWith("?") || segmentTemplate.contains("?("));
    }

    static boolean isVarargsParameter(String segmentTemplate) {
        return RouteFormat.isParameter(segmentTemplate) && (segmentTemplate.endsWith("*") || segmentTemplate.contains("*("));
    }

    static String getModifier(String segmentTemplate) {
        if (RouteFormat.isOptionalParameter(segmentTemplate)) {
            return "?";
        }
        if (RouteFormat.isVarargsParameter(segmentTemplate)) {
            return "*";
        }
        return "";
    }

    static String formatSegment(RouteSegment segment, Set<RouteParameterFormatOption> format) {
        Optional regex;
        if (!segment.isParameter()) {
            return segment.getName();
        }
        StringBuilder result = new StringBuilder();
        result.append(":");
        boolean formatRegex = format.contains((Object)RouteParameterFormatOption.REGEX) || format.contains((Object)RouteParameterFormatOption.REGEX_NAME);
        boolean wrapRegex = false;
        if (format.contains((Object)RouteParameterFormatOption.NAME)) {
            result.append(segment.getName());
            wrapRegex = true;
        }
        if (format.contains((Object)RouteParameterFormatOption.MODIFIER)) {
            result.append(RouteFormat.getModifier(segment.getTemplate()));
            wrapRegex = true;
        }
        Optional<Object> optional = regex = formatRegex ? RouteFormat.formatSegmentRegex(segment, format) : Optional.empty();
        if (regex.isPresent()) {
            if (wrapRegex) {
                result.append("(");
            }
            result.append((String)regex.get());
            if (wrapRegex) {
                result.append(")");
            }
        }
        return result.toString();
    }

    static Optional<String> formatSegmentRegex(RouteSegment segment, Set<RouteParameterFormatOption> format) {
        Optional<String> regex = segment.getRegex();
        if (format.contains((Object)RouteParameterFormatOption.REGEX_NAME)) {
            return Optional.of(RouteParameterRegex.getName(regex.orElse("")));
        }
        return regex;
    }

    static class ParameterInfo
    implements Serializable {
        private final String name;
        private final String template;
        private final boolean optional;
        private final boolean varargs;
        private final String regex;

        ParameterInfo(String template) {
            int regexStartIndex;
            this.template = template;
            if (!RouteFormat.isParameter(template)) {
                throw new IllegalArgumentException("The given string is not a parameter template.");
            }
            this.optional = RouteFormat.isOptionalParameter(template);
            if (this.optional) {
                template = template.replaceFirst("\\?", "");
            }
            this.varargs = RouteFormat.isVarargsParameter(template);
            if (this.varargs) {
                template = template.replaceFirst("\\*", "");
            }
            if ((regexStartIndex = (template = template.substring(1)).indexOf(40)) != -1) {
                this.name = template.substring(0, regexStartIndex);
                this.regex = template.substring(regexStartIndex + 1, template.length() - 1);
            } else {
                this.name = template;
                this.regex = null;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getTemplate() {
            return this.template;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean isVarargs() {
            return this.varargs;
        }

        public Optional<String> getRegex() {
            return Optional.ofNullable(this.regex);
        }
    }
}

