/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.Direction;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HeartbeatListener;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.PollNotifier;
import com.vaadin.flow.component.PushConfiguration;
import com.vaadin.flow.component.PushConfigurationImpl;
import com.vaadin.flow.component.ReconnectDialogConfiguration;
import com.vaadin.flow.component.ShortcutEventListener;
import com.vaadin.flow.component.ShortcutRegistration;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UIDetachedException;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.internal.AllowInert;
import com.vaadin.flow.component.internal.JavaScriptNavigationStateRenderer;
import com.vaadin.flow.component.internal.UIInternalUpdater;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.component.page.History;
import com.vaadin.flow.component.page.LoadingIndicatorConfiguration;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.ExecutionContext;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.internal.nodefeature.LoadingIndicatorConfigurationMap;
import com.vaadin.flow.internal.nodefeature.PollConfigurationMap;
import com.vaadin.flow.internal.nodefeature.ReconnectDialogConfigurationMap;
import com.vaadin.flow.router.AfterNavigationListener;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.router.BeforeLeaveListener;
import com.vaadin.flow.router.ErrorNavigationEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.EventUtil;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationStateBuilder;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouteNotFoundError;
import com.vaadin.flow.router.RouteParam;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.ErrorStateRenderer;
import com.vaadin.flow.router.internal.ErrorTargetEntry;
import com.vaadin.flow.router.internal.HasUrlParameterFormat;
import com.vaadin.flow.router.internal.PathUtil;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.ErrorHandlingCommand;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.auth.AnonymousAllowed;
import com.vaadin.flow.server.communication.PushConnection;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsModule(value="@vaadin/common-frontend/ConnectionIndicator.js")
public class UI
extends Component
implements PollNotifier,
HasComponents,
RouterLayout {
    private static final String NULL_LISTENER = "Listener can not be 'null'";
    private int uiId = -1;
    private boolean closing = false;
    private PushConfiguration pushConfiguration;
    private Locale locale = Locale.getDefault();
    private final UIInternals internals;
    private final Page page = new Page(this);
    private final String csrfToken = UUID.randomUUID().toString();
    static final String SERVER_CONNECTED = "this.serverConnected($0)";
    public static final String CLIENT_NAVIGATE_TO = "window.dispatchEvent(new CustomEvent('vaadin-router-go', {detail: new URL($0, document.baseURI)}))";
    public Element wrapperElement;
    private NavigationState clientViewNavigationState;
    private boolean navigationInProgress = false;
    private String forwardToClientUrl = null;
    private boolean firstNavigation = true;

    public UI() {
        this(new UIInternalUpdater(){});
    }

    protected UI(UIInternalUpdater internalsHandler) {
        super(null);
        this.internals = new UIInternals(this, internalsHandler);
        this.getNode().getFeature(ElementData.class).setTag("body");
        Component.setElement(this, Element.get(this.getNode()));
        this.pushConfiguration = new PushConfigurationImpl(this);
    }

    public VaadinSession getSession() {
        return this.internals.getSession();
    }

    public int getUIId() {
        return this.uiId;
    }

    @Deprecated
    public void doInit(VaadinRequest request, int uiId) {
        this.doInit(request, uiId, this.getSession().getService().getMainDivId(this.getSession(), request));
    }

    public void doInit(VaadinRequest request, int uiId, String appId) {
        if (this.uiId != -1) {
            String message = "This UI instance is already initialized (as UI id " + this.uiId + ") and can therefore not be initialized again (as UI id " + uiId + "). ";
            if (this.getSession() != null && !this.getSession().equals(VaadinSession.getCurrent())) {
                message = message + "Furthermore, it is already attached to another VaadinSession. ";
            }
            message = message + "Please make sure you are not accidentally reusing an old UI instance.";
            throw new IllegalStateException(message);
        }
        this.uiId = uiId;
        this.getInternals().setFullAppId(appId);
        this.wrapperElement = new Element(this.getInternals().getContainerTag());
        this.getElement().getStateProvider().appendVirtualChild(this.getElement().getNode(), this.wrapperElement, "@id", appId);
        this.getInternals().addComponentDependencies(this.getClass());
        this.init(request);
    }

    protected void init(VaadinRequest request) {
    }

    public static void setCurrent(UI ui) {
        CurrentInstance.set(UI.class, ui);
    }

    public static UI getCurrent() {
        return CurrentInstance.get(UI.class);
    }

    public void close() {
        this.closing = true;
        PushConnection pushConnection = this.getInternals().getPushConnection();
        if (pushConnection != null) {
            if (this.getSession() != null) {
                this.getSession().getService().runPendingAccessTasks(this.getSession());
            }
            pushConnection.push();
        }
    }

    public boolean isClosing() {
        return this.closing;
    }

    @Override
    protected void onAttach(AttachEvent attachEvent) {
    }

    @Override
    protected void onDetach(DetachEvent detachEvent) {
    }

    public void accessSynchronously(Command command) throws UIDetachedException {
        this.accessSynchronously(command, null);
    }

    private static void handleAccessDetach(SerializableRunnable detachHandler) {
        if (detachHandler == null) {
            throw new UIDetachedException();
        }
        detachHandler.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accessSynchronously(Command command, SerializableRunnable detachHandler) {
        Map<Class<?>, CurrentInstance> old = null;
        VaadinSession session = this.getSession();
        if (session == null) {
            UI.handleAccessDetach(detachHandler);
            return;
        }
        VaadinService.verifyNoOtherSessionLocked(session);
        session.lock();
        try {
            if (this.getSession() == null) {
                UI.handleAccessDetach(detachHandler);
                return;
            }
            old = CurrentInstance.setCurrent(this);
            command.execute();
        }
        finally {
            session.unlock();
            if (old != null) {
                CurrentInstance.restoreInstances(old);
            }
        }
    }

    public Future<Void> access(Command command) {
        return this.access(command, null);
    }

    private Future<Void> access(final Command command, final SerializableRunnable detachHandler) {
        VaadinSession session = this.getSession();
        if (session == null) {
            UI.handleAccessDetach(detachHandler);
            return null;
        }
        return session.access(new ErrorHandlingCommand(){

            @Override
            public void execute() {
                UI.this.accessSynchronously(command, detachHandler);
            }

            @Override
            public void handleError(Exception exception) {
                try {
                    if (command instanceof ErrorHandlingCommand) {
                        ErrorHandlingCommand errorHandlingCommand = (ErrorHandlingCommand)command;
                        errorHandlingCommand.handleError(exception);
                    } else if (UI.this.getSession() != null) {
                        UI.this.getSession().getErrorHandler().error(new ErrorEvent(exception));
                    } else if (exception instanceof ExecutionException && ((ExecutionException)exception).getCause() instanceof UIDetachedException) {
                        UI.this.getLogger().debug(exception.getMessage(), (Throwable)exception);
                    } else {
                        UI.this.getLogger().error(exception.getMessage(), (Throwable)exception);
                    }
                }
                catch (Exception e) {
                    UI.this.getLogger().error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    public SerializableRunnable accessLater(SerializableRunnable accessTask, SerializableRunnable detachHandler) {
        Objects.requireNonNull(accessTask, "Access task cannot be null");
        return () -> this.access(accessTask::run, detachHandler);
    }

    public <T> SerializableConsumer<T> accessLater(SerializableConsumer<T> accessTask, SerializableRunnable detachHandler) {
        Objects.requireNonNull(accessTask, "Access task cannot be null");
        return value -> this.access(() -> accessTask.accept(value), detachHandler);
    }

    public void setPollInterval(int intervalInMillis) {
        this.getNode().getFeature(PollConfigurationMap.class).setPollInterval(intervalInMillis);
    }

    public int getPollInterval() {
        return this.getNode().getFeature(PollConfigurationMap.class).getPollInterval();
    }

    public LoadingIndicatorConfiguration getLoadingIndicatorConfiguration() {
        return this.getNode().getFeature(LoadingIndicatorConfigurationMap.class);
    }

    public void push() {
        VaadinSession session = this.getSession();
        if (session == null) {
            throw new UIDetachedException("Cannot push a detached UI");
        }
        session.checkHasLock();
        if (!this.getPushConfiguration().getPushMode().isEnabled()) {
            throw new IllegalStateException("Push not enabled");
        }
        PushConnection pushConnection = this.getInternals().getPushConnection();
        assert (pushConnection != null);
        session.getService().runPendingAccessTasks(session);
        if (!this.getInternals().isDirty()) {
            return;
        }
        pushConnection.push();
    }

    public PushConfiguration getPushConfiguration() {
        return this.pushConfiguration;
    }

    public ReconnectDialogConfiguration getReconnectDialogConfiguration() {
        return this.getNode().getFeature(ReconnectDialogConfigurationMap.class);
    }

    Logger getLogger() {
        return LoggerFactory.getLogger((String)UI.class.getName());
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        assert (locale != null) : "Null locale is not supported!";
        if (!this.locale.equals(locale)) {
            this.locale = locale;
            EventUtil.informLocaleChangeObservers(this);
        }
    }

    public void setDirection(Direction direction) {
        Objects.requireNonNull(direction, "Direction cannot be null");
        this.getPage().executeJs("document.dir = $0", new Serializable[]{direction.getClientName()});
    }

    @Override
    public Element getElement() {
        return Element.get(this.getNode());
    }

    private StateNode getNode() {
        return this.getInternals().getStateTree().getRootNode();
    }

    public UIInternals getInternals() {
        return this.internals;
    }

    public Page getPage() {
        return this.page;
    }

    public <T extends Component> Optional<T> navigate(Class<T> navigationTarget) {
        return this.navigate(navigationTarget, RouteParameters.empty());
    }

    private <T extends Component> Optional<T> findCurrentNavigationTarget(Class<T> navigationTarget) {
        List<HasElement> activeRouterTargetsChain = this.getInternals().getActiveRouterTargetsChain();
        for (HasElement element : activeRouterTargetsChain) {
            if (!navigationTarget.isAssignableFrom(element.getClass())) continue;
            return Optional.of((Component)element);
        }
        return Optional.empty();
    }

    public <T, C extends Component> Optional<C> navigate(Class<? extends C> navigationTarget, T parameter) {
        this.navigate((Class<T>)navigationTarget, HasUrlParameterFormat.getParameters(parameter));
        return this.findCurrentNavigationTarget(navigationTarget);
    }

    public <T extends Component> Optional<T> navigate(Class<T> navigationTarget, RouteParameters parameters) {
        RouteConfiguration configuration = RouteConfiguration.forRegistry(this.getInternals().getRouter().getRegistry());
        this.navigate(configuration.getUrl(navigationTarget, parameters));
        return this.findCurrentNavigationTarget(navigationTarget);
    }

    public <T extends Component> Optional<T> navigate(Class<T> navigationTarget, RouteParam ... parameters) {
        return this.navigate(navigationTarget, new RouteParameters(parameters));
    }

    public <T, C extends Component> Optional<C> navigate(Class<? extends C> navigationTarget, T parameter, QueryParameters queryParameters) {
        RouteConfiguration configuration = RouteConfiguration.forRegistry(this.getInternals().getRouter().getRegistry());
        RouteParameters parameters = HasUrlParameterFormat.getParameters(parameter);
        String url = configuration.getUrl(navigationTarget, parameters);
        this.getInternals().getRouter().navigate(this, new Location(url, queryParameters), NavigationTrigger.UI_NAVIGATE);
        return this.findCurrentNavigationTarget(navigationTarget);
    }

    public <C extends Component> Optional<C> navigate(Class<? extends C> navigationTarget, RouteParameters routeParameter, QueryParameters queryParameters) {
        RouteConfiguration configuration = RouteConfiguration.forRegistry(this.getInternals().getRouter().getRegistry());
        String url = configuration.getUrl(navigationTarget, routeParameter);
        this.getInternals().getRouter().navigate(this, new Location(url, queryParameters), NavigationTrigger.UI_NAVIGATE);
        return this.findCurrentNavigationTarget(navigationTarget);
    }

    public <T extends Component> Optional<T> navigate(Class<? extends T> navigationTarget, QueryParameters queryParameters) {
        RouteConfiguration configuration = RouteConfiguration.forRegistry(this.getInternals().getRouter().getRegistry());
        String url = configuration.getUrl(navigationTarget, RouteParameters.empty());
        this.getInternals().getRouter().navigate(this, new Location(url, queryParameters), NavigationTrigger.UI_NAVIGATE);
        return this.findCurrentNavigationTarget(navigationTarget);
    }

    public void navigate(String location) {
        this.navigate(location, QueryParameters.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void navigate(String locationString, QueryParameters queryParameters) {
        Objects.requireNonNull(locationString, "Location must not be null");
        Objects.requireNonNull(queryParameters, "Query parameters must not be null");
        Location location = new Location(locationString, queryParameters);
        if (this.navigationInProgress || this.getInternals().hasLastHandledLocation() && this.sameLocation(this.getInternals().getLastHandledLocation(), location)) {
            return;
        }
        this.navigationInProgress = true;
        try {
            Optional<NavigationState> navigationState = this.getInternals().getRouter().resolveNavigationTarget(location);
            if (navigationState.isPresent()) {
                this.handleNavigation(location, navigationState.get(), NavigationTrigger.UI_NAVIGATE);
                if (this.getForwardToClientUrl() != null) {
                    this.navigateToClient(this.getForwardToClientUrl());
                }
            } else {
                this.navigateToClient(location.getPathWithQueryParameters());
            }
        }
        finally {
            this.navigationInProgress = false;
        }
    }

    public boolean isNavigationSupported() {
        return true;
    }

    public Component getCurrentView() {
        if (this.getInternals().getActiveRouterTargetsChain().isEmpty()) {
            throw new IllegalStateException("Routing is not in use or not yet initialized. If you are not using embedded UI, try postponing the call to an onAttach method or to an AfterNavigationEvent listener.");
        }
        return (Component)this.getInternals().getActiveRouterTargetsChain().get(0);
    }

    @Deprecated
    public Router getRouter() {
        return this.internals.getRouter();
    }

    public StateTree.ExecutionRegistration beforeClientResponse(Component component, SerializableConsumer<ExecutionContext> execution) throws IllegalArgumentException {
        if (component == null) {
            throw new IllegalArgumentException("The 'component' parameter may not be null");
        }
        if (execution == null) {
            throw new IllegalArgumentException("The 'execution' parameter may not be null");
        }
        if (component.getUI().isPresent() && component.getUI().get() != this) {
            throw new IllegalArgumentException("The given component doesn't belong to the UI the task to be executed on");
        }
        return this.internals.getStateTree().beforeClientResponse(component.getElement().getNode(), execution);
    }

    @Override
    public void add(Component ... components) {
        HasComponents.super.add(components);
    }

    @Override
    public Optional<UI> getUI() {
        return Optional.of(this);
    }

    public Registration addBeforeEnterListener(BeforeEnterListener listener) {
        Objects.requireNonNull(listener, NULL_LISTENER);
        return this.internals.addBeforeEnterListener(listener);
    }

    public Registration addBeforeLeaveListener(BeforeLeaveListener listener) {
        Objects.requireNonNull(listener, NULL_LISTENER);
        return this.internals.addBeforeLeaveListener(listener);
    }

    public Registration addAfterNavigationListener(AfterNavigationListener listener) {
        Objects.requireNonNull(listener, NULL_LISTENER);
        return this.internals.addAfterNavigationListener(listener);
    }

    public <E> List<E> getNavigationListeners(Class<E> navigationHandler) {
        return this.internals.getListeners(navigationHandler);
    }

    public ShortcutRegistration addShortcutListener(Command command, Key key, KeyModifier ... keyModifiers) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Parameter '%s' must not be null!", "command"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Parameter '%s' must not be null!", "key"));
        }
        return new ShortcutRegistration(this, () -> new Component[]{this}, event -> command.execute(), key).withModifiers(keyModifiers);
    }

    public ShortcutRegistration addShortcutListener(ShortcutEventListener listener, Key key, KeyModifier ... keyModifiers) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Parameter '%s' must not be null!", "listener"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Parameter '%s' must not be null!", "key"));
        }
        return new ShortcutRegistration(this, () -> new Component[]{this}, listener, key).withModifiers(keyModifiers);
    }

    public Registration addHeartbeatListener(HeartbeatListener listener) {
        Objects.requireNonNull(listener, NULL_LISTENER);
        return this.internals.addHeartbeatListener(listener);
    }

    public Component getActiveDragSourceComponent() {
        return this.getInternals().getActiveDragSourceComponent();
    }

    public String getCsrfToken() {
        return this.csrfToken;
    }

    public void addModal(Component component) {
        this.add(component);
        this.getInternals().setChildModal(component);
    }

    public void setChildComponentModal(Component childComponent, boolean modal) {
        Objects.requireNonNull(childComponent, "Given child component may not be null");
        Optional<UI> ui = childComponent.getUI();
        if (ui.isPresent() && !ui.get().equals(this)) {
            throw new IllegalStateException("Given component is not a child in this UI. Add it first as a child of the UI so it is attached or just use addModal(component).");
        }
        if (modal) {
            this.getInternals().setChildModal(childComponent);
        } else {
            this.getInternals().setChildModeless(childComponent);
        }
    }

    public boolean hasModalComponent() {
        return this.getInternals().hasModalComponent();
    }

    public void addToModalComponent(Component component) {
        if (this.hasModalComponent()) {
            Component activeModalComponent = this.getInternals().getActiveModalComponent();
            if (activeModalComponent instanceof HasComponents) {
                ((HasComponents)((Object)activeModalComponent)).add(component);
            } else {
                activeModalComponent.getElement().appendChild(component.getElement());
            }
        } else {
            this.add(component);
        }
    }

    @Override
    public Stream<Component> getChildren() {
        if (this.wrapperElement == null) {
            return super.getChildren();
        }
        Stream.Builder childComponents = Stream.builder();
        this.wrapperElement.getChildren().forEach(childElement -> ComponentUtil.findComponents(childElement, childComponents::add));
        super.getChildren().forEach(childComponents::add);
        return childComponents.build();
    }

    public String getForwardToClientUrl() {
        return this.forwardToClientUrl;
    }

    @ClientCallable
    @AllowInert
    public void connectClient(String flowRoutePath, String flowRouteQuery, String appShellTitle, JsonValue historyState, String trigger) {
        String trimmedRoute;
        if (appShellTitle != null && !appShellTitle.isEmpty()) {
            this.getInternals().setAppShellTitle(appShellTitle);
        }
        if (!(trimmedRoute = PathUtil.trimPath(flowRoutePath)).equals(flowRoutePath)) {
            this.getPage().getHistory().replaceState(null, trimmedRoute);
        }
        Location location = new Location(trimmedRoute, QueryParameters.fromString(flowRouteQuery));
        NavigationTrigger navigationTrigger = trigger.isEmpty() ? NavigationTrigger.PAGE_LOAD : (trigger.equalsIgnoreCase("link") ? NavigationTrigger.ROUTER_LINK : (trigger.equalsIgnoreCase("client") ? NavigationTrigger.CLIENT_SIDE : NavigationTrigger.HISTORY));
        if (this.firstNavigation) {
            this.firstNavigation = false;
            this.getPage().getHistory().setHistoryStateChangeHandler(event -> this.renderViewForRoute(event.getLocation(), event.getTrigger()));
            if (this.getInternals().getActiveRouterTargetsChain().isEmpty()) {
                this.renderViewForRoute(location, navigationTrigger);
            }
        } else {
            History.HistoryStateChangeHandler handler = this.getPage().getHistory().getHistoryStateChangeHandler();
            handler.onHistoryStateChange(new History.HistoryStateChangeEvent(this.getPage().getHistory(), historyState, location, navigationTrigger));
        }
        if (this.getForwardToClientUrl() != null) {
            this.navigateToClient(this.getForwardToClientUrl());
            this.acknowledgeClient();
        } else if (this.isPostponed()) {
            this.serverPaused();
        } else {
            this.acknowledgeClient();
        }
    }

    @ClientCallable
    public void leaveNavigation(String route, String query) {
        this.navigateToPlaceholder(new Location(PathUtil.trimPath(route), QueryParameters.fromString(query)));
        if (this.isPostponed()) {
            this.cancelClient();
        } else {
            this.acknowledgeClient();
        }
    }

    public void navigateToClient(String clientRoute) {
        this.getPage().executeJs(CLIENT_NAVIGATE_TO, new Serializable[]{clientRoute});
    }

    private void acknowledgeClient() {
        this.serverConnected(false);
    }

    private void cancelClient() {
        this.serverConnected(true);
    }

    private void serverPaused() {
        this.wrapperElement.executeJs("this.serverPaused()", new Serializable[0]);
    }

    private void serverConnected(boolean cancel) {
        this.wrapperElement.executeJs(SERVER_CONNECTED, Boolean.valueOf(cancel));
    }

    private void navigateToPlaceholder(Location location) {
        if (this.clientViewNavigationState == null) {
            this.clientViewNavigationState = new NavigationStateBuilder(this.getInternals().getRouter()).withTarget(ClientViewPlaceholder.class).build();
        }
        this.handleNavigation(location, this.clientViewNavigationState, NavigationTrigger.CLIENT_SIDE);
    }

    private void renderViewForRoute(Location location, NavigationTrigger trigger) {
        if (!this.shouldHandleNavigation(location)) {
            return;
        }
        this.getInternals().setLastHandledNavigation(location);
        Optional<NavigationState> navigationState = this.getInternals().getRouter().resolveNavigationTarget(location);
        if (navigationState.isPresent()) {
            this.handleNavigation(location, navigationState.get(), trigger);
        } else {
            this.navigateToPlaceholder(location);
            if (!this.isPostponed()) {
                this.handleErrorNavigation(location);
            }
        }
    }

    private boolean shouldHandleNavigation(Location location) {
        return !this.getInternals().hasLastHandledLocation() || !this.sameLocation(this.getInternals().getLastHandledLocation(), location);
    }

    private boolean sameLocation(Location oldLocation, Location newLocation) {
        return PathUtil.trimPath(newLocation.getPathWithQueryParameters()).equals(PathUtil.trimPath(oldLocation.getPathWithQueryParameters()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNavigation(Location location, NavigationState navigationState, NavigationTrigger trigger) {
        try {
            NavigationEvent navigationEvent = new NavigationEvent(this.getInternals().getRouter(), location, this, trigger);
            JavaScriptNavigationStateRenderer clientNavigationStateRenderer = new JavaScriptNavigationStateRenderer(navigationState);
            clientNavigationStateRenderer.handle(navigationEvent);
            this.forwardToClientUrl = clientNavigationStateRenderer.getClientForwardRoute();
            this.adjustPageTitle();
        }
        catch (Exception exception) {
            this.handleExceptionNavigation(location, exception);
        }
        finally {
            this.getInternals().clearLastHandledNavigation();
        }
    }

    private boolean handleExceptionNavigation(Location location, Exception exception) {
        Optional<ErrorTargetEntry> maybeLookupResult = this.getInternals().getRouter().getErrorNavigationTarget(exception);
        if (!maybeLookupResult.isPresent()) {
            throw new RuntimeException(exception);
        }
        ErrorTargetEntry lookupResult = maybeLookupResult.get();
        ErrorParameter<? extends Exception> errorParameter = new ErrorParameter<Exception>(lookupResult.getHandledExceptionType(), exception, exception.getMessage());
        ErrorStateRenderer errorStateRenderer = new ErrorStateRenderer(new NavigationStateBuilder(this.getInternals().getRouter()).withTarget(lookupResult.getNavigationTarget()).build());
        ErrorNavigationEvent errorNavigationEvent = new ErrorNavigationEvent(this.getInternals().getRouter(), location, this, NavigationTrigger.CLIENT_SIDE, errorParameter);
        errorStateRenderer.handle(errorNavigationEvent);
        return this.isPostponed();
    }

    private boolean isPostponed() {
        return this.getInternals().getContinueNavigationAction() != null;
    }

    private void adjustPageTitle() {
        String newTitle = this.getInternals().getTitle();
        String appShellTitle = this.getInternals().getAppShellTitle();
        if ((newTitle == null || newTitle.isEmpty()) && appShellTitle != null && !appShellTitle.isEmpty()) {
            this.getInternals().cancelPendingTitleUpdate();
            this.getInternals().setTitle(appShellTitle);
        }
    }

    private void handleErrorNavigation(Location location) {
        NavigationState errorNavigationState = this.getInternals().getRouter().resolveRouteNotFoundNavigationTarget().orElse(this.getDefaultNavigationError());
        ErrorStateRenderer errorStateRenderer = new ErrorStateRenderer(errorNavigationState);
        NotFoundException notFoundException = new NotFoundException("Couldn't find route for '" + location.getPath() + "'");
        ErrorParameter<NotFoundException> errorParameter = new ErrorParameter<NotFoundException>(NotFoundException.class, notFoundException);
        ErrorNavigationEvent errorNavigationEvent = new ErrorNavigationEvent(this.getInternals().getRouter(), location, this, NavigationTrigger.CLIENT_SIDE, errorParameter);
        errorStateRenderer.handle(errorNavigationEvent);
    }

    private NavigationState getDefaultNavigationError() {
        return new NavigationStateBuilder(this.getInternals().getRouter()).withTarget(RouteNotFoundError.class).build();
    }

    @Tag(value="div")
    @AnonymousAllowed
    public static class ClientViewPlaceholder
    extends Component {
    }
}

