/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

public interface UIInternalUpdater
extends Serializable {
    default public void updateRoot(UI ui, HasElement oldRoot, HasElement newRoot) {
        Element wrapperElement = ui.wrapperElement;
        if (wrapperElement == null) {
            Element rootElement;
            Element uiElement = ui.getElement();
            if (!uiElement.equals((rootElement = newRoot.getElement()).getParent())) {
                if (oldRoot != null) {
                    oldRoot.getElement().removeFromParent();
                }
                rootElement.removeFromParent();
                uiElement.appendChild(rootElement);
            }
        } else {
            Element rootElement = newRoot.getElement();
            if (newRoot instanceof UI.ClientViewPlaceholder) {
                wrapperElement.removeAllChildren();
            } else if (!wrapperElement.equals(rootElement.getParent())) {
                if (oldRoot != null) {
                    oldRoot.getElement().removeFromParent();
                }
                rootElement.removeFromParent();
                wrapperElement.appendChild(rootElement);
            }
        }
    }

    default public void moveToNewUI(UI oldUI, UI newUI) {
        List<Element> uiChildren = oldUI.getElement().getChildren().collect(Collectors.toList());
        uiChildren.forEach(element -> {
            element.removeFromTree();
            newUI.getElement().appendChild((Element)element);
        });
    }
}

