/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.function;

import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.shared.communication.PushMode;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface DeploymentConfiguration
extends AbstractConfiguration,
Serializable {
    public boolean isRequestTiming();

    public boolean isSyncIdCheckEnabled();

    public int getHeartbeatInterval();

    public int getMaxMessageSuspendTimeout();

    public int getWebComponentDisconnect();

    public boolean isSendUrlsAsParameters();

    public boolean isCloseIdleSessions();

    public PushMode getPushMode();

    default public String getPushServletMapping() {
        return "";
    }

    public Properties getInitParameters();

    public <T> T getApplicationOrSystemProperty(String var1, T var2, Function<String, T> var3);

    @Override
    default public boolean getBooleanProperty(String propertyName, boolean defaultValue) throws IllegalArgumentException {
        String booleanString = this.getStringProperty(propertyName, null);
        if (booleanString == null) {
            return defaultValue;
        }
        if (booleanString.isEmpty()) {
            return true;
        }
        boolean parsedBoolean = Boolean.parseBoolean(booleanString);
        if (Boolean.toString(parsedBoolean).equalsIgnoreCase(booleanString)) {
            return parsedBoolean;
        }
        throw new IllegalArgumentException(String.format("Property named '%s' is boolean, but contains incorrect value '%s' that is not boolean '%s'", propertyName, booleanString, parsedBoolean));
    }

    public String getUIClassName();

    public String getClassLoaderName();

    default public boolean isBrotli() {
        return this.getBooleanProperty("brotli", true);
    }

    default public String getCompiledWebComponentsPath() {
        return this.getStringProperty("compiled.web.components.path", "vaadin-web-components");
    }

    default public List<String> getPolyfills() {
        return Arrays.asList(this.getStringProperty("module.polyfills", "").split("[, ]+")).stream().filter(polyfill -> !polyfill.isEmpty()).collect(Collectors.toList());
    }

    default public boolean isStatsExternal() {
        return this.getBooleanProperty("external.stats.file", false);
    }

    default public String getExternalStatsUrl() {
        return this.getStringProperty("external.stats.url", "/vaadin-static/VAADIN/config/stats.json");
    }

    default public boolean isEagerServerLoad() {
        return this.getBooleanProperty("eagerServerLoad", false);
    }

    public boolean isDevModeLiveReloadEnabled();

    public boolean isDevToolsEnabled();
}

