/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.AbstractUpdateImports;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.CssData;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class GenerateMainImports
extends AbstractUpdateImports {
    private JsonObject statsJson;
    private Map<File, List<String>> output;

    public GenerateMainImports(ClassFinder classFinder, FrontendDependenciesScanner frontendDepScanner, Options options, JsonObject statsJson) {
        super(options, frontendDepScanner, classFinder);
        this.statsJson = statsJson;
    }

    public List<String> getLines() {
        if (this.output == null) {
            return Collections.emptyList();
        }
        return this.merge(this.output);
    }

    @Override
    protected void writeOutput(Map<File, List<String>> outputFiles) {
        this.output = outputFiles;
    }

    @Override
    protected boolean addCssLines(Collection<String> lines, CssData cssData, int i) {
        super.addCssLines(lines, cssData, i);
        return true;
    }

    @Override
    protected Logger getLogger() {
        return NOPLogger.NOP_LOGGER;
    }

    @Override
    protected boolean inMemoryCollection() {
        return true;
    }

    @Override
    protected String getImportsNotFoundMessage() {
        return "";
    }

    @Override
    protected boolean importedFileExists(String importName) {
        if (super.importedFileExists(importName)) {
            return true;
        }
        JsonArray statsBundle = this.statsJson.hasKey("bundleImports") ? this.statsJson.getArray("bundleImports") : Json.createArray();
        importName = importName.replace("Frontend/", "./");
        for (int i = 0; i < statsBundle.length(); ++i) {
            if (!importName.equals(statsBundle.getString(i).replace("Frontend/", "./"))) continue;
            return true;
        }
        return false;
    }
}

