/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.internal.hilla.EndpointRequestUtil;
import com.vaadin.flow.server.AbstractDeploymentConfiguration;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.shared.communication.PushMode;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class PropertyDeploymentConfiguration
extends AbstractDeploymentConfiguration {
    private final Class<?> systemPropertyBaseClass;
    private final Properties allProperties;
    private final ApplicationConfiguration parentConfig;

    public PropertyDeploymentConfiguration(ApplicationConfiguration parentConfig, Class<?> systemPropertyBaseClass, Properties initParameters) {
        super(PropertyDeploymentConfiguration.filterStringProperties(initParameters));
        this.parentConfig = parentConfig;
        this.allProperties = this.mergeProperties(parentConfig, initParameters);
        this.systemPropertyBaseClass = systemPropertyBaseClass;
    }

    @Override
    protected String getSystemProperty(String parameterName) {
        String className;
        int index;
        Package pkg = this.systemPropertyBaseClass.getPackage();
        Object pkgName = pkg != null ? pkg.getName() : ((index = (className = this.systemPropertyBaseClass.getName()).lastIndexOf(46)) >= 0 ? className.substring(0, index) : null);
        if (pkgName == null) {
            pkgName = "";
        } else if (!((String)pkgName).isEmpty()) {
            pkgName = (String)pkgName + ".";
        }
        String val = System.getProperty((String)pkgName + parameterName);
        if (val != null) {
            return val;
        }
        val = System.getProperty((String)pkgName + parameterName.toLowerCase(Locale.ENGLISH));
        if (val != null) {
            return val;
        }
        return super.getSystemProperty(parameterName);
    }

    @Override
    public String getApplicationProperty(String parameterName) {
        String val = this.getApplicationProperty(this.getProperties()::get, parameterName);
        if (val == null) {
            val = this.getApplicationProperty(prop -> this.parentConfig.getStringProperty((String)prop, null), parameterName);
        }
        return val;
    }

    @Override
    public boolean isProductionMode() {
        if (this.isOwnProperty("productionMode")) {
            return this.getBooleanProperty("productionMode", false);
        }
        return this.parentConfig.isProductionMode();
    }

    @Override
    public boolean frontendHotdeploy() {
        if (this.isOwnProperty("frontend.hotdeploy")) {
            return this.getBooleanProperty("frontend.hotdeploy", EndpointRequestUtil.isHillaAvailable());
        }
        return this.parentConfig.frontendHotdeploy();
    }

    @Override
    public boolean isPnpmEnabled() {
        if (this.isOwnProperty("pnpm.enable")) {
            return super.isPnpmEnabled();
        }
        return this.parentConfig.isPnpmEnabled();
    }

    @Override
    public boolean isUsageStatisticsEnabled() {
        return !this.isProductionMode() && this.getBooleanProperty("devmode.usageStatistics.enabled", true);
    }

    @Override
    public boolean isGlobalPnpm() {
        if (this.isOwnProperty("pnpm.global")) {
            return super.isGlobalPnpm();
        }
        return this.parentConfig.isGlobalPnpm();
    }

    @Override
    public boolean reuseDevServer() {
        if (this.isOwnProperty("reuseDevServer")) {
            return super.reuseDevServer();
        }
        return this.parentConfig.reuseDevServer();
    }

    @Override
    public boolean isRequestTiming() {
        return this.getBooleanProperty("requestTiming", !this.isProductionMode());
    }

    @Override
    public boolean isXsrfProtectionEnabled() {
        if (this.isOwnProperty("disable-xsrf-protection")) {
            return super.isXsrfProtectionEnabled();
        }
        return this.parentConfig.isXsrfProtectionEnabled();
    }

    @Override
    public String getBuildFolder() {
        if (this.isOwnProperty("build.folder")) {
            return super.getBuildFolder();
        }
        return this.parentConfig.getBuildFolder();
    }

    @Override
    public File getJavaResourceFolder() {
        return super.getJavaResourceFolder();
    }

    @Override
    public File getJavaSourceFolder() {
        return super.getJavaSourceFolder();
    }

    @Override
    public boolean isSyncIdCheckEnabled() {
        return this.getBooleanProperty("syncIdCheck", true);
    }

    @Override
    public int getHeartbeatInterval() {
        return 300;
    }

    @Override
    public int getMaxMessageSuspendTimeout() {
        return 5000;
    }

    @Override
    public int getWebComponentDisconnect() {
        return 300;
    }

    @Override
    public boolean isSendUrlsAsParameters() {
        return this.getBooleanProperty("sendUrlsAsParameters", true);
    }

    @Override
    public boolean isCloseIdleSessions() {
        return this.getBooleanProperty("closeIdleSessions", false);
    }

    @Override
    public PushMode getPushMode() {
        return PushMode.DISABLED;
    }

    @Override
    public Properties getInitParameters() {
        return this.allProperties;
    }

    @Override
    public boolean isDevModeLiveReloadEnabled() {
        return this.isDevToolsEnabled() && this.getBooleanProperty("devmode.liveReload.enabled", true);
    }

    @Override
    public boolean isDevToolsEnabled() {
        return !this.isProductionMode() && this.getBooleanProperty("devmode.devTools.enabled", true);
    }

    protected boolean isOwnProperty(String property) {
        return this.getApplicationProperty(this.getProperties()::get, property) != null;
    }

    protected ApplicationConfiguration getParentConfiguration() {
        return this.parentConfig;
    }

    private Properties mergeProperties(ApplicationConfiguration config, Properties properties) {
        Properties result = new Properties();
        Enumeration<String> propertyNames = config.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String property = propertyNames.nextElement();
            result.put(property, config.getStringProperty(property, null));
        }
        result.putAll((Map<?, ?>)properties);
        return result;
    }

    private static Map<String, String> filterStringProperties(Properties properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof String) || !(value instanceof String)) continue;
            result.put(key.toString(), value.toString());
        }
        return result;
    }
}

