/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.LoggerFactory;

public class Platform
implements Serializable {
    private static boolean versionErrorLogged = false;
    static String hillaVersion = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<String> getVaadinVersion() {
        try (InputStream vaadinVersionsStream = Platform.class.getClassLoader().getResourceAsStream("vaadin-core-versions.json");){
            if (vaadinVersionsStream != null) {
                ObjectMapper m = new ObjectMapper();
                JsonNode vaadinVersions = m.readTree(vaadinVersionsStream);
                Optional<String> optional = Optional.of(vaadinVersions.get("platform").asText());
                return optional;
            }
            if (versionErrorLogged) return Optional.empty();
            versionErrorLogged = true;
            LoggerFactory.getLogger(Platform.class).info("Unable to determine version information. No vaadin-core-versions.json found");
            return Optional.empty();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(Platform.class).error("Unable to determine version information", (Throwable)e);
        }
        return Optional.empty();
    }

    public static Optional<String> getHillaVersion() {
        if (hillaVersion == null) {
            try (InputStream hillaPomProperties = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/maven/dev.hilla/hilla/pom.properties");){
                if (hillaPomProperties != null) {
                    Properties properties = new Properties();
                    properties.load(hillaPomProperties);
                    hillaVersion = properties.getProperty("version", "");
                } else {
                    hillaVersion = "";
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(Platform.class).error("Unable to determine Hilla version", (Throwable)e);
                hillaVersion = "";
            }
        }
        return hillaVersion.isEmpty() ? Optional.empty() : Optional.of(hillaVersion);
    }
}

