/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class JarContentsManager {
    private static final String JAR_PATH_SEPARATOR = "/";

    public boolean containsPath(File jar, String filePath) {
        boolean bl;
        this.requireFileExistence(jar);
        Objects.requireNonNull(filePath);
        JarFile jarFile = new JarFile(jar, false);
        try {
            boolean containsEntry;
            boolean bl2 = containsEntry = jarFile.getJarEntry(filePath) != null;
            if (!containsEntry) {
                containsEntry = jarFile.stream().anyMatch(entry -> entry.getName().startsWith(filePath));
            }
            bl = containsEntry;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Failed to retrieve file '%s' from jar '%s'", filePath, jar), e);
            }
        }
        jarFile.close();
        return bl;
    }

    public byte[] getFileContents(File jar, String filePath) {
        byte[] byArray;
        this.requireFileExistence(jar);
        Objects.requireNonNull(filePath);
        JarFile jarFile = new JarFile(jar, false);
        try {
            byArray = this.getJarEntryContents(jarFile, jarFile.getJarEntry(filePath));
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Failed to retrieve file '%s' from jar '%s'", filePath, jar), e);
            }
        }
        jarFile.close();
        return byArray;
    }

    public List<String> findFiles(File jar, String baseDirectoryName, String fileName) {
        List<String> list;
        this.requireFileExistence(jar);
        Objects.requireNonNull(baseDirectoryName);
        Objects.requireNonNull(fileName);
        JarFile jarFile = new JarFile(jar, false);
        try {
            list = jarFile.stream().filter(entry -> !entry.isDirectory()).map(ZipEntry::getName).filter(path -> path.startsWith(baseDirectoryName)).filter(path -> path.endsWith(JAR_PATH_SEPARATOR + fileName)).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        jarFile.close();
        return list;
    }

    private void requireFileExistence(File jar) {
        if (!Objects.requireNonNull(jar).isFile()) {
            throw new IllegalArgumentException(String.format("Expect '%s' to be an existing file", jar));
        }
    }

    private byte[] getJarEntryContents(JarFile jarFile, JarEntry entry) {
        byte[] byArray;
        block9: {
            if (entry == null) {
                return null;
            }
            InputStream entryStream = jarFile.getInputStream(entry);
            try {
                byArray = IOUtils.toByteArray((InputStream)entryStream);
                if (entryStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (entryStream != null) {
                        try {
                            entryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(String.format("Failed to get entry '%s' contents from jar file '%s'", entry, jarFile), e);
                }
            }
            entryStream.close();
        }
        return byArray;
    }

    public void copyFilesFromJarTrimmingBasePath(File jar, String jarDirectoryToCopyFrom, File outputDirectory, String ... wildcardPathExclusions) {
        this.requireFileExistence(jar);
        if (!Objects.requireNonNull(outputDirectory).isDirectory()) {
            throw new IllegalArgumentException(String.format("Expect '%s' to be an existing directory", outputDirectory));
        }
        String basePath = this.normalizeJarBasePath(jarDirectoryToCopyFrom);
        try (JarFile jarFile = new JarFile(jar, false);){
            jarFile.stream().filter(file -> !file.isDirectory()).filter(file -> file.getName().toLowerCase(Locale.ENGLISH).startsWith(basePath.toLowerCase(Locale.ENGLISH))).filter(file -> this.isFileIncluded((ZipEntry)file, wildcardPathExclusions)).forEach(jarEntry -> this.copyJarEntryTrimmingBasePath(jarFile, (ZipEntry)jarEntry, basePath, outputDirectory));
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to extract files from jarFile '%s' to directory '%s'", jar, outputDirectory), e);
        }
    }

    public void copyIncludedFilesFromJarTrimmingBasePath(File jar, String jarDirectoryToCopyFrom, File outputDirectory, String ... wildcardPathInclusions) {
        this.requireFileExistence(jar);
        if (!Objects.requireNonNull(outputDirectory).isDirectory()) {
            throw new IllegalArgumentException(String.format("Expect '%s' to be an existing directory", outputDirectory));
        }
        String basePath = this.normalizeJarBasePath(jarDirectoryToCopyFrom);
        try (JarFile jarFile = new JarFile(jar, false);){
            jarFile.stream().filter(file -> !file.isDirectory()).filter(file -> file.getName().toLowerCase(Locale.ENGLISH).startsWith(basePath.toLowerCase(Locale.ENGLISH))).filter(file -> this.includeFile((ZipEntry)file, wildcardPathInclusions)).forEach(jarEntry -> this.copyJarEntryTrimmingBasePath(jarFile, (ZipEntry)jarEntry, basePath, outputDirectory));
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to extract files from jarFile '%s' to directory '%s'", jar, outputDirectory), e);
        }
    }

    private String normalizeJarBasePath(String rawPath) {
        if (rawPath == null || rawPath.isEmpty()) {
            return "";
        }
        return rawPath.endsWith(JAR_PATH_SEPARATOR) ? rawPath : rawPath + JAR_PATH_SEPARATOR;
    }

    private boolean isFileIncluded(ZipEntry file, String ... pathExclusions) {
        String filePath = file.getName();
        return Stream.of(pathExclusions).noneMatch(exclusionRule -> FilenameUtils.wildcardMatch((String)filePath, (String)exclusionRule));
    }

    private boolean includeFile(ZipEntry file, String ... pathInclusions) {
        String filePath = file.getName();
        return Stream.of(pathInclusions).anyMatch(inclusionRule -> FilenameUtils.wildcardMatch((String)filePath, (String)inclusionRule));
    }

    private void copyJarEntryTrimmingBasePath(JarFile jarFile, ZipEntry jarEntry, String basePath, File outputDirectory) {
        String fullPath = jarEntry.getName();
        String relativePath = fullPath.substring(fullPath.toLowerCase(Locale.ENGLISH).indexOf(basePath.toLowerCase(Locale.ENGLISH)) + basePath.length());
        File target = new File(outputDirectory, relativePath);
        try {
            if (!target.exists() || !this.hasSameContent(jarFile.getInputStream(jarEntry), target)) {
                FileUtils.copyInputStreamToFile((InputStream)jarFile.getInputStream(jarEntry), (File)target);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to extract jar entry '%s' from jarFile", jarEntry), e);
        }
    }

    private boolean hasSameContent(InputStream jarContent, File existingContent) throws IOException {
        try {
            boolean bl;
            try (FileInputStream existingContentStream = new FileInputStream(existingContent);){
                bl = IOUtils.contentEquals((InputStream)jarContent, (InputStream)existingContentStream);
            }
            return bl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)jarContent);
        }
    }
}

