/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.dom.DebouncePhase;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.shared.Registration;
import java.util.Objects;
import java.util.Set;

public interface DomListenerRegistration
extends Registration {
    public DomListenerRegistration addEventData(String var1);

    public DomListenerRegistration setFilter(String var1);

    public String getFilter();

    public DomListenerRegistration setDisabledUpdateMode(DisabledUpdateMode var1);

    public DomListenerRegistration debounce(int var1, DebouncePhase var2, DebouncePhase ... var3);

    default public DomListenerRegistration debounce(int timeout) {
        return this.debounce(timeout, DebouncePhase.TRAILING, new DebouncePhase[0]);
    }

    default public DomListenerRegistration throttle(int period) {
        return this.debounce(period, DebouncePhase.LEADING, DebouncePhase.INTERMEDIATE);
    }

    default public int getDebounceTimeout() {
        throw new UnsupportedOperationException();
    }

    default public Set<DebouncePhase> getDebouncePhases() {
        throw new UnsupportedOperationException();
    }

    default public String getEventType() {
        throw new UnsupportedOperationException();
    }

    default public DomListenerRegistration onUnregister(SerializableRunnable unregisterHandler) {
        throw new UnsupportedOperationException();
    }

    default public DomListenerRegistration synchronizeProperty(String propertyName) {
        if (propertyName == null || propertyName.isEmpty()) {
            throw new IllegalArgumentException("Property name must be given");
        }
        return this.addEventData("}" + propertyName);
    }

    default public DomListenerRegistration mapEventTargetElement() {
        return this.addEventData("]");
    }

    default public DomListenerRegistration addEventDataElement(String eventData) {
        Objects.requireNonNull(eventData);
        if (Objects.equals(eventData, "event.target")) {
            return this.mapEventTargetElement();
        }
        return this.addEventData("]" + eventData);
    }
}

