/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import com.vaadin.flow.server.frontend.FrontendUtils;
import java.io.File;
import java.util.ArrayList;

public class TaskGenerateWebComponentBootstrap
extends AbstractTaskClientGenerator {
    private final File frontendGeneratedDirectory;
    private final File generatedImports;

    TaskGenerateWebComponentBootstrap(File frontendDirectory, File generatedImports) {
        this.frontendGeneratedDirectory = new File(frontendDirectory, "generated/");
        this.generatedImports = generatedImports;
    }

    @Override
    protected String getFileContent() {
        ArrayList<String> lines = new ArrayList<String>();
        String generatedImportsRelativePath = FrontendUtils.getUnixRelativePath(this.frontendGeneratedDirectory.toPath(), this.generatedImports.toPath());
        lines.add(String.format("import '%s';", generatedImportsRelativePath));
        lines.add("import { init } from 'Frontend/generated/jar-resources/FlowClient.js';");
        lines.add("init();");
        return String.join((CharSequence)"\n", lines);
    }

    @Override
    protected File getGeneratedFile() {
        return new File(this.frontendGeneratedDirectory, "vaadin-web-component.ts");
    }

    @Override
    protected boolean shouldGenerate() {
        return true;
    }
}

