/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.di;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Lookup {
    public <T> T lookup(Class<T> var1);

    public <T> Collection<T> lookupAll(Class<T> var1);

    @SafeVarargs
    public static <T> Lookup of(final T service, Class<? super T> ... serviceTypes) {
        Objects.requireNonNull(service);
        final Set services = Stream.of(serviceTypes).peek(type -> {
            if (!type.isInstance(service)) {
                throw new IllegalArgumentException("Service type" + service.getClass().getName() + " is not a subtype of " + type.getName());
            }
        }).collect(Collectors.toSet());
        return new Lookup(){

            public <U> Collection<U> lookupAll(Class<U> serviceClass) {
                U service2 = this.lookup(serviceClass);
                return service2 == null ? Collections.emptyList() : Collections.singleton(service2);
            }

            public <U> U lookup(Class<U> serviceClass) {
                if (services.contains(serviceClass)) {
                    return serviceClass.cast(service);
                }
                return null;
            }
        };
    }

    public static Lookup compose(final Lookup lookup1, final Lookup lookup2) {
        return new Lookup(){

            @Override
            public <T> Collection<T> lookupAll(Class<T> serviceClass) {
                return Stream.concat(lookup1.lookupAll(serviceClass).stream(), lookup2.lookupAll(serviceClass).stream()).collect(Collectors.toList());
            }

            @Override
            public <T> T lookup(Class<T> serviceClass) {
                T service = lookup1.lookup(serviceClass);
                if (service == null) {
                    return lookup2.lookup(serviceClass);
                }
                return service;
            }
        };
    }
}

