/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.internal.Template;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCopyTemplateFiles
implements FallibleCommand {
    private final ClassFinder classFinder;
    private final File projectDirectory;
    private final File resourceOutputDirectory;
    private final File frontendDirectory;

    TaskCopyTemplateFiles(ClassFinder classFinder, File projectDirectory, File resourceOutputDirectory, File frontendDirectory) {
        this.classFinder = classFinder;
        this.projectDirectory = projectDirectory;
        this.resourceOutputDirectory = resourceOutputDirectory;
        this.frontendDirectory = frontendDirectory;
    }

    @Override
    public void execute() throws ExecutionFailedException {
        Class jsModuleAnnotationClass;
        HashSet<Class<Template>> classes = new HashSet<Class<Template>>(this.classFinder.getSubTypesOf(Template.class));
        try {
            jsModuleAnnotationClass = this.classFinder.loadClass(JsModule.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new ExecutionFailedException(e);
        }
        for (Class clazz : classes) {
            for (Annotation jsmAnnotation : clazz.getAnnotationsByType(jsModuleAnnotationClass)) {
                String path = this.getJsModuleAnnotationValue(jsmAnnotation);
                File source = FrontendUtils.resolveFrontendPath(this.projectDirectory, path, this.frontendDirectory);
                if (source == null) {
                    throw new ExecutionFailedException("Unable to locate file " + path);
                }
                File templateDirectory = new File(this.resourceOutputDirectory, "config/templates/");
                File target = new File(templateDirectory, path).getParentFile();
                target.mkdirs();
                try {
                    FileUtils.copyFileToDirectory((File)source, (File)target);
                }
                catch (IOException e) {
                    throw new ExecutionFailedException(e);
                }
            }
        }
    }

    private String getJsModuleAnnotationValue(Annotation jsmAnnotation) throws ExecutionFailedException {
        try {
            Object value = jsmAnnotation.getClass().getDeclaredMethod("value", new Class[0]).invoke((Object)jsmAnnotation, new Object[0]);
            return (String)value;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ExecutionFailedException(e);
        }
    }

    Logger log() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

