/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.RouteAliasData;
import com.vaadin.flow.router.RouteBaseData;
import com.vaadin.flow.router.RouteParameterData;
import com.vaadin.flow.router.RouterLayout;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RouteData
extends RouteBaseData<RouteData> {
    private final List<RouteAliasData> routeAliases;

    public RouteData(List<Class<? extends RouterLayout>> parentLayouts, String template, List<Class<?>> parameters, Class<? extends Component> navigationTarget, List<RouteAliasData> routeAliases) {
        super(parentLayouts, template, parameters, navigationTarget);
        Collections.sort(routeAliases);
        this.routeAliases = Collections.unmodifiableList(routeAliases);
    }

    public RouteData(List<Class<? extends RouterLayout>> parentLayouts, String template, Map<String, RouteParameterData> parameters, Class<? extends Component> navigationTarget, List<RouteAliasData> routeAliases) {
        super(parentLayouts, template, parameters, navigationTarget);
        Collections.sort(routeAliases);
        this.routeAliases = Collections.unmodifiableList(routeAliases);
    }

    public List<RouteAliasData> getRouteAliases() {
        return this.routeAliases;
    }

    public String toString() {
        return "RouteData{parentLayout=" + this.getParentLayout() + ", url='" + this.getTemplate() + "', parameters=" + this.getRouteParameters() + ", navigationTarget=" + this.getNavigationTarget() + ", routeAliases=" + this.routeAliases + "}";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RouteData) {
            RouteData other = (RouteData)obj;
            return other.getParentLayouts().equals(this.getParentLayouts()) && other.getTemplate().equals(this.getTemplate()) && other.getNavigationTarget().equals(this.getNavigationTarget()) && this.routeAliases.containsAll(other.routeAliases);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getParentLayouts(), this.getTemplate(), this.getNavigationTarget(), this.routeAliases);
    }
}

