/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.frontend.installer.Platform;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import elemental.json.JsonObject;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class Options
implements Serializable {
    final String buildDirectory;
    final ClassFinder classFinder;
    final File frontendDirectory;
    File webappResourcesDirectory = null;
    File resourceOutputDirectory = null;
    boolean enablePackagesUpdate = false;
    boolean createMissingPackageJson = false;
    boolean enableImportsUpdate = false;
    boolean enableWebpackConfigUpdate = false;
    boolean runNpmInstall = false;
    Set<File> jarFiles = null;
    boolean generateEmbeddableWebComponents = true;
    boolean cleanNpmFiles = false;
    File jarFrontendResourcesFolder = null;
    File localResourcesFolder = null;
    boolean useByteCodeScanner = false;
    JsonObject tokenFileData;
    File tokenFile;
    boolean enablePnpm = false;
    boolean useGlobalPnpm = false;
    File endpointSourceFolder;
    File endpointGeneratedOpenAPIFile;
    File applicationProperties;
    File frontendGeneratedFolder;
    boolean requireHomeNodeExec;
    boolean copyTemplates = false;
    final File npmFolder;
    final File generatedFolder;
    boolean useLegacyV14Bootstrap;
    String nodeVersion = "v18.19.1";
    URI nodeDownloadRoot = URI.create(Platform.guess().getNodeDownloadRoot());
    boolean nodeAutoUpdate = false;
    Lookup lookup;
    boolean productionMode = true;
    File javaResourceFolder;
    List<String> postinstallPackages;

    public Options(Lookup lookup, File npmFolder, String buildDirectory) {
        this(lookup, npmFolder, new File(npmFolder, System.getProperty("vaadin.frontend.generated.folder", Paths.get(buildDirectory, "frontend/").toString())), buildDirectory);
    }

    public Options(Lookup lookup, File npmFolder, File generatedPath, String buildDirectory) {
        this(lookup, npmFolder, generatedPath, new File(npmFolder, System.getProperty("vaadin.frontend.frontend.folder", "./frontend/")), buildDirectory);
    }

    public Options(Lookup lookup, File npmFolder, File generatedPath, File frontendDirectory, String buildDirectory) {
        this.lookup = lookup;
        this.classFinder = lookup.lookup(ClassFinder.class);
        this.npmFolder = npmFolder;
        this.generatedFolder = generatedPath.isAbsolute() ? generatedPath : new File(npmFolder, generatedPath.getPath());
        this.frontendDirectory = frontendDirectory.isAbsolute() ? frontendDirectory : new File(npmFolder, frontendDirectory.getPath());
        this.buildDirectory = buildDirectory;
    }

    public Options withWebpack(File webappResourcesDirectory, File resourceOutputDirectory) {
        this.enableWebpackConfigUpdate = true;
        this.webappResourcesDirectory = webappResourcesDirectory;
        this.resourceOutputDirectory = resourceOutputDirectory;
        return this;
    }

    public Options enablePackagesUpdate(boolean enablePackagesUpdate) {
        this.enablePackagesUpdate = enablePackagesUpdate;
        return this;
    }

    Options enableNpmFileCleaning(boolean forceClean) {
        this.cleanNpmFiles = forceClean;
        return this;
    }

    public Options enableImportsUpdate(boolean enableImportsUpdate) {
        this.enableImportsUpdate = enableImportsUpdate;
        this.createMissingPackageJson = enableImportsUpdate || this.createMissingPackageJson;
        return this;
    }

    public Options runNpmInstall(boolean runNpmInstall) {
        this.runNpmInstall = runNpmInstall;
        return this;
    }

    public Options withJarFrontendResourcesFolder(File jarFrontendResourcesFolder) {
        this.jarFrontendResourcesFolder = jarFrontendResourcesFolder.isAbsolute() ? jarFrontendResourcesFolder : new File(this.npmFolder, jarFrontendResourcesFolder.getPath());
        return this;
    }

    public Options copyResources(Set<File> jars) {
        Objects.requireNonNull(jars, "Parameter 'jars' must not be null!");
        this.jarFiles = jars;
        return this;
    }

    public Options copyTemplates(boolean copyTemplates) {
        this.copyTemplates = copyTemplates;
        return this;
    }

    public Options withEmbeddableWebComponents(boolean generateEmbeddableWebComponents) {
        this.generateEmbeddableWebComponents = generateEmbeddableWebComponents;
        return this;
    }

    public Options createMissingPackageJson(boolean create) {
        this.createMissingPackageJson = create;
        return this;
    }

    public Options copyLocalResources(File localResourcesFolder) {
        this.localResourcesFolder = localResourcesFolder;
        return this;
    }

    public Options useV14Bootstrap(boolean useDeprecatedV14Bootstrapping) {
        this.useLegacyV14Bootstrap = useDeprecatedV14Bootstrapping;
        return this;
    }

    public Options withFrontendGeneratedFolder(File frontendGeneratedFolder) {
        this.frontendGeneratedFolder = frontendGeneratedFolder;
        return this;
    }

    public Options withApplicationProperties(File applicationProperties) {
        this.applicationProperties = applicationProperties;
        return this;
    }

    public File getApplicationProperties() {
        return this.applicationProperties;
    }

    public Options withEndpointGeneratedOpenAPIFile(File endpointGeneratedOpenAPIFile) {
        this.endpointGeneratedOpenAPIFile = endpointGeneratedOpenAPIFile;
        return this;
    }

    public Options withEndpointSourceFolder(File endpointSourceFolder) {
        this.endpointSourceFolder = endpointSourceFolder;
        return this;
    }

    public Options useByteCodeScanner(boolean byteCodeScanner) {
        this.useByteCodeScanner = byteCodeScanner;
        return this;
    }

    public Options populateTokenFileData(JsonObject object) {
        this.tokenFileData = object;
        return this;
    }

    public Options withTokenFile(File tokenFile) {
        this.tokenFile = tokenFile;
        return this;
    }

    public Options enablePnpm(boolean enable) {
        this.enablePnpm = enable;
        return this;
    }

    public Options useGlobalPnpm(boolean useGlobalPnpm) {
        this.useGlobalPnpm = useGlobalPnpm;
        return this;
    }

    public Options withHomeNodeExecRequired(boolean requireHomeNodeExec) {
        this.requireHomeNodeExec = requireHomeNodeExec;
        return this;
    }

    public Options withNodeVersion(String nodeVersion) {
        this.nodeVersion = Objects.requireNonNull(nodeVersion);
        return this;
    }

    public Options withNodeDownloadRoot(URI nodeDownloadRoot) {
        this.nodeDownloadRoot = Objects.requireNonNull(nodeDownloadRoot);
        return this;
    }

    public Options withProductionMode(boolean productionMode) {
        this.productionMode = productionMode;
        return this;
    }

    public Options setNodeAutoUpdate(boolean update) {
        this.nodeAutoUpdate = update;
        return this;
    }

    public Options setJavaResourceFolder(File javaResourceFolder) {
        this.javaResourceFolder = javaResourceFolder;
        return this;
    }

    public Options withPostinstallPackages(List<String> postinstallPackages) {
        this.postinstallPackages = postinstallPackages;
        return this;
    }

    public File getNpmFolder() {
        return this.npmFolder;
    }

    public File getGeneratedFolder() {
        return this.generatedFolder;
    }

    public File getWebappResourcesDirectory() {
        return this.webappResourcesDirectory;
    }

    public File getFrontendDirectory() {
        return this.frontendDirectory;
    }

    public String getBuildDirectory() {
        return this.buildDirectory;
    }

    protected FeatureFlags getFeatureFlags() {
        FeatureFlags featureFlags = new FeatureFlags(this.lookup);
        if (this.javaResourceFolder != null) {
            featureFlags.setPropertiesLocation(this.javaResourceFolder);
        }
        return featureFlags;
    }

    public File getJarFrontendResourcesFolder() {
        return this.jarFrontendResourcesFolder;
    }

    public ClassFinder getClassFinder() {
        return this.classFinder;
    }
}

