/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.BrowserLiveReloadAccessor;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.SessionExpiredException;
import com.vaadin.flow.server.SystemMessages;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.AtmospherePushConnection;
import com.vaadin.flow.server.communication.LongPollingCacheFilter;
import com.vaadin.flow.server.communication.PushConnection;
import com.vaadin.flow.server.communication.ServerRpcHandler;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.shared.communication.PushMode;
import elemental.json.JsonException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushHandler {
    private int longPollingSuspendTimeout = -1;
    private final PushEventCallback establishCallback = (resource, ui) -> {
        PushHandler.getLogger().debug("New push connection for resource {} with transport {}", (Object)resource.uuid(), (Object)resource.transport());
        resource.getResponse().setContentType("text/plain; charset=UTF-8");
        VaadinSession session = ui.getSession();
        String requestToken = resource.getRequest().getParameter("v-pushId");
        if (!PushHandler.isPushIdValid(session, requestToken)) {
            PushHandler.getLogger().warn("Invalid identifier in new connection received from {}", (Object)resource.getRequest().getRemoteHost());
            PushHandler.sendRefreshAndDisconnect(resource);
            return;
        }
        this.suspend(resource);
        AtmospherePushConnection connection = PushHandler.getConnectionForUI(ui);
        assert (connection != null);
        connection.connect(resource);
    };
    private final PushEventCallback receiveCallback = (resource, ui) -> {
        PushHandler.getLogger().debug("Received message from resource {}", (Object)resource.uuid());
        AtmosphereRequest req = resource.getRequest();
        AtmospherePushConnection connection = PushHandler.getConnectionForUI(ui);
        assert (connection != null) : "Got push from the client even though the connection does not seem to be valid. This might happen if a HttpSession is serialized and deserialized while the push connection is kept open or if the UI has a connection of unexpected type.";
        Reader reader = connection.receiveMessage(req.getReader());
        if (reader == null) {
            return;
        }
        VaadinRequest vaadinRequest = VaadinService.getCurrentRequest();
        assert (vaadinRequest != null);
        try {
            new ServerRpcHandler().handleRpc(ui, reader, vaadinRequest);
            connection.push(false);
        }
        catch (JsonException e) {
            PushHandler.getLogger().error("Error writing JSON to response", (Throwable)e);
            PushHandler.sendRefreshAndDisconnect(resource);
        }
        catch (ServerRpcHandler.InvalidUIDLSecurityKeyException e) {
            PushHandler.getLogger().warn("Invalid security key received from {}", (Object)resource.getRequest().getRemoteHost());
            PushHandler.sendRefreshAndDisconnect(resource);
        }
    };
    private VaadinServletService service;

    public PushHandler(VaadinServletService service) {
        this.service = service;
    }

    protected void suspend(AtmosphereResource resource) {
        if (resource.transport() == AtmosphereResource.TRANSPORT.LONG_POLLING) {
            resource.suspend((long)this.getLongPollingSuspendTimeout());
        } else {
            resource.suspend(-1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callWithService(AtmosphereResource resource, Consumer<AtmosphereRequest> command) {
        AtmosphereRequest req = resource.getRequest();
        VaadinServletRequest vaadinRequest = new VaadinServletRequest((HttpServletRequest)req, this.service);
        this.service.setCurrentInstances(vaadinRequest, null);
        try {
            command.accept(req);
        }
        finally {
            CurrentInstance.clearAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callWithUi(AtmosphereResource resource, PushEventCallback callback) {
        boolean isWebsocket;
        AtmosphereRequest req = resource.getRequest();
        VaadinServletRequest vaadinRequest = new VaadinServletRequest((HttpServletRequest)req, this.service);
        VaadinSession session = null;
        boolean bl = isWebsocket = resource.transport() == AtmosphereResource.TRANSPORT.WEBSOCKET;
        if (isWebsocket) {
            this.service.requestStart(vaadinRequest, null);
        }
        try {
            try {
                session = this.service.findVaadinSession(vaadinRequest);
                assert (VaadinSession.getCurrent() == session);
            }
            catch (SessionExpiredException e) {
                PushHandler.sendNotificationAndDisconnect(resource, VaadinService.createSessionExpiredJSON(true));
                try {
                    if (isWebsocket) {
                        this.service.requestEnd(vaadinRequest, null, session);
                    }
                }
                catch (Exception e2) {
                    PushHandler.getLogger().warn("Error while ending request", (Throwable)e2);
                }
                return;
            }
            UI ui = null;
            session.lock();
            try {
                ui = this.service.findUI(vaadinRequest);
                assert (UI.getCurrent() == ui);
                if (ui == null) {
                    PushHandler.sendNotificationAndDisconnect(resource, VaadinService.createUINotFoundJSON(true));
                } else {
                    callback.run(resource, ui);
                }
            }
            catch (IOException e) {
                this.callErrorHandler(session, e);
            }
            catch (Exception e) {
                SystemMessages msg = this.service.getSystemMessages(HandlerHelper.findLocale(null, vaadinRequest), vaadinRequest);
                AtmosphereResource errorResource = resource;
                if (ui != null && ui.getInternals().getPushConnection() != null) {
                    errorResource = ((AtmospherePushConnection)ui.getInternals().getPushConnection()).getResource();
                }
                PushHandler.sendNotificationAndDisconnect(errorResource, VaadinService.createCriticalNotificationJSON(msg.getInternalErrorCaption(), msg.getInternalErrorMessage(), null, msg.getInternalErrorURL()));
                this.callErrorHandler(session, e);
            }
            finally {
                try {
                    session.unlock();
                }
                catch (Exception e) {
                    PushHandler.getLogger().warn("Error while unlocking session", (Throwable)e);
                }
            }
        }
        finally {
            try {
                if (isWebsocket) {
                    this.service.requestEnd(vaadinRequest, null, session);
                }
            }
            catch (Exception e) {
                PushHandler.getLogger().warn("Error while ending request", (Throwable)e);
            }
        }
    }

    private void callErrorHandler(VaadinSession session, Exception e) {
        session.getErrorHandler().error(new ErrorEvent(e));
    }

    private static AtmospherePushConnection getConnectionForUI(UI ui) {
        PushConnection pushConnection = ui.getInternals().getPushConnection();
        if (pushConnection instanceof AtmospherePushConnection) {
            return (AtmospherePushConnection)pushConnection;
        }
        return null;
    }

    void connectionLost(AtmosphereResourceEvent event) {
        boolean needsClear = VaadinSession.getCurrent() == null;
        try {
            this.handleConnectionLost(event);
        }
        finally {
            if (needsClear) {
                CurrentInstance.clearAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VaadinSession handleConnectionLost(AtmosphereResourceEvent event) {
        if (event == null) {
            PushHandler.getLogger().error("Could not get event. This should never happen.");
            return null;
        }
        AtmosphereResource resource = event.getResource();
        if (resource == null) {
            return null;
        }
        Optional<BrowserLiveReload> liveReload = BrowserLiveReloadAccessor.getLiveReloadFromService(this.service);
        if (this.isDebugWindowConnection(resource) && liveReload.isPresent() && liveReload.get().isLiveReload(resource)) {
            liveReload.get().onDisconnect(resource);
            return null;
        }
        VaadinServletRequest vaadinRequest = new VaadinServletRequest((HttpServletRequest)resource.getRequest(), this.service);
        VaadinSession session = null;
        try {
            session = this.service.findVaadinSession(vaadinRequest);
        }
        catch (SessionExpiredException e) {
            PushHandler.getLogger().debug("Session expired before push disconnect event was received", (Throwable)e);
            return session;
        }
        session.lock();
        try {
            VaadinSession.setCurrent(session);
            UI ui = this.service.findUI(vaadinRequest);
            if (ui == null) {
                ui = PushHandler.findUiUsingResource(resource, session.getUIs());
                if (ui == null) {
                    PushHandler.getLogger().debug("Could not get UI. This should never happen, except when reloading in Firefox and Chrome - see http://dev.vaadin.com/ticket/14251.");
                    VaadinSession vaadinSession = session;
                    return vaadinSession;
                }
                PushHandler.getLogger().info("No UI was found based on data in the request, but a slower lookup based on the AtmosphereResource succeeded. See http://dev.vaadin.com/ticket/14251 for more details.");
            }
            PushMode pushMode = ui.getPushConfiguration().getPushMode();
            AtmospherePushConnection pushConnection = PushHandler.getConnectionForUI(ui);
            String id = resource.uuid();
            if (pushConnection == null) {
                PushHandler.getLogger().warn("Could not find push connection to close: {} with transport {}", (Object)id, (Object)resource.transport());
            } else {
                if (!pushMode.isEnabled()) {
                    PushHandler.getLogger().debug("Connection closed for resource {}", (Object)id);
                } else {
                    PushHandler.getLogger().debug("Connection unexpectedly closed for resource {} with transport {}", (Object)id, (Object)resource.transport());
                }
                pushConnection.connectionLost();
            }
        }
        catch (Exception e) {
            this.callErrorHandler(session, e);
        }
        finally {
            try {
                session.unlock();
            }
            catch (Exception e) {
                PushHandler.getLogger().warn("Error while unlocking session", (Throwable)e);
            }
        }
        return session;
    }

    private static UI findUiUsingResource(AtmosphereResource resource, Collection<UI> uIs) {
        for (UI ui : uIs) {
            PushConnection pushConnection = ui.getInternals().getPushConnection();
            if (!(pushConnection instanceof AtmospherePushConnection) || ((AtmospherePushConnection)pushConnection).getResource() != resource) continue;
            return ui;
        }
        return null;
    }

    private static void sendRefreshAndDisconnect(AtmosphereResource resource) throws IOException {
        PushHandler.sendNotificationAndDisconnect(resource, VaadinService.createCriticalNotificationJSON(null, null, null, null));
    }

    private static void sendNotificationAndDisconnect(AtmosphereResource resource, String notificationJson) {
        try {
            if (resource instanceof AtmosphereResourceImpl && !((AtmosphereResourceImpl)resource).isInScope()) {
                PushHandler.getLogger().debug("sendNotificationAndDisconnect called for resource no longer in scope");
                return;
            }
            resource.getResponse().setContentType("application/json; charset=UTF-8");
            resource.getResponse().getWriter().write(notificationJson);
            resource.resume();
        }
        catch (Exception e) {
            PushHandler.getLogger().trace("Failed to send critical notification to client", (Throwable)e);
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)PushHandler.class.getName());
    }

    private static boolean isPushIdValid(VaadinSession session, String requestPushId) {
        String sessionPushId = session.getPushId();
        return requestPushId != null && MessageDigest.isEqual(requestPushId.getBytes(StandardCharsets.UTF_8), sessionPushId.getBytes(StandardCharsets.UTF_8));
    }

    void onConnect(AtmosphereResource resource) {
        if (this.isDebugWindowConnection(resource)) {
            if (this.isProductionMode()) {
                PushHandler.getLogger().debug("Debug window connection request denied while in production mode");
                return;
            }
            this.callWithService(resource, request -> BrowserLiveReloadAccessor.getLiveReloadFromService(this.service).ifPresent(liveReload -> liveReload.onConnect(resource)));
        } else {
            LongPollingCacheFilter.onConnect(resource);
            this.callWithUi(resource, this.establishCallback);
        }
    }

    private boolean isProductionMode() {
        VaadinContext context = this.service.getContext();
        ApplicationConfiguration conf = ApplicationConfiguration.get(context);
        return conf.isProductionMode();
    }

    void onMessage(AtmosphereResource resource) {
        if (this.isDebugWindowConnection(resource)) {
            this.callWithService(resource, this::handleDebugWindowMessage);
        } else {
            this.callWithUi(resource, this.receiveCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDebugWindowMessage(AtmosphereRequest request) {
        try {
            String msg = IOUtils.toString((Reader)request.getReader());
            Optional<BrowserLiveReload> liveReload = BrowserLiveReloadAccessor.getLiveReloadFromService(this.service);
            if (liveReload.isPresent()) {
                liveReload.get().onMessage(request.resource(), msg);
            } else {
                PushHandler.getLogger().error("Received message for debug window but there is no debug window connection available");
            }
        }
        catch (IOException e) {
            PushHandler.getLogger().error("Unable to read contents of debug connection message", (Throwable)e);
        }
        finally {
            CurrentInstance.clearAll();
        }
    }

    private boolean isDebugWindowConnection(AtmosphereResource resource) {
        String refreshConnection = resource.getRequest().getParameter("debug_window");
        return refreshConnection != null && AtmosphereResource.TRANSPORT.WEBSOCKET.equals((Object)resource.transport());
    }

    public void setLongPollingSuspendTimeout(int longPollingSuspendTimeout) {
        this.longPollingSuspendTimeout = longPollingSuspendTimeout;
    }

    public int getLongPollingSuspendTimeout() {
        return this.longPollingSuspendTimeout;
    }

    static interface PushEventCallback {
        public void run(AtmosphereResource var1, UI var2) throws IOException;
    }
}

