/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.SynchronizedRequestHandler;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WebBrowser;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class UnsupportedBrowserHandler
extends SynchronizedRequestHandler {
    public static final String FORCE_LOAD_COOKIE = "vaadinforceload=1";
    public static final String CLOSING_BRACKET = "    }";
    private static final String UNSUPPORTED_PAGE_HEAD_CONTENT = "<head>  <style>    html {      background: #fff;      color: #444;      font: 400 1em/1.5 \"Helvetica Neue\", Roboto, \"Segoe UI\", sans-serif;      padding: 2em;    }    body {      margin: 2em auto;      width: 28em;      max-width: 100%;    }    h1 {      line-height: 1.1;      margin: 2em 0 1em;      color: #000;      font-weight: 400;    }    p {      margin: 0.5em 0 0;    }    a {      text-decoration: none;      color: #007df0;    }    sub {      display: block;      margin-top: 2.5em;      text-align: center;      border-top: 1px solid #eee;      padding-top: 2em;    }    sub,    small {      color: #999;    }  </style></head>";

    @Override
    public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        WebBrowser browser = session.getBrowser();
        String cookie = request.getHeader("Cookie");
        if (browser.isTooOldToFunctionProperly() && (cookie == null || !cookie.contains(FORCE_LOAD_COOKIE))) {
            this.writeBrowserTooOldPage(request, response);
            return true;
        }
        return false;
    }

    protected void writeBrowserTooOldPage(VaadinRequest request, VaadinResponse response) throws IOException {
        PrintWriter page = response.getWriter();
        WebBrowser browser = VaadinSession.getCurrent().getBrowser();
        response.setContentType("text/html; charset=utf-8");
        ((Writer)page).write("<html><head>  <style>    html {      background: #fff;      color: #444;      font: 400 1em/1.5 \"Helvetica Neue\", Roboto, \"Segoe UI\", sans-serif;      padding: 2em;    }    body {      margin: 2em auto;      width: 28em;      max-width: 100%;    }    h1 {      line-height: 1.1;      margin: 2em 0 1em;      color: #000;      font-weight: 400;    }    p {      margin: 0.5em 0 0;    }    a {      text-decoration: none;      color: #007df0;    }    sub {      display: block;      margin-top: 2.5em;      text-align: center;      border-top: 1px solid #eee;      padding-top: 2em;    }    sub,    small {      color: #999;    }  </style></head><body><h1>I'm sorry, but your browser is not supported</h1><p>The version (" + browser.getBrowserMajorVersion() + "." + browser.getBrowserMinorVersion() + ") of the browser you are using  is outdated and not supported.</p><p>You should <b>consider upgrading</b> to a more up-to-date browser.</p> <p>The most popular browsers are <b> <a href=\"https://www.google.com/chrome\">Chrome</a>, <a href=\"http://www.mozilla.com/firefox\">Firefox</a>," + (browser.isWindows() ? " <a href=\"https://www.microsoft.com/en-us/windows/microsoft-edge\">Edge</a>," : "") + " <a href=\"http://www.opera.com/browser\">Opera</a> and <a href=\"http://www.apple.com/safari\">Safari</a>.</b><br/>Upgrading to the latest version of one of these <b>will make the web safer, faster and better looking.</b></p><p><sub><a onclick=\"document.cookie='vaadinforceload=1';window.location.reload();return false;\" href=\"#\">Continue without updating</a> (not recommended)</sub></p></body>\n</html>");
        ((Writer)page).close();
    }
}

