/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class TaskGenerateTsConfig
extends AbstractTaskClientGenerator {
    private static final String COMPILER_OPTIONS = "compilerOptions";
    static final String TSCONFIG_JSON = "tsconfig.json";
    private static final String VERSION = "flow_version";
    private static final String ES_TARGET_VERSION = "target";
    private static final String TSCONFIG_JSON_OLDER_VERSIONS_TEMPLATE = "tsconfig-%s.json";
    private static final String[] vaadinVersions = new String[]{"latest", "v23.3.0", "v23.2", "v23.1", "v22", "v14", "osgi"};
    static final String ERROR_MESSAGE = "%n%n**************************************************************************%n*  TypeScript config file 'tsconfig.json' has been updated to the latest *%n*  version by Vaadin. Please verify that the updated 'tsconfig.json'     *%n*  file contains configuration needed for your project (add missing part *%n*  from the old file if necessary) and restart the application.          *%n**************************************************************************%n%n";
    private final File projectRootDir;
    private final FeatureFlags featureFlags;

    TaskGenerateTsConfig(File projectRootDir, FeatureFlags featureFlags) {
        this.projectRootDir = projectRootDir;
        this.featureFlags = featureFlags;
    }

    @Override
    protected String getFileContent() throws IOException {
        return this.getFileContentForVersion("latest");
    }

    private String getFileContentForVersion(String vaadinVersion) throws IOException {
        String fileName = "latest".equals(vaadinVersion) ? TSCONFIG_JSON : String.format(TSCONFIG_JSON_OLDER_VERSIONS_TEMPLATE, vaadinVersion);
        try (InputStream tsConfStream = this.getClass().getResourceAsStream(fileName);){
            String config = IOUtils.toString((InputStream)tsConfStream, (Charset)StandardCharsets.UTF_8);
            if (this.featureFlags.isEnabled(FeatureFlags.WEBPACK)) {
                config = config.replaceFirst("\"target\".*", "\"target\": \"es2019\",");
            }
            String string = config;
            return string;
        }
    }

    @Override
    public void execute() throws ExecutionFailedException {
        if (this.shouldGenerate()) {
            super.execute();
        } else {
            this.overrideIfObsolete();
            if (this.featureFlags.isEnabled(FeatureFlags.WEBPACK)) {
                this.ensureTarget("es2019");
            } else {
                this.ensureTarget(this.getDefaultEsTargetVersion());
            }
        }
    }

    private void ensureTarget(String esVersion) {
        try {
            File projectTsconfig = new File(this.projectRootDir, TSCONFIG_JSON);
            String current = FileUtils.readFileToString((File)projectTsconfig, (Charset)StandardCharsets.UTF_8);
            String currentEsVersion = this.getEsTargetVersion(current);
            if (!currentEsVersion.equals(esVersion)) {
                current = current.replace(currentEsVersion, esVersion);
                TaskGenerateTsConfig.writeIfChanged(projectTsconfig, current);
            }
        }
        catch (Exception e) {
            TaskGenerateTsConfig.log().debug("Unable to modify target version in tsconfig.json", (Throwable)e);
        }
    }

    private String getDefaultEsTargetVersion() throws ExecutionFailedException {
        try {
            String defaultTsConfig = this.getFileContent();
            return this.getEsTargetVersion(defaultTsConfig);
        }
        catch (Exception e) {
            throw new ExecutionFailedException("Error finding default es target value", e);
        }
    }

    private String getEsTargetVersion(String tsConfig) {
        JsonObject parsed = this.parseTsConfig(tsConfig);
        return parsed.getObject(COMPILER_OPTIONS).getString(ES_TARGET_VERSION);
    }

    private JsonObject parseTsConfig(String tsConfig) {
        String json = tsConfig.replaceAll("//.*", "");
        return Json.parse((String)json);
    }

    @Override
    protected File getGeneratedFile() {
        return new File(this.projectRootDir, TSCONFIG_JSON);
    }

    @Override
    protected boolean shouldGenerate() {
        return !new File(this.projectRootDir, TSCONFIG_JSON).exists();
    }

    private void overrideIfObsolete() throws ExecutionFailedException {
        try {
            JsonObject projectTsConfigContent;
            File projectTsConfigFile = new File(this.projectRootDir.getPath(), TSCONFIG_JSON);
            String projectTsConfigAsString = FileUtils.readFileToString((File)projectTsConfigFile, (Charset)StandardCharsets.UTF_8);
            try {
                projectTsConfigContent = this.parseTsConfig(projectTsConfigAsString);
            }
            catch (Exception e) {
                TaskGenerateTsConfig.log().error("Unable to parse tsconfig.json", (Throwable)e);
                return;
            }
            String latestTsConfigTemplate = this.getFileContent();
            JsonObject latestTsConfigTemplateJson = this.parseTsConfig(latestTsConfigTemplate);
            if (projectTsConfigContent.hasKey(VERSION)) {
                assert (latestTsConfigTemplateJson.hasKey(VERSION)) : "Latest tsconfig.json template should have version";
                String version = projectTsConfigContent.getString(VERSION);
                String templateVersion = latestTsConfigTemplateJson.getString(VERSION);
                if (templateVersion.equals(version)) {
                    return;
                }
            }
            for (String version : vaadinVersions) {
                String oldTsConfigContent = this.getFileContentForVersion(version);
                JsonObject tsConfigTemplateJson = this.parseTsConfig(oldTsConfigContent);
                if (!this.tsConfigsEqual(tsConfigTemplateJson, projectTsConfigContent)) continue;
                TaskGenerateTsConfig.writeIfChanged(projectTsConfigFile, latestTsConfigTemplate);
                return;
            }
            TaskGenerateTsConfig.writeIfChanged(projectTsConfigFile, latestTsConfigTemplate);
            throw new ExecutionFailedException(String.format(ERROR_MESSAGE, new Object[0]));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean tsConfigsEqual(JsonObject template, JsonObject projectTsConfig) {
        if (template.hasKey(COMPILER_OPTIONS)) {
            template.getObject(COMPILER_OPTIONS).remove(ES_TARGET_VERSION);
        }
        if (projectTsConfig.hasKey(COMPILER_OPTIONS)) {
            projectTsConfig.getObject(COMPILER_OPTIONS).remove(ES_TARGET_VERSION);
        }
        template.remove(VERSION);
        projectTsConfig.remove(VERSION);
        return this.removeWhiteSpaces(template.toJson()).equals(this.removeWhiteSpaces(projectTsConfig.toJson()));
    }

    private String removeWhiteSpaces(String content) {
        return content.replaceAll("\\s", "");
    }
}

