/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FallibleCommand;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTaskClientGenerator
implements FallibleCommand {
    protected abstract String getFileContent() throws IOException;

    protected abstract File getGeneratedFile();

    protected abstract boolean shouldGenerate();

    @Override
    public void execute() throws ExecutionFailedException {
        if (!this.shouldGenerate()) {
            return;
        }
        File generatedFile = this.getGeneratedFile();
        try {
            String fileContent = this.getFileContent();
            AbstractTaskClientGenerator.writeIfChanged(generatedFile, fileContent);
        }
        catch (IOException exception) {
            String errorMessage = String.format("Error writing '%s'", generatedFile);
            throw new ExecutionFailedException(errorMessage, exception);
        }
    }

    static Logger log() {
        return LoggerFactory.getLogger(AbstractTaskClientGenerator.class);
    }

    static boolean writeIfChanged(File file, String content) throws IOException {
        String existingFileContent = AbstractTaskClientGenerator.getExistingFileContent(file);
        if (content.equals(existingFileContent)) {
            return false;
        }
        AbstractTaskClientGenerator.log().debug("writing file '{}'", (Object)file);
        FileUtils.forceMkdirParent((File)file);
        FileUtils.writeStringToFile((File)file, (String)content, (Charset)StandardCharsets.UTF_8);
        return true;
    }

    private static String getExistingFileContent(File generatedFile) throws IOException {
        if (!generatedFile.exists()) {
            return null;
        }
        return FileUtils.readFileToString((File)generatedFile, (Charset)StandardCharsets.UTF_8);
    }
}

