/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.component.PushConfiguration;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.NodeMap;
import com.vaadin.flow.server.communication.PushConnectionFactory;
import com.vaadin.flow.shared.communication.PushMode;
import com.vaadin.flow.shared.ui.Transport;
import java.io.Serializable;
import java.util.Collection;

public class PushConfigurationMap
extends NodeMap
implements PushConfiguration {
    public static final String TRANSPORT_KEY = "transport";
    public static final String FALLBACK_TRANSPORT_KEY = "fallbackTransport";
    public static final String PUSHMODE_KEY = "pushMode";
    public static final String ALWAYS_USE_XHR_TO_SERVER = "alwaysXhrToServer";
    public static final String PARAMETERS_KEY = "parameters";

    public PushConfigurationMap(StateNode node) {
        super(node);
    }

    @Override
    public void setTransport(Transport transport) {
        if (transport == Transport.WEBSOCKET_XHR) {
            this.getParameters().put(TRANSPORT_KEY, (Serializable)((Object)Transport.WEBSOCKET.getIdentifier()));
            this.put(ALWAYS_USE_XHR_TO_SERVER, Boolean.valueOf(true));
        } else {
            this.getParameters().put(TRANSPORT_KEY, (Serializable)((Object)transport.getIdentifier()));
            this.remove(ALWAYS_USE_XHR_TO_SERVER);
        }
    }

    private NodeMap getParameters() {
        if (!this.contains(PARAMETERS_KEY)) {
            this.put(PARAMETERS_KEY, new StateNode(PushConfigurationParametersMap.class));
        }
        return ((StateNode)this.get(PARAMETERS_KEY)).getFeature(PushConfigurationParametersMap.class);
    }

    @Override
    public Transport getTransport() {
        if (!this.getParameters().contains(TRANSPORT_KEY)) {
            return null;
        }
        Transport tr = Transport.getByIdentifier(this.getParameters().get(TRANSPORT_KEY).toString());
        if (tr == Transport.WEBSOCKET && this.contains(ALWAYS_USE_XHR_TO_SERVER)) {
            return Transport.WEBSOCKET_XHR;
        }
        return tr;
    }

    @Override
    public void setFallbackTransport(Transport fallbackTransport) {
        if (fallbackTransport == Transport.WEBSOCKET_XHR) {
            throw new IllegalArgumentException("WEBSOCKET_XHR can only be used as primary transport");
        }
        this.getParameters().put(FALLBACK_TRANSPORT_KEY, (Serializable)((Object)fallbackTransport.getIdentifier()));
    }

    @Override
    public Transport getFallbackTransport() {
        if (!this.getParameters().contains(FALLBACK_TRANSPORT_KEY)) {
            return null;
        }
        return Transport.getByIdentifier(this.getParameters().get(FALLBACK_TRANSPORT_KEY).toString());
    }

    @Override
    public void setPushMode(PushMode pushMode) {
        this.put(PUSHMODE_KEY, (Serializable)((Object)pushMode.name()));
    }

    @Override
    public PushMode getPushMode() {
        return PushMode.valueOf(this.get(PUSHMODE_KEY).toString());
    }

    @Override
    public String getParameter(String key) {
        return (String)((Object)this.getParameters().get(key));
    }

    @Override
    public void setParameter(String key, String value) {
        this.getParameters().put(key, (Serializable)((Object)value));
    }

    @Override
    public Collection<String> getParameterNames() {
        return this.getParameters().keySet();
    }

    @Override
    public void setPushConnectionFactory(PushConnectionFactory factory) {
        throw new UnsupportedOperationException("Setting push connection factory is not supported");
    }

    public static class PushConfigurationParametersMap
    extends NodeMap {
        public PushConfigurationParametersMap(StateNode node) {
            super(node);
        }
    }
}

