/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.SystemMessages;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;

public class HandlerHelper
implements Serializable {
    static final SystemMessages DEFAULT_SYSTEM_MESSAGES = new SystemMessages();
    static final String UNSAFE_PATH_ERROR_MESSAGE_PATTERN = "Blocked attempt to access file: {}";
    private static final Pattern PARENT_DIRECTORY_REGEX = Pattern.compile("(/|\\\\)\\.\\.(/|\\\\)?", 2);

    private HandlerHelper() {
    }

    public static boolean isRequestType(VaadinRequest request, RequestType requestType) {
        return requestType.getIdentifier().equals(request.getParameter("v-r"));
    }

    public static Locale findLocale(VaadinSession session, VaadinRequest request) {
        Locale locale;
        if (session == null) {
            session = VaadinSession.getCurrent();
        }
        if (session != null && (locale = session.getLocale()) != null) {
            return locale;
        }
        if (request == null) {
            request = VaadinService.getCurrentRequest();
        }
        if (request != null && (locale = request.getLocale()) != null) {
            return locale;
        }
        return Locale.getDefault();
    }

    public static void setResponseNoCacheHeaders(BiConsumer<String, String> headerSetter, BiConsumer<String, Long> longHeaderSetter) {
        headerSetter.accept("Cache-Control", "no-cache, no-store");
        headerSetter.accept("Pragma", "no-cache");
        longHeaderSetter.accept("Expires", 0L);
    }

    public static String getCancelingRelativePath(String pathToCancel) {
        StringBuilder sb = new StringBuilder(".");
        for (int i = 1; i < pathToCancel.length(); ++i) {
            if (pathToCancel.charAt(i) != '/') continue;
            sb.append("/..");
        }
        return sb.toString();
    }

    public static boolean isPathUnsafe(String path) {
        try {
            path = URLDecoder.decode(path, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("An error occurred during decoding URL.", e);
        }
        return PARENT_DIRECTORY_REGEX.matcher(path).find();
    }

    public static enum RequestType {
        UIDL("uidl"),
        WEBCOMPONENT_RESYNC("webcomponent-resync"),
        HEARTBEAT("heartbeat"),
        PUSH("push");

        private String identifier;

        private RequestType(String identifier) {
            this.identifier = identifier;
        }

        public String getIdentifier() {
            return this.identifier;
        }
    }
}

