/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.server.CompatibilityModeStatus;
import com.vaadin.flow.server.DefaultDeploymentConfiguration;
import com.vaadin.flow.server.PropertyDeploymentConfiguration;
import com.vaadin.flow.server.VaadinConfig;
import com.vaadin.flow.server.VaadinConfigurationException;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServletConfiguration;
import com.vaadin.flow.server.frontend.FallbackChunk;
import com.vaadin.flow.server.frontend.FrontendUtils;
import elemental.json.JsonObject;
import elemental.json.impl.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeploymentConfigurationFactory
implements Serializable {
    public static final Object DEV_MODE_ENABLE_STRATEGY = new Serializable(){};
    public static final Object FALLBACK_CHUNK = new Serializable(){};
    public static final String ERROR_COMPATIBILITY_MODE_UNSET = "Unable to determine mode of operation. To use npm mode, ensure 'flow-build-info.json' exists on the classpath. With Maven, this is handled by the 'prepare-frontend' goal. To use compatibility mode, add the 'flow-server-compatibility-mode' dependency. If using Vaadin with Spring Boot, instead set the property 'vaadin.compatibilityMode' to 'true' in 'application.properties'.";
    public static final String ERROR_DEV_MODE_NO_FILES = "The compatibility mode is explicitly set to 'false', but there are neither 'flow-build-info.json' nor 'webpack.config.js' file available in the project/working directory. Ensure 'webpack.config.js' is present or trigger creation of 'flow-build-info.json' via running 'prepare-frontend' Maven goal.";
    public static final String DEV_FOLDER_MISSING_MESSAGE = "Running project in development mode with no access to folder '%s'.%nBuild project in production mode instead, see https://vaadin.com/docs/v14/flow/production/tutorial-production-mode-basic.html";
    private static final Logger logger = LoggerFactory.getLogger(DeploymentConfigurationFactory.class);

    private DeploymentConfigurationFactory() {
    }

    public static DeploymentConfiguration createDeploymentConfiguration(Class<?> systemPropertyBaseClass, VaadinConfig vaadinConfig) throws VaadinConfigurationException {
        return new DefaultDeploymentConfiguration(systemPropertyBaseClass, DeploymentConfigurationFactory.createInitParameters(systemPropertyBaseClass, vaadinConfig));
    }

    public static DeploymentConfiguration createPropertyDeploymentConfiguration(Class<?> systemPropertyBaseClass, VaadinConfig vaadinConfig) throws VaadinConfigurationException {
        return new PropertyDeploymentConfiguration(systemPropertyBaseClass, DeploymentConfigurationFactory.createInitParameters(systemPropertyBaseClass, vaadinConfig));
    }

    protected static Properties createInitParameters(Class<?> systemPropertyBaseClass, VaadinConfig vaadinConfig) throws VaadinConfigurationException {
        String name;
        Properties initParameters = new Properties();
        DeploymentConfigurationFactory.readUiFromEnclosingClass(systemPropertyBaseClass, initParameters);
        DeploymentConfigurationFactory.readConfigurationAnnotation(systemPropertyBaseClass, initParameters);
        VaadinContext context = vaadinConfig.getVaadinContext();
        Enumeration<String> e = context.getContextParameterNames();
        while (e.hasMoreElements()) {
            name = e.nextElement();
            initParameters.setProperty(name, context.getContextParameter(name));
        }
        e = vaadinConfig.getConfigParameterNames();
        while (e.hasMoreElements()) {
            name = e.nextElement();
            initParameters.setProperty(name, vaadinConfig.getConfigParameter(name));
        }
        DeploymentConfigurationFactory.readBuildInfo(systemPropertyBaseClass, initParameters, vaadinConfig.getVaadinContext());
        return initParameters;
    }

    private static void readBuildInfo(Class<?> systemPropertyBaseClass, Properties initParameters, VaadinContext context) {
        String json = DeploymentConfigurationFactory.getTokenFileContents(systemPropertyBaseClass, initParameters, context);
        if (json != null) {
            JsonObject buildInfo = (JsonObject)JsonUtil.parse((String)json);
            DeploymentConfigurationFactory.setInitParametersUsingTokenData(initParameters, buildInfo);
            FallbackChunk fallbackChunk = FrontendUtils.readFallbackChunk(buildInfo);
            if (fallbackChunk != null) {
                initParameters.put(FALLBACK_CHUNK, fallbackChunk);
            }
        }
        try {
            boolean hasWebPackConfig = DeploymentConfigurationFactory.hasWebpackConfig(initParameters);
            boolean hasTokenFile = json != null;
            SerializableConsumer strategy = value -> DeploymentConfigurationFactory.verifyMode(value, hasTokenFile, hasWebPackConfig);
            initParameters.put(DEV_MODE_ENABLE_STRATEGY, strategy);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void setInitParametersUsingTokenData(Properties initParameters, JsonObject buildInfo) {
        if (buildInfo.hasKey("productionMode")) {
            initParameters.setProperty("productionMode", String.valueOf(buildInfo.getBoolean("productionMode")));
        }
        if (buildInfo.hasKey("externalStatsFile") || buildInfo.hasKey("externalStatsUrl")) {
            initParameters.setProperty("compatibilityMode", Boolean.toString(false));
            initParameters.setProperty("enableDevServer", Boolean.toString(false));
            initParameters.setProperty("external.stats.file", Boolean.toString(true));
            if (buildInfo.hasKey("externalStatsUrl")) {
                initParameters.setProperty("external.stats.url", buildInfo.getString("externalStatsUrl"));
            }
            return;
        }
        if (buildInfo.hasKey("compatibilityMode")) {
            initParameters.setProperty("compatibilityMode", String.valueOf(buildInfo.getBoolean("compatibilityMode")));
            System.clearProperty("vaadin.compatibilityMode");
        }
        if (buildInfo.hasKey("npmFolder")) {
            initParameters.setProperty("project.basedir", buildInfo.getString("npmFolder"));
            DeploymentConfigurationFactory.verifyFolderExists(initParameters, buildInfo.getString("npmFolder"));
        }
        if (buildInfo.hasKey("node.version")) {
            initParameters.setProperty("node.version", buildInfo.getString("node.version"));
        }
        if (buildInfo.hasKey("node.download.root")) {
            initParameters.setProperty("node.download.root", buildInfo.getString("node.download.root"));
        }
        if (buildInfo.hasKey("frontendFolder")) {
            initParameters.setProperty("vaadin.frontend.frontend.folder", buildInfo.getString("frontendFolder"));
            if (!buildInfo.hasKey("npmFolder") || !buildInfo.getString("frontendFolder").startsWith(buildInfo.getString("npmFolder"))) {
                DeploymentConfigurationFactory.verifyFolderExists(initParameters, buildInfo.getString("frontendFolder"));
            }
        }
        if (buildInfo.hasKey("enableDevServer")) {
            initParameters.setProperty("enableDevServer", String.valueOf(buildInfo.getBoolean("enableDevServer")));
        }
        if (buildInfo.hasKey("reuseDevServer")) {
            initParameters.setProperty("reuseDevServer", String.valueOf(buildInfo.getBoolean("reuseDevServer")));
        }
        if (buildInfo.hasKey("oldLicenseChecker")) {
            initParameters.setProperty("oldLicenseChecker", String.valueOf(buildInfo.getBoolean("oldLicenseChecker")));
        }
        DeploymentConfigurationFactory.setDevModePropertiesUsingTokenData(initParameters, buildInfo);
    }

    private static void setDevModePropertiesUsingTokenData(Properties initParameters, JsonObject buildInfo) {
        if (initParameters.getProperty("pnpm.enable") == null && buildInfo.hasKey("pnpm.enable")) {
            initParameters.setProperty("pnpm.enable", String.valueOf(buildInfo.getBoolean("pnpm.enable")));
        }
        if (initParameters.getProperty("require.home.node") == null && buildInfo.hasKey("require.home.node")) {
            initParameters.setProperty("require.home.node", String.valueOf(buildInfo.getBoolean("require.home.node")));
        }
    }

    private static String getTokenFileContents(Class<?> systemPropertyBaseClass, Properties initParameters, VaadinContext context) {
        String json = null;
        try {
            json = DeploymentConfigurationFactory.getResourceFromFile(initParameters);
            if (json == null) {
                json = DeploymentConfigurationFactory.getTokenFileFromClassloader(systemPropertyBaseClass, context);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return json;
    }

    private static String getResourceFromFile(Properties initParameters) throws IOException {
        File tokenFile;
        String json = null;
        String tokenLocation = initParameters.getProperty("vaadin.frontend.token.file");
        if (tokenLocation != null && (tokenFile = new File(tokenLocation)) != null && tokenFile.canRead()) {
            json = FileUtils.readFileToString((File)tokenFile, (Charset)StandardCharsets.UTF_8);
        }
        return json;
    }

    private static String getTokenFileFromClassloader(Class<?> contextClass, VaadinContext context) throws IOException {
        String tokenResource = "META-INF/VAADIN/config/flow-build-info.json";
        Lookup lookup = context.getAttribute(Lookup.class);
        ResourceProvider resourceProvider = lookup.lookup(ResourceProvider.class);
        List<URL> resources = resourceProvider.getApplicationResources(context, tokenResource);
        URL resource = resources.stream().filter(url -> !url.getPath().endsWith("jar!/" + tokenResource)).findFirst().orElse(null);
        if (resource == null && !resources.isEmpty()) {
            return DeploymentConfigurationFactory.getPossibleJarResource(context, resources);
        }
        return resource == null ? null : FrontendUtils.streamToString(resource.openStream());
    }

    private static String getPossibleJarResource(VaadinContext context, List<URL> resources) throws IOException {
        Objects.requireNonNull(resources);
        Lookup lookup = context.getAttribute(Lookup.class);
        ResourceProvider resourceProvider = lookup.lookup(ResourceProvider.class);
        assert (!resources.isEmpty()) : "Possible jar resource requires resources to be available.";
        URL webpackGenerated = resourceProvider.getApplicationResource(context, "webpack.generated.js");
        if (webpackGenerated != null && DeploymentConfigurationFactory.countInstances(webpackGenerated.getPath(), "jar!/") >= 2) {
            for (URL resource : resources) {
                if (DeploymentConfigurationFactory.countInstances(resource.getPath(), "jar!/") != 1) continue;
                return FrontendUtils.streamToString(resource.openStream());
            }
        }
        URL firstResource = resources.get(0);
        if (resources.size() > 1) {
            String warningMessage = String.format("Unable to fully determine correct flow-build-info.%nAccepting file '%s' first match of '%s' possible.%nPlease verify flow-build-info file content.", firstResource.getPath(), resources.size());
            logger.warn(warningMessage);
        } else {
            String debugMessage = String.format("Unable to fully determine correct flow-build-info.%nAccepting file '%s'", firstResource.getPath());
            logger.debug(debugMessage);
        }
        return FrontendUtils.streamToString(firstResource.openStream());
    }

    private static int countInstances(String input, String value) {
        return input.split(value, -1).length - 1;
    }

    private static void verifyFolderExists(Properties initParameters, String folder) {
        Boolean productionMode = Boolean.parseBoolean(initParameters.getProperty("productionMode", "false"));
        if (!productionMode.booleanValue() && !new File(folder).exists()) {
            String message = String.format(DEV_FOLDER_MISSING_MESSAGE, folder);
            throw new IllegalStateException(message);
        }
    }

    private static void verifyMode(CompatibilityModeStatus value, boolean hasTokenFile, boolean hasWebpackConfig) {
        if (value == CompatibilityModeStatus.UNDEFINED) {
            if (!hasWebpackConfig) {
                throw new IllegalStateException(ERROR_COMPATIBILITY_MODE_UNSET);
            }
        } else if (!hasTokenFile && !hasWebpackConfig) {
            throw new IllegalStateException(ERROR_DEV_MODE_NO_FILES);
        }
        if (!hasTokenFile && hasWebpackConfig) {
            logger.warn("Found 'webpack.config.js' in the project/working directory. Will use it for webpack dev server.");
        }
    }

    private static boolean hasWebpackConfig(Properties initParameters) throws IOException {
        String baseDir = initParameters.getProperty("project.basedir");
        File projectBaseDir = baseDir == null ? new File(".") : new File(baseDir);
        File webPackConfig = new File(projectBaseDir, "webpack.config.js");
        return FrontendUtils.isWebpackConfigFile(webPackConfig);
    }

    private static void readUiFromEnclosingClass(Class<?> systemPropertyBaseClass, Properties initParameters) {
        Class<?> enclosingClass = systemPropertyBaseClass.getEnclosingClass();
        if (enclosingClass != null && UI.class.isAssignableFrom(enclosingClass)) {
            initParameters.put("UI", enclosingClass.getName());
        }
    }

    private static void readConfigurationAnnotation(Class<?> systemPropertyBaseClass, Properties initParameters) throws VaadinConfigurationException {
        Method[] methods;
        Optional<VaadinServletConfiguration> optionalConfigAnnotation = AnnotationReader.getAnnotationFor(systemPropertyBaseClass, VaadinServletConfiguration.class);
        if (!optionalConfigAnnotation.isPresent()) {
            return;
        }
        VaadinServletConfiguration configuration = optionalConfigAnnotation.get();
        for (Method method : methods = VaadinServletConfiguration.class.getDeclaredMethods()) {
            VaadinServletConfiguration.InitParameterName name = method.getAnnotation(VaadinServletConfiguration.InitParameterName.class);
            assert (name != null) : "All methods declared in VaadinServletConfiguration should have a @InitParameterName annotation";
            try {
                Object value = method.invoke((Object)configuration, new Object[0]);
                String stringValue = value instanceof Class ? ((Class)value).getName() : value.toString();
                initParameters.setProperty(name.value(), stringValue);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new VaadinConfigurationException("Could not read @VaadinServletConfiguration value " + method.getName(), e);
            }
        }
    }
}

