/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.CompatibilityModeStatus;
import com.vaadin.flow.server.DeploymentConfigurationFactory;
import com.vaadin.flow.server.PropertyDeploymentConfiguration;
import com.vaadin.flow.shared.communication.PushMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDeploymentConfiguration
extends PropertyDeploymentConfiguration {
    public static final String NOT_PRODUCTION_MODE_INFO = "\nVaadin is running in DEBUG MODE.\nWhen deploying application for production, remember to disable debug features. See more from https://vaadin.com/docs/";
    public static final String WARNING_COMPATIBILITY_MODE = "Running in Vaadin 13 (Flow 1) compatibility mode.\n\nThis mode uses webjars/Bower for client side dependency management and HTML imports for dependency loading.\n\nThe default mode in Vaadin 14+ (Flow 2+) is based on npm for dependency management and JavaScript modules for dependency inclusion.\n\nSee http://vaadin.com/docs for more information.";
    public static final String WARNING_LIVERELOAD_DISABLED_AND_NEW_LICENSE_CHECKER = "Server-side and offline new license checking features are enabled while the development mode live reload is not available.\nNew license checking requires enabled live reload and would fallback to old license checker otherwise.\nCheck that the application is not running in compatibility mode, live reload is not disabled and dev server is enabled.";
    public static final String NOT_PRODUCTION_MODE_WARNING = "\nWARNING: Vaadin is running in DEBUG MODE with debug features enabled, but with a prebuild frontend bundle (production ready).\nWhen deploying application for production, disable debug features by enabling production mode!\nSee more from https://vaadin.com/docs/v14/flow/production/overview";
    private static final String DEPLOYMENT_WARNINGS = "Following issues were discovered with deployment configuration:";
    public static final String WARNING_XSRF_PROTECTION_DISABLED = "WARNING: Cross-site request forgery protection is disabled!";
    public static final String WARNING_HEARTBEAT_INTERVAL_NOT_NUMERIC = "WARNING: heartbeatInterval has been set to a non integer value.\n The default of 5min will be used.";
    public static final String WARNING_PUSH_MODE_NOT_RECOGNIZED = "WARNING: pushMode has been set to an unrecognized value.\nThe permitted values are \"disabled\", \"manual\",\nand \"automatic\". The default of \"disabled\" will be used.";
    public static final int DEFAULT_HEARTBEAT_INTERVAL = 300;
    public static final int DEFAULT_MAX_MESSAGE_SUSPEND_TIMEOUT = 5000;
    public static final int DEFAULT_WEB_COMPONENT_DISCONNECT = 300;
    public static final boolean DEFAULT_CLOSE_IDLE_SESSIONS = false;
    public static final boolean DEFAULT_SYNC_ID_CHECK = true;
    public static final boolean DEFAULT_SEND_URLS_AS_PARAMETERS = true;
    private boolean productionMode;
    private boolean compatibilityMode;
    private boolean xsrfProtectionEnabled;
    private int heartbeatInterval;
    private int maxMessageSuspendTimeout;
    private int webComponentDisconnect;
    private boolean closeIdleSessions;
    private PushMode pushMode;
    private String pushURL;
    private boolean syncIdCheck;
    private boolean sendUrlsAsParameters;
    private boolean requestTiming;
    private static AtomicBoolean logging = new AtomicBoolean(true);
    private List<String> warnings = new ArrayList<String>();
    private List<String> info = new ArrayList<String>();

    public DefaultDeploymentConfiguration(Class<?> systemPropertyBaseClass, Properties initParameters) {
        super(systemPropertyBaseClass, initParameters);
        boolean log = logging.getAndSet(false);
        this.checkProductionMode(log);
        this.checkCompatibilityMode(log);
        this.checkNewLicenseChecker(log);
        this.checkRequestTiming();
        this.checkXsrfProtection(log);
        this.checkHeartbeatInterval();
        this.checkMaxMessageSuspendTimeout();
        this.checkWebComponentDisconnectTimeout();
        this.checkCloseIdleSessions();
        this.checkPushMode();
        this.checkPushURL();
        this.checkSyncIdCheck();
        this.checkSendUrlsAsParameters();
        if (log) {
            this.logMessages();
        }
    }

    private void logMessages() {
        Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
        if (!this.warnings.isEmpty()) {
            this.warnings.add(0, DEPLOYMENT_WARNINGS);
            this.warnings.addAll(this.info);
            if (logger.isWarnEnabled()) {
                logger.warn(String.join((CharSequence)"\n", this.warnings));
            }
        } else if (!this.info.isEmpty() && logger.isInfoEnabled()) {
            logger.info(String.join((CharSequence)"\n", this.info));
        }
    }

    @Override
    public boolean isProductionMode() {
        return this.productionMode;
    }

    @Override
    public boolean isBowerMode() {
        return this.compatibilityMode;
    }

    @Override
    public boolean isRequestTiming() {
        return this.requestTiming;
    }

    @Override
    public boolean isXsrfProtectionEnabled() {
        return this.xsrfProtectionEnabled;
    }

    @Override
    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    @Override
    public int getMaxMessageSuspendTimeout() {
        return this.maxMessageSuspendTimeout;
    }

    @Override
    public int getWebComponentDisconnect() {
        return this.webComponentDisconnect;
    }

    @Override
    public boolean isCloseIdleSessions() {
        return this.closeIdleSessions;
    }

    @Override
    public boolean isSyncIdCheckEnabled() {
        return this.syncIdCheck;
    }

    @Override
    public boolean isSendUrlsAsParameters() {
        return this.sendUrlsAsParameters;
    }

    @Override
    public PushMode getPushMode() {
        return this.pushMode;
    }

    @Override
    public String getPushURL() {
        return this.pushURL;
    }

    private void checkProductionMode(boolean log) {
        this.productionMode = this.getBooleanProperty("productionMode", false);
        if (log) {
            if (this.productionMode) {
                this.info.add("Vaadin is running in production mode.");
            } else if (this.enableDevServer()) {
                this.info.add(NOT_PRODUCTION_MODE_INFO);
            } else {
                this.warnings.add(NOT_PRODUCTION_MODE_WARNING);
            }
        }
    }

    private void checkCompatibilityMode(boolean logWarning) {
        boolean explicitlySet = false;
        if (this.getStringProperty("bowerMode", null) != null) {
            this.compatibilityMode = this.getBooleanProperty("bowerMode", false);
            explicitlySet = true;
        } else if (this.getStringProperty("compatibilityMode", null) != null) {
            this.compatibilityMode = this.getBooleanProperty("compatibilityMode", false);
            explicitlySet = true;
        }
        Consumer consumer = (Consumer)this.getInitParameters().get(DeploymentConfigurationFactory.DEV_MODE_ENABLE_STRATEGY);
        if (consumer != null) {
            if (explicitlySet && !this.compatibilityMode) {
                consumer.accept(CompatibilityModeStatus.EXPLICITLY_SET_FALSE);
            } else if (!explicitlySet) {
                consumer.accept(CompatibilityModeStatus.UNDEFINED);
            }
        }
        if (this.compatibilityMode && logWarning) {
            this.warnings.add(WARNING_COMPATIBILITY_MODE);
        }
    }

    private void checkNewLicenseChecker(boolean logWarning) {
        boolean enableNewLicenseChecker;
        boolean bl = enableNewLicenseChecker = !this.getBooleanProperty("oldLicenseChecker", false);
        if (logWarning && !this.isProductionMode() && !this.isDevModeLiveReloadEnabled() && enableNewLicenseChecker) {
            this.warnings.add(WARNING_LIVERELOAD_DISABLED_AND_NEW_LICENSE_CHECKER);
        }
    }

    private void checkRequestTiming() {
        this.requestTiming = this.getBooleanProperty("requestTiming", !this.productionMode);
    }

    private void checkXsrfProtection(boolean logWarning) {
        boolean bl = this.xsrfProtectionEnabled = !this.getBooleanProperty("disable-xsrf-protection", false);
        if (!this.xsrfProtectionEnabled && logWarning) {
            this.warnings.add(WARNING_XSRF_PROTECTION_DISABLED);
        }
    }

    private void checkHeartbeatInterval() {
        try {
            this.heartbeatInterval = this.getApplicationOrSystemProperty("heartbeatInterval", 300, Integer::parseInt);
        }
        catch (NumberFormatException e) {
            this.warnings.add(WARNING_HEARTBEAT_INTERVAL_NOT_NUMERIC);
            this.heartbeatInterval = 300;
        }
    }

    private void checkMaxMessageSuspendTimeout() {
        try {
            this.maxMessageSuspendTimeout = this.getApplicationOrSystemProperty("maxMessageSuspendTimeout", 5000, Integer::parseInt);
        }
        catch (NumberFormatException e) {
            String warning = "WARNING: maxMessageSuspendInterval has been set to an illegal value.The default of 5000 ms will be used.";
            this.warnings.add(warning);
            this.maxMessageSuspendTimeout = 5000;
        }
    }

    private void checkWebComponentDisconnectTimeout() {
        try {
            this.webComponentDisconnect = this.getApplicationOrSystemProperty("webComponentDisconnect", 300, Integer::parseInt);
        }
        catch (NumberFormatException e) {
            this.warnings.add(WARNING_HEARTBEAT_INTERVAL_NOT_NUMERIC);
            this.webComponentDisconnect = 300;
        }
    }

    private void checkCloseIdleSessions() {
        this.closeIdleSessions = this.getBooleanProperty("closeIdleSessions", false);
    }

    private void checkPushMode() {
        try {
            this.pushMode = this.getApplicationOrSystemProperty("pushMode", PushMode.DISABLED, stringMode -> Enum.valueOf(PushMode.class, stringMode.toUpperCase()));
        }
        catch (IllegalArgumentException e) {
            this.warnings.add(WARNING_PUSH_MODE_NOT_RECOGNIZED);
            this.pushMode = PushMode.DISABLED;
        }
    }

    private void checkPushURL() {
        this.pushURL = this.getStringProperty("pushURL", "");
    }

    private void checkSyncIdCheck() {
        this.syncIdCheck = this.getBooleanProperty("syncIdCheck", true);
    }

    private void checkSendUrlsAsParameters() {
        this.sendUrlsAsParameters = this.getBooleanProperty("sendUrlsAsParameters", true);
    }
}

