/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.webcomponent;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.ExtendedClientDetails;
import com.vaadin.flow.component.webcomponent.WebComponentConfiguration;
import com.vaadin.flow.component.webcomponent.WebComponentWrapper;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.router.PreserveOnRefresh;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.webcomponent.WebComponentBinding;
import com.vaadin.flow.server.webcomponent.WebComponentConfigurationRegistry;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.Theme;
import com.vaadin.flow.theme.ThemeDefinition;
import com.vaadin.flow.theme.ThemeUtil;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.LoggerFactory;

public class WebComponentUI
extends UI {
    public static final String NO_NAVIGATION = "Navigation is not available for WebComponents";

    @Override
    public void doInit(VaadinRequest request, int uiId) {
        super.doInit(request, uiId);
        this.assignTheme();
        VaadinSession session = this.getSession();
        DeploymentConfiguration deploymentConfiguration = session.getService().getDeploymentConfiguration();
        this.getEventBus().addListener(WebComponentConnectEvent.class, this::connectWebComponent);
    }

    private void connectWebComponent(WebComponentConnectEvent event) {
        Optional<WebComponentConfiguration<? extends Component>> webComponentConfiguration = this.getConfigurationRegistry().getConfiguration(event.getTag());
        if (!webComponentConfiguration.isPresent()) {
            LoggerFactory.getLogger(WebComponentUI.class).warn("Received connect request for non existing WebComponent '{}'", (Object)event.getTag());
            return;
        }
        boolean shouldBePreserved = this.isConfigurationAnnotated(webComponentConfiguration.get(), PreserveOnRefresh.class);
        if (!shouldBePreserved) {
            this.attachCreatedWebComponent(webComponentConfiguration.get(), event);
        } else if (this.getInternals().getExtendedClientDetails() != null) {
            this.attachCachedOrCreatedWebComponent(webComponentConfiguration.get(), event, this.getComponentHash(event, this.getInternals().getExtendedClientDetails()));
        } else {
            this.getPage().retrieveExtendedClientDetails(extendedClientDetails -> this.attachCachedOrCreatedWebComponent((WebComponentConfiguration)webComponentConfiguration.get(), event, this.getComponentHash(event, extendedClientDetails)));
        }
    }

    private void attachCreatedWebComponent(WebComponentConfiguration<? extends Component> configuration, WebComponentConnectEvent event) {
        Element elementToAttach = this.createWebComponentWrapper(configuration, event);
        this.attachComponentToUI(elementToAttach, event.webComponentElementId);
    }

    private void attachCachedOrCreatedWebComponent(WebComponentConfiguration<? extends Component> configuration, WebComponentConnectEvent event, String hash) {
        Element elementToAttach = null;
        Optional<Element> old = this.getRegistry().get(hash);
        if (old.isPresent()) {
            elementToAttach = old.get().removeFromTree();
        }
        if (elementToAttach == null) {
            elementToAttach = this.createWebComponentWrapper(configuration, event);
        }
        this.attachComponentToUI(elementToAttach, event.webComponentElementId);
        this.getRegistry().put(hash, elementToAttach);
    }

    private Element createWebComponentWrapper(WebComponentConfiguration<? extends Component> configuration, WebComponentConnectEvent event) {
        Element rootElement = new Element(event.getTag());
        WebComponentBinding<? extends Component> binding = configuration.createWebComponentBinding(Instantiator.get(this), rootElement, event.getAttributeJson());
        WebComponentWrapper wrapper = new WebComponentWrapper(rootElement, binding, this.getConfigurationRegistry().getShadowDomElements());
        return wrapper.getElement();
    }

    private void attachComponentToUI(Element child, String elementId) {
        this.getElement().getStateProvider().appendVirtualChild(this.getElement().getNode(), child, "@id", elementId);
        child.executeJs("$0.serverConnected()", new Serializable[0]);
    }

    private boolean isConfigurationAnnotated(WebComponentConfiguration<? extends Component> configuration, Class<? extends Annotation> annotationClass) {
        return AnnotationReader.getAnnotationFor(configuration.getExporterClass(), annotationClass).isPresent();
    }

    private String getComponentHash(WebComponentConnectEvent event, ExtendedClientDetails details) {
        Objects.requireNonNull(event);
        Objects.requireNonNull(details);
        String id = event.getWebComponentUserAssignedId();
        if (id == null || id.isEmpty()) {
            id = event.getWebComponentElementId();
        }
        return String.format("%s:%s:%s", details.getWindowName(), event.getTag(), id);
    }

    private SessionEmbeddedComponentRegistry getRegistry() {
        return SessionEmbeddedComponentRegistry.getSessionRegistry(VaadinSession.getCurrent());
    }

    @Override
    @Deprecated
    public Router getRouter() {
        return null;
    }

    @Override
    public boolean isNavigationSupported() {
        return false;
    }

    @Override
    public Optional<ThemeDefinition> getThemeFor(Class<?> navigationTarget, String path) {
        return Optional.empty();
    }

    @Override
    public void navigate(String location) {
        throw new UnsupportedOperationException(NO_NAVIGATION);
    }

    @Override
    public void navigate(Class<? extends Component> navigationTarget) {
        throw new UnsupportedOperationException(NO_NAVIGATION);
    }

    @Override
    public <T, C extends Component> void navigate(Class<? extends C> navigationTarget, T parameter) {
        throw new UnsupportedOperationException(NO_NAVIGATION);
    }

    @Override
    public void navigate(String location, QueryParameters queryParameters) {
        throw new UnsupportedOperationException(NO_NAVIGATION);
    }

    private void assignTheme() {
        WebComponentConfigurationRegistry registry = this.getConfigurationRegistry();
        Optional<Theme> theme = registry.getEmbeddedApplicationAnnotation(Theme.class);
        if (theme.isPresent() && !theme.get().value().equals(AbstractTheme.class)) {
            this.getInternals().setTheme(theme.get().value());
            this.assignVariant(registry, theme.get());
        } else {
            ThemeUtil.getLumoThemeDefinition().map(ThemeDefinition::getTheme).ifPresent(this.getInternals()::setTheme);
        }
    }

    private void assignVariant(WebComponentConfigurationRegistry registry, Theme theme) {
        AbstractTheme themeInstance = Instantiator.get(this).getOrCreate(theme.value());
        ThemeDefinition definition = new ThemeDefinition(theme);
        Map<String, String> attributes = themeInstance.getHtmlAttributes(definition.getVariant());
        registry.getConfigurations().forEach(config -> this.addAttributes(config.getTag(), attributes));
    }

    private void addAttributes(String tag, Map<String, String> attributes) {
        StringBuilder builder = new StringBuilder();
        builder.append("var elements = document.querySelectorAll('").append(tag).append("');").append("for (let i = 0; i < elements.length; i++) {");
        attributes.forEach((attribute, value) -> builder.append("elements[i].setAttribute('").append((String)attribute).append("', '").append((String)value).append("');"));
        builder.append("}");
        this.getPage().executeJs(builder.toString(), new Serializable[0]);
    }

    private String getWebComponentHtmlPath(WebComponentConfiguration<? extends Component> config) {
        DeploymentConfiguration deploymentConfiguration = this.getSession().getService().getDeploymentConfiguration();
        String path = deploymentConfiguration.getCompiledWebComponentsPath();
        return path + '/' + config.getTag() + ".html";
    }

    private WebComponentConfigurationRegistry getConfigurationRegistry() {
        return WebComponentConfigurationRegistry.getInstance(this.getSession().getService().getContext());
    }

    private static class SessionEmbeddedComponentRegistry
    implements Serializable {
        private final VaadinSession session;
        private ConcurrentHashMap<String, Element> cache = new ConcurrentHashMap();

        SessionEmbeddedComponentRegistry(VaadinSession session) {
            this.session = session;
        }

        static SessionEmbeddedComponentRegistry getSessionRegistry(VaadinSession session) {
            Objects.requireNonNull(session, "Null session is not supported for session route registry");
            SessionEmbeddedComponentRegistry registry = session.getAttribute(SessionEmbeddedComponentRegistry.class);
            if (registry == null) {
                registry = new SessionEmbeddedComponentRegistry(session);
                session.setAttribute(SessionEmbeddedComponentRegistry.class, registry);
            }
            if (!registry.session.equals(session)) {
                throw new IllegalStateException(String.format("Session has an attribute for %s registered for another session!", SessionEmbeddedComponentRegistry.class.getSimpleName()));
            }
            return registry;
        }

        void put(String identifier, Element element) {
            Objects.requireNonNull(identifier);
            Objects.requireNonNull(element);
            this.cache.computeIfAbsent(identifier, id -> element);
        }

        Optional<Element> get(String identifier) {
            Objects.requireNonNull(identifier);
            return Optional.ofNullable(this.cache.get(identifier));
        }
    }

    @DomEvent(value="connect-web-component")
    public static class WebComponentConnectEvent
    extends ComponentEvent<UI> {
        private String tag;
        private String userAssignedId;
        private String webComponentElementId;
        private JsonObject attributeValues;

        public WebComponentConnectEvent(UI source, boolean fromClient, @EventData(value="tag") String tag, @EventData(value="id") String webComponentElementId, @EventData(value="userAssignedId") String userAssignedId, @EventData(value="attributeValues") JsonObject attributeValues) {
            super(source, true);
            this.tag = tag;
            this.userAssignedId = userAssignedId;
            this.webComponentElementId = webComponentElementId;
            this.attributeValues = attributeValues;
        }

        public String getTag() {
            return this.tag;
        }

        public String getWebComponentElementId() {
            return this.webComponentElementId;
        }

        public String getWebComponentUserAssignedId() {
            return this.userAssignedId;
        }

        public JsonObject getAttributeJson() {
            return this.attributeValues;
        }
    }
}

