/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.template.internal;

import com.vaadin.flow.component.template.internal.AttributeInitializationStrategy;
import com.vaadin.flow.component.template.internal.ElementInitializationStrategy;
import com.vaadin.flow.component.template.internal.PropertyInitializationStrategy;
import com.vaadin.flow.component.template.internal.TextInitializationStrategy;
import com.vaadin.flow.dom.Element;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;

public abstract class AbstractInjectableElementInitializer
implements Consumer<Map<String, String>> {
    public static final String TEXT_DATA = "=text";
    private final Element element;
    private static final Map<String, ElementInitializationStrategy> INIT_STRATEGIES = AbstractInjectableElementInitializer.createStrategies();
    private static final IdentityHashMap<Pattern, ElementInitializationStrategy> PATTERN_STRATEGIES = AbstractInjectableElementInitializer.createPatternStrategies();
    private static final ElementInitializationStrategy DEFAULT_STRATEGY = new PropertyInitializationStrategy();

    protected AbstractInjectableElementInitializer(Element element) {
        this.element = element;
    }

    @Override
    public void accept(Map<String, String> templateAttributes) {
        templateAttributes.forEach(this::initialize);
    }

    protected abstract boolean isStaticAttribute(String var1, String var2);

    protected Element getElement() {
        return this.element;
    }

    private void initialize(String name, String value) {
        if (this.isStaticAttribute(name, value)) {
            this.getStrategy(name).initialize(this.element, name, value);
        }
    }

    private ElementInitializationStrategy getStrategy(String attributeName) {
        ElementInitializationStrategy strategy = INIT_STRATEGIES.get(attributeName);
        if (strategy == null) {
            for (Map.Entry<Pattern, ElementInitializationStrategy> entry : PATTERN_STRATEGIES.entrySet()) {
                if (!entry.getKey().matcher(attributeName).matches()) continue;
                strategy = entry.getValue();
                break;
            }
        }
        if (strategy == null) {
            strategy = DEFAULT_STRATEGY;
        }
        return strategy;
    }

    private static IdentityHashMap<Pattern, ElementInitializationStrategy> createPatternStrategies() {
        AttributeInitializationStrategy attributeStrategy = new AttributeInitializationStrategy();
        IdentityHashMap<Pattern, ElementInitializationStrategy> map = new IdentityHashMap<Pattern, ElementInitializationStrategy>(1);
        map.put(Pattern.compile("data-.*"), attributeStrategy);
        return map;
    }

    private static Map<String, ElementInitializationStrategy> createStrategies() {
        HashMap<String, ElementInitializationStrategy> result = new HashMap<String, ElementInitializationStrategy>();
        AttributeInitializationStrategy attributeStrategy = new AttributeInitializationStrategy();
        result.put("id", attributeStrategy);
        result.put("class", attributeStrategy);
        result.put("style", attributeStrategy);
        result.put("href", attributeStrategy);
        result.put("theme", attributeStrategy);
        result.put("title", attributeStrategy);
        result.put("hidden", attributeStrategy);
        result.put("accesskey", attributeStrategy);
        result.put("contenteditable", attributeStrategy);
        result.put("dir", attributeStrategy);
        result.put("draggable", attributeStrategy);
        result.put("lang", attributeStrategy);
        result.put("spellcheck", attributeStrategy);
        result.put("tabindex", attributeStrategy);
        result.put("translate", attributeStrategy);
        result.put(TEXT_DATA, new TextInitializationStrategy());
        return result;
    }
}

