/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.shared.util.SharedUtil;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class TaskRunNpmInstall
implements FallibleCommand {
    private static final String MODULES_YAML = ".modules.yaml";
    private static final String INSTALL_HASH = ".vaadin/vaadin.json";
    private static final String NPM_VALIDATION_FAIL_MESSAGE = "%n%n======================================================================================================%nThe path to npm cache contains whitespaces, and the currently installed npm version doesn't accept this.%nMost likely your Windows user home path contains whitespaces.%nTo workaround it, please change the npm cache path by using the following command:%n    npm config set cache [path-to-npm-cache] --global%n(you may also want to exclude the whitespaces with 'dir /x' to use the same dir),%nor upgrade the npm version to 7 (or newer) by:%n 1) Running 'npm-windows-upgrade' tool with Windows PowerShell:%n        Set-ExecutionPolicy Unrestricted -Scope CurrentUser -Force%n        npm install -g npm-windows-upgrade%n        npm-windows-upgrade%n 2) Manually installing a newer version of npx: npm install -g npx%n 3) Manually installing a newer version of pnpm: npm install -g pnpm%n 4) Deleting the following files from your Vaadin project's folder (if present):%n        node_modules, package-lock.json, webpack.generated.js, pnpm-lock.yaml, pnpmfile.js%n======================================================================================================%n";
    public static final String INSTALLING = "installing";
    private final NodeUpdater packageUpdater;
    private final List<String> ignoredNodeFolders = Arrays.asList(".bin", "pnpm", ".ignored_pnpm", ".pnpm", ".staging", ".vaadin", ".modules.yaml");
    private final boolean enablePnpm;
    private final boolean requireHomeNodeExec;
    private final ClassFinder classFinder;
    private final String nodeVersion;
    private final URI nodeDownloadRoot;
    private boolean ciBuild;

    TaskRunNpmInstall(ClassFinder classFinder, NodeUpdater packageUpdater, boolean enablePnpm, boolean requireHomeNodeExec, String nodeVersion, URI nodeDownloadRoot, boolean ciBuild) {
        this.classFinder = classFinder;
        this.packageUpdater = packageUpdater;
        this.enablePnpm = enablePnpm;
        this.requireHomeNodeExec = requireHomeNodeExec;
        this.nodeVersion = Objects.requireNonNull(nodeVersion);
        this.nodeDownloadRoot = Objects.requireNonNull(nodeDownloadRoot);
        this.ciBuild = ciBuild;
    }

    @Override
    public void execute() throws ExecutionFailedException {
        String toolName = this.enablePnpm ? "pnpm" : "npm";
        String command = this.getInstallCommand();
        if (this.ciBuild || this.packageUpdater.modified || this.shouldRunNpmInstall()) {
            this.packageUpdater.log().info("Running `{} {}` to resolve and optionally download frontend dependencies. This may take a moment, please stand by...", (Object)toolName, (Object)command);
            this.updateLocalHashForInstall();
            this.runNpmInstall();
            this.updateLocalHash();
        } else {
            this.packageUpdater.log().info("Skipping `{} {}` because the frontend packages are already installed in the folder '{}' and the hash in the file '{}' is the same as in '{}'", new Object[]{toolName, command, this.packageUpdater.nodeModulesFolder.getAbsolutePath(), this.getLocalHashFile().getAbsolutePath(), "package.json"});
        }
    }

    private void updateLocalHash() {
        try {
            JsonObject vaadin = this.packageUpdater.getPackageJson().getObject("vaadin");
            if (vaadin == null) {
                this.packageUpdater.log().warn("No vaadin object in package.json");
                return;
            }
            String hash = vaadin.getString("hash");
            JsonObject localHash = Json.createObject();
            localHash.put("hash", hash);
            File localHashFile = this.getLocalHashFile();
            FileUtils.forceMkdirParent((File)localHashFile);
            String content = JsonUtil.stringify((JsonValue)localHash, (int)2) + "\n";
            FileUtils.writeStringToFile((File)localHashFile, (String)content, (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            this.packageUpdater.log().warn("Failed to update node_modules hash.", (Throwable)e);
        }
    }

    private void updateLocalHashForInstall() {
        try {
            JsonObject localHash = Json.createObject();
            localHash.put("hash", INSTALLING);
            File localHashFile = this.getLocalHashFile();
            FileUtils.forceMkdirParent((File)localHashFile);
            String content = JsonUtil.stringify((JsonValue)localHash, (int)2) + "\n";
            FileUtils.writeStringToFile((File)localHashFile, (String)content, (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            this.packageUpdater.log().warn("Failed to update node_modules hash.", (Throwable)e);
        }
    }

    private File getLocalHashFile() {
        return new File(this.packageUpdater.nodeModulesFolder, INSTALL_HASH);
    }

    protected String generateVersionsJson() throws IOException {
        assert (this.enablePnpm);
        File versions = new File(this.packageUpdater.generatedFolder, "versions.json");
        JsonObject versionsJson = this.getLockedVersions();
        JsonObject packageJsonVersions = this.generateVersionsFromPackageJson();
        if (versionsJson == null) {
            versionsJson = packageJsonVersions;
        } else {
            for (String key : packageJsonVersions.keys()) {
                if (versionsJson.hasKey(key)) continue;
                versionsJson.put(key, packageJsonVersions.getString(key));
            }
        }
        FileUtils.write((File)versions, (CharSequence)(JsonUtil.stringify((JsonValue)versionsJson, (int)2) + "\n"), (Charset)StandardCharsets.UTF_8);
        Path versionsPath = versions.toPath();
        if (versions.isAbsolute()) {
            return FrontendUtils.getUnixRelativePath(this.packageUpdater.npmFolder.toPath(), versionsPath);
        }
        return FrontendUtils.getUnixPath(versionsPath);
    }

    private JsonObject generateVersionsFromPackageJson() throws IOException {
        JsonObject versionsJson = Json.createObject();
        JsonObject packageJson = this.packageUpdater.getPackageJson();
        JsonObject dependencies = packageJson.getObject("dependencies");
        JsonObject devDependencies = packageJson.getObject("devDependencies");
        if (dependencies != null) {
            for (String key : dependencies.keys()) {
                versionsJson.put(key, dependencies.getString(key));
            }
        }
        if (devDependencies != null) {
            for (String key : devDependencies.keys()) {
                versionsJson.put(key, devDependencies.getString(key));
            }
        }
        return versionsJson;
    }

    private JsonObject getLockedVersions() throws IOException {
        assert (this.enablePnpm);
        JsonObject versionsJson = this.packageUpdater.getPlatformPinnedDependencies();
        return versionsJson;
    }

    private boolean shouldRunNpmInstall() {
        if (!this.packageUpdater.nodeModulesFolder.isDirectory()) {
            return true;
        }
        File[] installedPackages = this.packageUpdater.nodeModulesFolder.listFiles((dir, name) -> !this.ignoredNodeFolders.contains(name));
        assert (installedPackages != null);
        if (installedPackages.length == 0) {
            return true;
        }
        if (installedPackages.length == 1 && "@vaadin/flow-frontend/".startsWith(installedPackages[0].getName())) {
            return true;
        }
        return !this.isVaadinHashUpdated();
    }

    private boolean isVaadinHashUpdated() {
        File localHashFile = this.getLocalHashFile();
        if (localHashFile.exists()) {
            try {
                String fileContent = FileUtils.readFileToString((File)localHashFile, (String)StandardCharsets.UTF_8.name());
                JsonObject content = Json.parse((String)fileContent);
                if (content.hasKey("hash")) {
                    JsonObject packageJson = this.packageUpdater.getPackageJson();
                    if (content.get("hash").asString().equals(INSTALLING)) {
                        return true;
                    }
                    return content.getString("hash").equals(packageJson.getObject("vaadin").getString("hash"));
                }
            }
            catch (IOException e) {
                this.packageUpdater.log().warn("Failed to load hashes forcing npm execution", (Throwable)e);
            }
        }
        return false;
    }

    private void runNpmInstall() throws ExecutionFailedException {
        List<String> executable;
        this.cleanUp();
        if (this.enablePnpm) {
            try {
                this.createPnpmFile(this.generateVersionsJson());
            }
            catch (IOException exception) {
                throw new ExecutionFailedException("Failed to read frontend version data from vaadin-core and make it available to pnpm for locking transitive dependencies.\nPlease report an issue, as a workaround try running project with npm by setting system variable -Dvaadin.pnpm.enable=false", exception);
            }
        }
        String baseDir = this.packageUpdater.npmFolder.getAbsolutePath();
        FrontendTools tools = new FrontendTools(baseDir, () -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath(), this.nodeVersion, this.nodeDownloadRoot, this.requireHomeNodeExec);
        try {
            if (this.requireHomeNodeExec) {
                tools.forceAlternativeNodeExecutable();
            }
            if (this.enablePnpm) {
                this.validateInstalledNpm(tools);
                executable = tools.getPnpmExecutable();
            } else {
                executable = tools.getNpmExecutable();
            }
        }
        catch (IllegalStateException exception) {
            throw new ExecutionFailedException(exception.getMessage(), exception);
        }
        ArrayList<String> command = new ArrayList<String>(executable);
        if (this.ciBuild) {
            if (this.enablePnpm) {
                command.add("install");
                command.add("--frozen-lockfile");
            } else {
                command.add("ci");
            }
        } else {
            command.add("install");
        }
        if (this.packageUpdater.log().isDebugEnabled()) {
            this.packageUpdater.log().debug(FrontendUtils.commandToString(this.packageUpdater.npmFolder.getAbsolutePath(), command));
        }
        ProcessBuilder builder = FrontendUtils.createProcessBuilder(command);
        builder.environment().put("ADBLOCK", "1");
        builder.environment().put("NO_UPDATE_NOTIFIER", "1");
        builder.directory(this.packageUpdater.npmFolder);
        builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        builder.redirectError(ProcessBuilder.Redirect.INHERIT);
        String toolName = this.enablePnpm ? "pnpm" : "npm";
        String commandString = command.stream().collect(Collectors.joining(" "));
        Process process = null;
        try {
            Process finalProcess = process = builder.start();
            Runtime.getRuntime().addShutdownHook(new Thread(finalProcess::destroyForcibly));
            this.packageUpdater.log().debug("Output of `{}`:", (Object)commandString);
            StringBuilder toolOutput = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String stdoutLine;
                while ((stdoutLine = reader.readLine()) != null) {
                    this.packageUpdater.log().debug(stdoutLine);
                    toolOutput.append(stdoutLine).append(System.lineSeparator());
                }
            }
            int errorCode = process.waitFor();
            if (errorCode != 0) {
                this.packageUpdater.log().error("Command `{}` failed:\n{}", (Object)commandString, (Object)toolOutput);
                this.packageUpdater.log().error(">>> Dependency ERROR. Check that all required dependencies are deployed in {} repositories.", (Object)toolName);
                throw new ExecutionFailedException(SharedUtil.capitalize(toolName) + " install has exited with non zero status. Some dependencies are not installed. Check " + toolName + " command output");
            }
            this.packageUpdater.log().info("Frontend dependencies resolved successfully.");
        }
        catch (IOException | InterruptedException e) {
            this.packageUpdater.log().error("Error when running `{} install`", (Object)toolName, (Object)e);
            throw new ExecutionFailedException("Command '" + toolName + " install' failed to finish", e);
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
        }
    }

    private void createPnpmFile(String versionsPath) throws IOException {
        if (versionsPath == null) {
            return;
        }
        File pnpmFile = new File(this.packageUpdater.npmFolder.getAbsolutePath(), "pnpmfile.js");
        try (InputStream content = TaskRunNpmInstall.class.getResourceAsStream("/pnpmfile.js");){
            if (content == null) {
                throw new IOException("Couldn't find template pnpmfile.js in the classpath");
            }
            FileUtils.copyInputStreamToFile((InputStream)content, (File)pnpmFile);
            this.packageUpdater.log().debug("Generated pnpmfile hook file: '{}'", (Object)pnpmFile);
            FileUtils.writeLines((File)pnpmFile, this.modifyPnpmFile(pnpmFile, versionsPath));
        }
    }

    private List<String> modifyPnpmFile(File generatedFile, String versionsPath) throws IOException {
        List lines = FileUtils.readLines((File)generatedFile, (Charset)StandardCharsets.UTF_8);
        int i = 0;
        for (String line : lines) {
            if (line.startsWith("const versionsFile")) {
                lines.set(i, "const versionsFile = require('path').resolve(__dirname, '" + versionsPath + "');");
            }
            ++i;
        }
        return lines;
    }

    private void cleanUp() throws ExecutionFailedException {
        if (!this.packageUpdater.nodeModulesFolder.exists()) {
            return;
        }
        if (this.ciBuild) {
            this.deleteNodeModules(this.packageUpdater.nodeModulesFolder);
        } else {
            File staging;
            boolean hasModulesYaml;
            File modulesYaml = new File(this.packageUpdater.nodeModulesFolder, MODULES_YAML);
            boolean bl = hasModulesYaml = modulesYaml.exists() && modulesYaml.isFile();
            if (!this.enablePnpm && hasModulesYaml) {
                this.deleteNodeModules(this.packageUpdater.nodeModulesFolder);
            } else if (!(!this.enablePnpm || hasModulesYaml || (staging = new File(this.packageUpdater.nodeModulesFolder, ".staging")).isDirectory() && staging.listFiles((dir, name) -> name.startsWith("pnpm-")).length != 0)) {
                this.deleteNodeModules(this.packageUpdater.nodeModulesFolder);
            }
        }
    }

    private void deleteNodeModules(File nodeModulesFolder) throws ExecutionFailedException {
        try {
            FrontendUtils.deleteNodeModules(nodeModulesFolder);
        }
        catch (IOException exception) {
            Logger log = this.packageUpdater.log();
            log.debug("Exception removing node_modules", (Throwable)exception);
            log.error("Failed to remove '" + this.packageUpdater.nodeModulesFolder.getAbsolutePath() + "'. Please remove it manually.");
            throw new ExecutionFailedException("Exception removing node_modules. Please remove it manually.");
        }
    }

    private void validateInstalledNpm(FrontendTools tools) throws IllegalStateException {
        File npmCacheDir = null;
        try {
            npmCacheDir = tools.getNpmCacheDir();
        }
        catch (FrontendUtils.CommandExecutionException | IllegalStateException e) {
            this.packageUpdater.log().warn("Failed to get npm cache directory", (Throwable)e);
        }
        if (npmCacheDir != null && !tools.folderIsAcceptableByNpm(npmCacheDir)) {
            throw new IllegalStateException(String.format(NPM_VALIDATION_FAIL_MESSAGE, new Object[0]));
        }
    }

    private String getInstallCommand() {
        String command = "install";
        if (this.ciBuild) {
            command = this.enablePnpm ? command + "--frozen-lockfile " : "ci";
        }
        return command;
    }
}

