/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class UrlUtil {
    private UrlUtil() {
    }

    public static boolean isExternal(String url) {
        if (url.startsWith("//")) {
            return true;
        }
        return url.contains("://") && !url.startsWith("frontend://");
    }

    public static String encodeURI(String uri) {
        try {
            return URLEncoder.encode(uri, StandardCharsets.UTF_8.name()).replace("+", "%20").replace("%2F", "/").replace("%40", "@").replace("%3B", ";").replace("%2C", ",").replace("%3F", "?").replace("%3A", ":").replace("%26", "&").replace("%3D", "=").replace("%2B", "+").replace("%24", "$").replace("%21", "!").replace("%7E", "~").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%23", "#");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Encoding the URI failed", e);
        }
    }

    public static String encodeURIComponent(String path) {
        try {
            return URLEncoder.encode(path, StandardCharsets.UTF_8.name()).replace("+", "%20").replace("%21", "!").replace("%7E", "~").replace("%27", "'").replace("%28", "(").replace("%29", ")");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Encoding the URI failed", e);
        }
    }
}

