/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.OptionalParameter;
import com.vaadin.flow.router.ParameterDeserializer;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.WildcardParameter;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RouteTarget
implements Serializable {
    private Class<? extends Component> normal;
    private Class<? extends Component> parameter;
    private Class<? extends Component> optionalParameter;
    private Class<? extends Component> wildCardParameter;
    private final boolean mutable;
    private final Map<Class<? extends Component>, List<Class<? extends RouterLayout>>> parentLayouts = new HashMap<Class<? extends Component>, List<Class<? extends RouterLayout>>>(0);

    private RouteTarget(boolean mutable) {
        this.mutable = mutable;
    }

    public RouteTarget(Class<? extends Component> target) {
        this(target, true);
    }

    public RouteTarget(Class<? extends Component> target, boolean mutable) {
        this.mutable = mutable;
        this.addTargetByType(target);
    }

    public void addRoute(Class<? extends Component> target) {
        this.throwIfImmutable();
        this.addTargetByType(target);
    }

    private void addTargetByType(Class<? extends Component> target) {
        if (!HasUrlParameter.class.isAssignableFrom(target) && !this.isAnnotatedParameter(target)) {
            this.validateNormalTarget(target);
            this.normal = target;
        } else if (ParameterDeserializer.isAnnotatedParameter(target, OptionalParameter.class)) {
            this.validateOptionalParameter(target);
            this.optionalParameter = target;
        } else if (ParameterDeserializer.isAnnotatedParameter(target, WildcardParameter.class)) {
            this.validateWildcard(target);
            this.wildCardParameter = target;
        } else {
            this.validateParameter(target);
            this.parameter = target;
        }
    }

    private void validateParameter(Class<? extends Component> target) throws InvalidRouteConfigurationException {
        if (this.parameter != null) {
            throw new InvalidRouteConfigurationException(String.format("Navigation targets must have unique routes, found navigation targets '%s' and '%s' with parameter have the same route.", this.parameter.getName(), target.getName()));
        }
    }

    private void validateWildcard(Class<? extends Component> target) throws InvalidRouteConfigurationException {
        if (this.wildCardParameter != null) {
            throw new InvalidRouteConfigurationException(String.format("Navigation targets must have unique routes, found navigation targets '%s' and '%s' with wildcard parameter have the same route.", this.wildCardParameter.getName(), target.getName()));
        }
    }

    private void validateOptionalParameter(Class<? extends Component> target) throws InvalidRouteConfigurationException {
        if (this.normal != null) {
            throw new InvalidRouteConfigurationException(String.format("Navigation targets '%s' and '%s' have the same path and '%s' has an OptionalParameter that will never be used as optional.", this.normal.getName(), target.getName(), target.getName()));
        }
        if (this.optionalParameter != null) {
            String message = String.format("Navigation targets must have unique routes, found navigation targets '%s' and '%s' with parameter have the same route.", this.optionalParameter.getName(), target.getName());
            throw new InvalidRouteConfigurationException(message);
        }
    }

    private void validateNormalTarget(Class<? extends Component> target) throws InvalidRouteConfigurationException {
        if (this.normal != null) {
            throw new InvalidRouteConfigurationException(String.format("Navigation targets must have unique routes, found navigation targets '%s' and '%s' with the same route.", this.normal.getName(), target.getName()));
        }
        if (this.optionalParameter != null) {
            throw new InvalidRouteConfigurationException(String.format("Navigation targets '%s' and '%s' have the same path and '%s' has an OptionalParameter that will never be used as optional.", target.getName(), this.optionalParameter.getName(), this.optionalParameter.getName()));
        }
    }

    public Class<? extends Component> getTarget(List<String> segments) {
        if (segments.isEmpty() && this.normal != null) {
            return this.normal;
        }
        if (segments.size() == 1 && this.parameter != null) {
            return this.parameter;
        }
        if (segments.size() <= 1 && this.optionalParameter != null) {
            return this.optionalParameter;
        }
        if (this.wildCardParameter != null) {
            return this.wildCardParameter;
        }
        return null;
    }

    private boolean isAnnotatedParameter(Class<?> target) {
        return ParameterDeserializer.isAnnotatedParameter(target, OptionalParameter.class) || ParameterDeserializer.isAnnotatedParameter(target, WildcardParameter.class);
    }

    public RouteTarget copy(boolean mutable) {
        RouteTarget copy = new RouteTarget(mutable);
        copy.normal = this.normal;
        copy.parameter = this.parameter;
        copy.optionalParameter = this.optionalParameter;
        copy.wildCardParameter = this.wildCardParameter;
        this.parentLayouts.keySet().forEach(key -> copy.parentLayouts.put((Class<? extends Component>)key, this.parentLayouts.get(key)));
        return copy;
    }

    public void remove(Class<? extends Component> targetRoute) {
        this.throwIfImmutable();
        if (targetRoute.equals(this.normal)) {
            this.normal = null;
        } else if (targetRoute.equals(this.parameter)) {
            this.parameter = null;
        } else if (targetRoute.equals(this.optionalParameter)) {
            this.optionalParameter = null;
        } else if (targetRoute.equals(this.wildCardParameter)) {
            this.wildCardParameter = null;
        }
        this.parentLayouts.remove(targetRoute);
    }

    public boolean containsTarget(Class<? extends Component> target) {
        return this.getRoutes().contains(target);
    }

    public boolean isEmpty() {
        return this.normal == null && this.parameter == null && this.optionalParameter == null && this.wildCardParameter == null;
    }

    public List<Class<? extends Component>> getRoutes() {
        ArrayList<Class<? extends Component>> registrations = new ArrayList<Class<? extends Component>>(4);
        if (this.normal != null) {
            registrations.add(this.normal);
        }
        if (this.parameter != null) {
            registrations.add(this.parameter);
        }
        if (this.optionalParameter != null) {
            registrations.add(this.optionalParameter);
        }
        if (this.wildCardParameter != null) {
            registrations.add(this.wildCardParameter);
        }
        return registrations;
    }

    public void setParentLayouts(Class<? extends Component> target, List<Class<? extends RouterLayout>> parents) {
        this.throwIfImmutable();
        if (!this.containsTarget(target)) {
            throw new IllegalArgumentException("Tried to add parent layouts for a non existing target " + target.getName());
        }
        this.parentLayouts.put(target, Collections.unmodifiableList(new ArrayList<Class<? extends RouterLayout>>(parents)));
    }

    public List<Class<? extends RouterLayout>> getParentLayouts(Class<? extends Component> target) {
        if (!this.parentLayouts.containsKey(target)) {
            return Collections.emptyList();
        }
        return this.parentLayouts.get(target);
    }

    private void throwIfImmutable() {
        if (!this.mutable) {
            throw new IllegalStateException("Tried to mutate immutable configuration.");
        }
    }
}

