/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.polymer2lit;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.StringSubstitutor;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaInterfaceSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MemberSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.source.ParameterSource;

public class ServerConverter {
    public boolean convertFile(Path filePath) throws IOException {
        String source = this.readFile(filePath);
        if (!source.contains("PolymerTemplate")) {
            return false;
        }
        String out = this.transform(source);
        if (source.equals(out)) {
            return false;
        }
        try (FileWriter fw = new FileWriter(filePath.toFile());){
            fw.write(out);
        }
        return true;
    }

    private String transform(String source) throws IOException {
        String modelType;
        JavaClassSource javaClass = (JavaClassSource)Roaster.parse(JavaClassSource.class, (String)source);
        String superType = javaClass.getSuperType();
        if (!superType.startsWith("PolymerTemplate") && !superType.startsWith("com.vaadin.flow.component.polymertemplate.PolymerTemplate")) {
            return source;
        }
        if (superType.contains("<") && !(modelType = superType.substring(superType.indexOf("<") + 1, superType.indexOf(">"))).equals("TemplateModel")) {
            this.transformModel(modelType, javaClass);
        }
        javaClass.setSuperType("com.vaadin.flow.component.littemplate.LitTemplate");
        javaClass.removeImport("com.vaadin.flow.component.polymertemplate.Id");
        javaClass.removeImport("com.vaadin.flow.templatemodel.TemplateModel");
        javaClass.removeImport("com.vaadin.flow.component.polymertemplate.PolymerTemplate");
        javaClass.addImport("com.vaadin.flow.component.template.Id");
        String result = javaClass.toUnformattedString();
        return result;
    }

    private void transformModel(String modelType, JavaClassSource javaClass) {
        if (modelType.startsWith(javaClass.getName() + ".")) {
            String internalName = modelType.substring(javaClass.getName().length() + 1);
            JavaSource nested = javaClass.getNestedType(internalName);
            JavaInterfaceSource model = (JavaInterfaceSource)nested;
            model.removeInterface("TemplateModel");
            LinkedHashSet<String> getters = new LinkedHashSet<String>();
            LinkedHashSet<String> setters = new LinkedHashSet<String>();
            LinkedHashMap<String, Type> types = new LinkedHashMap<String, Type>();
            for (MemberSource member : model.getMembers()) {
                Type type;
                MethodSource method = (MethodSource)member;
                String name = member.getName();
                String property = this.getProperty(name);
                if (this.isSetter(name)) {
                    type = ((ParameterSource)method.getParameters().get(0)).getType();
                    types.put(property, type);
                    setters.add(property);
                    continue;
                }
                type = method.getReturnType();
                types.put(property, type);
                getters.add(property);
            }
            MethodSource getModelMethod = javaClass.addMethod("private " + internalName + " getModel() {}");
            StringBuilder body = new StringBuilder();
            body.append("return new ").append(internalName).append("() {");
            for (String property : types.keySet()) {
                StringSubstitutor sub;
                Type type = (Type)types.get(property);
                HashMap<String, Object> replacements = new HashMap<String, Object>();
                replacements.put("property", property);
                replacements.put("type", type.getName());
                String defaultValue = this.getDefaultValue(type);
                replacements.put("defaultValue", defaultValue);
                if (setters.contains(property)) {
                    replacements.put("methodName", "set" + this.capitalize(property));
                    sub = new StringSubstitutor(replacements);
                    body.append(sub.replace("@Override\n"));
                    body.append(sub.replace("public void ${methodName}(${type} ${property}) {\n"));
                    if (defaultValue == null) {
                        body.append("/* FIXME Implement this method which could not be automatically generated*/\n");
                    } else {
                        body.append(sub.replace("getElement().setProperty(\"${property}\", ${property});\n"));
                    }
                    body.append(sub.replace("}\n"));
                }
                if (!getters.contains(property)) continue;
                if (type.getName().equals("boolean")) {
                    replacements.put("methodName", "is" + this.capitalize(property));
                } else {
                    replacements.put("methodName", "get" + this.capitalize(property));
                }
                sub = new StringSubstitutor(replacements);
                body.append(sub.replace("@Override\n"));
                body.append(sub.replace("public ${type} ${methodName}() {\n"));
                if (defaultValue == null) {
                    body.append("/* FIXME Implement this method which could not be automatically generated*/\n");
                } else {
                    body.append(sub.replace("return getElement().getProperty(\"${property}\", ${defaultValue});\n"));
                }
                body.append(sub.replace("}\n"));
            }
            body.append("};");
            getModelMethod.setBody(body.toString());
        } else {
            System.err.println("Warning: Do not know how to handle external models. Only models which are internal interfaces: " + modelType);
        }
    }

    private String getDefaultValue(Type<?> type) {
        if (type.getName().equalsIgnoreCase("boolean")) {
            return "false";
        }
        if (type.getQualifiedName().equals(String.class.getName())) {
            return "null";
        }
        return null;
    }

    private String capitalize(String property) {
        return property.substring(0, 1).toUpperCase(Locale.ENGLISH) + property.substring(1);
    }

    private boolean isSetter(String methodName) {
        return methodName.startsWith("set");
    }

    private String getProperty(String methodName) {
        String name = methodName.replaceFirst("^(set|is|get)", "");
        return name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
    }

    private String readFile(Path filePath) throws IOException {
        try (FileInputStream stream = new FileInputStream(filePath.toFile());){
            String string = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }
}

