/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.scanner;

import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;

public class ReflectionsClassFinder
implements ClassFinder {
    private final transient ClassLoader classLoader;
    private final transient Reflections reflections;

    public ReflectionsClassFinder(URL ... urls) {
        this.classLoader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().addClassLoaders(new ClassLoader[]{this.classLoader}).setExpandSuperTypes(false).addUrls(urls);
        configurationBuilder.setInputsFilter(resourceName -> resourceName.endsWith(".class") && !resourceName.endsWith("module-info.class"));
        this.reflections = new Reflections((Configuration)configurationBuilder);
    }

    public Set<Class<?>> getAnnotatedClasses(Class<? extends Annotation> clazz) {
        LinkedHashSet classes = new LinkedHashSet();
        classes.addAll(this.reflections.getTypesAnnotatedWith(clazz, true));
        classes.addAll(this.getAnnotatedByRepeatedAnnotation(clazz));
        return this.sortedByClassName(classes);
    }

    private Set<Class<?>> getAnnotatedByRepeatedAnnotation(AnnotatedElement annotationClass) {
        Repeatable repeatableAnnotation = annotationClass.getAnnotation(Repeatable.class);
        if (repeatableAnnotation != null) {
            return this.reflections.getTypesAnnotatedWith(repeatableAnnotation.value(), true);
        }
        return Collections.emptySet();
    }

    public URL getResource(String name) {
        return this.classLoader.getResource(name);
    }

    public <T> Class<T> loadClass(String name) throws ClassNotFoundException {
        return this.classLoader.loadClass(name);
    }

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
        return this.sortedByClassName(this.reflections.getSubTypesOf(type));
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private <T> Set<Class<? extends T>> sortedByClassName(Set<Class<? extends T>> source) {
        return source.stream().sorted(Comparator.comparing(Class::getName)).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

