/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.osgi.support;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.ApplicationClassLoaderAccess;
import com.vaadin.flow.internal.VaadinContextInitializer;
import com.vaadin.flow.osgi.support.ServletContainerInitializerClasses;
import com.vaadin.flow.osgi.support.ServletInitRequirementsTracker;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.pro.licensechecker.LicenseChecker;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={VaadinServiceInitListener.class, HttpSessionListener.class, ServletContextListener.class, OSGiVaadinInitialization.class}, scope=ServiceScope.SINGLETON, property={"osgi.http.whiteboard.listener=true", "osgi.http.whiteboard.context.select=(osgi.http.whiteboard.context.name=*)"})
public class OSGiVaadinInitialization
implements VaadinServiceInitListener,
HttpSessionListener,
ServletContextListener {
    @Reference
    private ServletContainerInitializerClasses initializerClasses;
    private static final VaadinServletMarker MARKER_INSTANCE = new VaadinServletMarker();
    private static final String PROJECT_NAME = "vaadin-osgi";
    private static final String VERSION = OSGiVaadinInitialization.readVersion();

    public void serviceInit(ServiceInitEvent event) {
        VaadinService service = event.getSource();
        VaadinContext context = service.getContext();
        OSGiVaadinInitialization.checkLicense((AbstractConfiguration)service.getDeploymentConfiguration());
        context.setAttribute(VaadinServletMarker.class, (Object)MARKER_INSTANCE);
    }

    public void sessionCreated(HttpSessionEvent event) {
        ServletContext servletContext = event.getSession().getServletContext();
        VaadinServletContext vaadinContext = new VaadinServletContext(servletContext);
        VaadinServletMarker attribute = (VaadinServletMarker)vaadinContext.getAttribute(VaadinServletMarker.class);
        if (attribute == null) {
            vaadinContext.removeAttribute(Lookup.class);
            vaadinContext.removeAttribute(VaadinContextInitializer.class);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        VaadinServletContext context = new VaadinServletContext(servletContext);
        if (context.getAttribute(Lookup.class) != null) {
            return;
        }
        ApplicationClassLoaderAccess classLoaderAccess = (ApplicationClassLoaderAccess)context.getAttribute(ApplicationClassLoaderAccess.class);
        context.getAttribute(VaadinContextInitializer.class, () -> this::initContext);
        if (classLoaderAccess != null) {
            this.initContext((VaadinContext)context);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.initializerClasses.removeContext(event.getServletContext());
        VaadinServletContext servletContext = new VaadinServletContext(event.getServletContext());
        ServletInitRequirementsTracker tracker = (ServletInitRequirementsTracker)((Object)servletContext.getAttribute(ServletInitRequirementsTracker.class));
        if (tracker != null) {
            tracker.close();
            servletContext.removeAttribute(ServletInitRequirementsTracker.class);
        }
    }

    private void initContext(VaadinContext context) {
        context.removeAttribute(VaadinContextInitializer.class);
        VaadinServletContext servletContext = (VaadinServletContext)context;
        try {
            ServletInitRequirementsTracker tracker = new ServletInitRequirementsTracker(this.findBundle((VaadinContext)servletContext), servletContext, this.initializerClasses);
            servletContext.setAttribute((Object)tracker);
            tracker.open();
        }
        catch (IllegalContextState exception) {
            LoggerFactory.getLogger(OSGiVaadinInitialization.class).warn("Couldn't initialize Vaadin Context", (Throwable)exception);
        }
    }

    private Bundle findBundle(VaadinContext context) throws IllegalContextState {
        ApplicationClassLoaderAccess classLoaderAccess = (ApplicationClassLoaderAccess)context.getAttribute(ApplicationClassLoaderAccess.class);
        if (classLoaderAccess == null) {
            throw new IllegalContextState(ApplicationClassLoaderAccess.class.getName() + "' instance is not available in " + VaadinContext.class.getName());
        }
        ClassLoader classloader = classLoaderAccess.getClassloader();
        if (classloader instanceof BundleReference) {
            return ((BundleReference)classloader).getBundle();
        }
        throw new IllegalStateException("Unexpected classloader for the web app '" + classloader + "'. It's not possible to get an OSGi bundle from it");
    }

    static void checkLicense(AbstractConfiguration configuration) {
        if (!configuration.isProductionMode()) {
            LicenseChecker.checkLicense((String)PROJECT_NAME, (String)VERSION);
        }
    }

    private static String readVersion() {
        URL versionUrl = FrameworkUtil.getBundle(OSGiVaadinInitialization.class).getResource("vaadin-osgi-version.properties");
        if (versionUrl == null) {
            throw new RuntimeException("Couldn't find 'vaadin-osgi-version.properties' file in the bundle");
        }
        Properties properties = new Properties();
        try (InputStream stream = versionUrl.openStream();){
            properties.load(stream);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Couldn't read the 'vaadin-osgi-version.properties' file", exception);
        }
        return properties.getProperty("vaadin.osgi.version");
    }

    static class IllegalContextState
    extends Exception {
        private IllegalContextState(String msg) {
            super(msg);
        }
    }

    private static final class VaadinServletMarker {
        private VaadinServletMarker() {
        }
    }
}

