/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.osgi.support;

import com.vaadin.flow.server.StaticFileHandler;
import com.vaadin.flow.server.StaticFileHandlerFactory;
import com.vaadin.flow.server.StaticFileServer;
import com.vaadin.flow.server.VaadinService;
import java.net.URL;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;

@Component(scope=ServiceScope.BUNDLE, service={StaticFileHandlerFactory.class})
public class OSGiStaticFileHandlerFactory
implements StaticFileHandlerFactory {
    public StaticFileHandler createHandler(VaadinService service) {
        return new OSGiStaticFileHandler(service);
    }

    private static class OSGiStaticFileHandler
    extends StaticFileServer {
        private OSGiStaticFileHandler(VaadinService service) {
            super(service);
        }

        protected URL getStaticResource(String path) {
            String relativePath = path.replaceFirst("^/", "");
            if ("VAADIN/static/push/vaadinPush-min.js".equals(relativePath) || "VAADIN/static/push/vaadinPush.js".equals(relativePath)) {
                return this.getPushResource(relativePath);
            }
            return null;
        }

        private URL getPushResource(String path) {
            Bundle[] bundles;
            for (Bundle bundle : bundles = FrameworkUtil.getBundle(OSGiStaticFileHandlerFactory.class).getBundleContext().getBundles()) {
                if (!"com.vaadin.flow.push".equals(bundle.getSymbolicName())) continue;
                return bundle.getResource("META-INF/resources/" + path);
            }
            return null;
        }
    }
}

