/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.migration;

import com.vaadin.flow.migration.AbstractCopyResourcesStep;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.NodeVisitor;

public class CopyResourcesStep
extends AbstractCopyResourcesStep {
    private final Set<String> bowerComponents;

    public CopyResourcesStep(File target, File[] resourceFolders) {
        this(target, resourceFolders, new HashSet<String>());
    }

    private CopyResourcesStep(File target, File[] resourceFolders, Set<String> bowerComponents) {
        super(target, resourceFolders, new HtmlImportRewriter(target, bowerComponents));
        this.bowerComponents = bowerComponents;
    }

    @Override
    public Map<String, List<String>> copyResources() throws IOException {
        this.bowerComponents.clear();
        return super.copyResources();
    }

    public Set<String> getBowerComponents() {
        return Collections.unmodifiableSet(this.bowerComponents);
    }

    private static class HtmlImportRewriter
    implements AbstractCopyResourcesStep.FileTreeHandler {
        private final Collection<String> bowerComponents;
        private final File targetDir;

        private HtmlImportRewriter(File target, Collection<String> bowerComponents) {
            this.bowerComponents = bowerComponents;
            this.targetDir = target;
        }

        @Override
        public boolean handle(Path source, Path target) throws IOException {
            if (source.toFile().isDirectory()) {
                return true;
            }
            if (source.getFileName().toString().toLowerCase(Locale.ENGLISH).endsWith(".html")) {
                Files.write(target, Collections.singletonList(this.adjustContent(source.toFile(), target)), new OpenOption[0]);
                return true;
            }
            if (source.getFileName().toString().toLowerCase(Locale.ENGLISH).endsWith(".css")) {
                Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                return true;
            }
            return false;
        }

        private String adjustContent(File file, Path target) throws IOException {
            Document doc = Jsoup.parse((File)file, (String)StandardCharsets.UTF_8.name());
            Element head = doc.head();
            Element body = doc.body();
            StringBuilder result = new StringBuilder();
            for (Element child : head.children()) {
                String href;
                int index;
                String elementHtml = child.outerHtml();
                if ("link".equalsIgnoreCase(child.tagName()) && child.hasAttr("rel") && "import".equalsIgnoreCase(child.attr("rel")) && child.hasAttr("href") && (index = (href = child.attr("href")).indexOf("bower_components")) != -1) {
                    href = href.substring(index);
                    this.addBowerComponent(href);
                    child.attr("href", this.pathToTarget(target) + href);
                    elementHtml = child.outerHtml();
                }
                result.append(elementHtml).append('\n');
            }
            body.traverse((NodeVisitor)new CommentRemover());
            result.append(body.outerHtml());
            return result.toString();
        }

        private String pathToTarget(Path target) {
            String path = AbstractCopyResourcesStep.getRelativePath(this.targetDir.toPath(), target);
            if (path.length() >= 2) {
                path = path.substring(2);
            }
            if (path.isEmpty()) {
                return path;
            }
            if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if (!path.endsWith("/")) {
                return path + "/";
            }
            return path;
        }

        private void addBowerComponent(String uri) {
            if (this.bowerComponents == null) {
                return;
            }
            assert (uri.startsWith("bower_components"));
            String path = uri.substring("bower_components".length());
            if (path.charAt(0) != '/') {
                return;
            }
            path = path.substring(1);
            int index = path.indexOf(47);
            this.bowerComponents.add(path.substring(0, index));
        }
    }

    private static class CommentRemover
    implements NodeVisitor {
        private CommentRemover() {
        }

        public void tail(Node node, int depth) {
            if (node instanceof Comment) {
                node.remove();
            }
        }

        public void head(Node node, int depth) {
        }
    }
}

