/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.migration;

import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.migration.ClassPathIntrospector;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.utils.FlowFileUtils;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewriteLegacyAnnotationsStep
extends ClassPathIntrospector {
    private static final String HTML_EXTENSION = ".html";
    private static final String CSS_EXTENSION = ".css";
    private final URL compiledClassesURL;
    private final Collection<File> sourceRoots;
    private static final String BOWER_COMPONENT_PREFIX = "bower_components/";
    private static final String CLASS_DECLARATION_PATTERN = "(\\s|public|final|abstract|private|static|protected)*\\s+class\\s+%s(|<|>|\\?|\\w|\\s|,|\\&)*\\s+((extends\\s+(\\w|<|>|\\?|,)+)|(implements\\s+(|<|>|\\?|\\w|\\s|,)+( ,(\\w|<|>|\\?|\\s|,))*))?\\s*\\{";
    private final Map<Class<?>, Pattern> compiledClassPatterns = new HashMap();
    private final Map<String, Pattern> compiledReplacePatterns = new HashMap<String, Pattern>();

    public RewriteLegacyAnnotationsStep(File compiledClassesDir, ClassFinder finder, Collection<File> sourceRoots) {
        super(finder);
        this.compiledClassesURL = FlowFileUtils.convertToUrl(compiledClassesDir);
        this.sourceRoots = sourceRoots;
    }

    public void rewrite() {
        HashMap annotationPerClass = new HashMap();
        this.collectAnnotatedClasses(this.loadClassInProjectClassLoader(HtmlImport.class.getName()), annotationPerClass);
        this.collectAnnotatedClasses(this.loadClassInProjectClassLoader(StyleSheet.class.getName()), annotationPerClass);
        annotationPerClass.forEach(this::rewriteAnnotations);
    }

    private void collectAnnotatedClasses(Class<? extends Annotation> annotation, Map<Class<?>, Map<Class<? extends Annotation>, Collection<String>>> annotationPerClass) {
        Stream<Class<?>> classes = this.getAnnotatedClasses(annotation);
        classes.forEach(clazz -> this.handleClass((Class<?>)clazz, annotation, annotationPerClass));
    }

    private void handleClass(Class<?> clazz, Class<? extends Annotation> annotation, Map<Class<?>, Map<Class<? extends Annotation>, Collection<String>>> annotationPerClass) {
        URL location = clazz.getProtectionDomain().getCodeSource().getLocation();
        if (!this.compiledClassesURL.toExternalForm().equals(location.toExternalForm())) {
            return;
        }
        Collection<String> paths = this.collectAnnotationValues(clazz, annotation);
        if (!paths.isEmpty()) {
            Map annotationPaths = annotationPerClass.computeIfAbsent(clazz, cl -> new HashMap());
            annotationPaths.put(annotation, paths);
        }
    }

    private Collection<String> collectAnnotationValues(Class<?> clazz, Class<? extends Annotation> annotationType) {
        Annotation[] annotationsByType = clazz.getAnnotationsByType(annotationType);
        ArrayList<String> result = new ArrayList<String>();
        for (Annotation annotation : annotationsByType) {
            String path = this.invokeAnnotationMethod(annotation, "value").toString();
            result.add(path);
        }
        return result;
    }

    private void rewriteAnnotations(Class<?> clazz, Map<Class<? extends Annotation>, Collection<String>> annotations) {
        Collection<File> javaFiles = this.findJavaSourceFiles(clazz);
        if (javaFiles.isEmpty()) {
            LoggerFactory.getLogger(RewriteLegacyAnnotationsStep.class).debug("Could not find Java source code for class '{}'", clazz);
        } else {
            javaFiles.forEach(javaFile -> this.rewrite((File)javaFile, clazz, annotations));
        }
    }

    private Collection<File> findJavaSourceFiles(Class<?> clazz) {
        String packageName = clazz.getPackage().getName();
        String pckgPath = packageName.replace(".", "/");
        ArrayList<File> pkgDirs = new ArrayList<File>();
        ArrayList<File> result = new ArrayList<File>();
        for (File sourceRoot : this.sourceRoots) {
            File pkgFolder = new File(sourceRoot, pckgPath);
            if (!pkgFolder.exists()) continue;
            pkgDirs.add(pkgFolder);
            Class<?> topLevelClass = this.getTopLevelEnclosingClass(clazz);
            File mayBeJavaFile = new File(pkgFolder, topLevelClass.getSimpleName() + ".java");
            if (!mayBeJavaFile.exists()) continue;
            result.add(mayBeJavaFile);
            break;
        }
        if (result.isEmpty()) {
            for (File pkg : pkgDirs) {
                result.addAll(this.findClassFiles(pkg, clazz));
            }
        }
        return result;
    }

    private Collection<File> findClassFiles(File pkgDir, Class<?> clazz) {
        ArrayList<File> result = new ArrayList<File>();
        for (File file : pkgDir.listFiles()) {
            String content;
            if (!file.isFile() || !file.getName().endsWith(".java") || (content = this.readFile(file)) == null) continue;
            Pattern classDeclarationPattern = this.getClassDeclarationPattern(clazz);
            this.compiledClassPatterns.put(clazz, classDeclarationPattern);
            if (!classDeclarationPattern.matcher(content).find()) continue;
            result.add(file);
        }
        return result;
    }

    private String readFile(File file) {
        try {
            return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.getLogger().warn("Could not read source code from file '{}'", (Object)file);
            return null;
        }
    }

    private void rewrite(File javaFile, Class<?> clazz, Map<Class<? extends Annotation>, Collection<String>> annotations) {
        String content = this.readFile(javaFile);
        Pattern classDeclarationPattern = this.compiledClassPatterns.get(clazz);
        if (classDeclarationPattern == null) {
            classDeclarationPattern = this.getClassDeclarationPattern(clazz);
        }
        Matcher matcher = classDeclarationPattern.matcher(content);
        int classDeclarationStart = content.length();
        if (matcher.find()) {
            classDeclarationStart = matcher.start();
        } else {
            this.getLogger().debug("Implementation issue: unable to find class declaration inside {} java source file", (Object)javaFile);
        }
        String beforeClassDeclaration = content.substring(0, classDeclarationStart);
        for (Map.Entry<Class<? extends Annotation>, Collection<String>> entry : annotations.entrySet()) {
            beforeClassDeclaration = this.rewrite(javaFile, beforeClassDeclaration, entry.getKey(), entry.getValue());
        }
        try {
            FileUtils.write((File)javaFile, (CharSequence)(beforeClassDeclaration + content.substring(classDeclarationStart)), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.getLogger().warn("Could not write source code back to file '{}'", (Object)javaFile);
        }
    }

    private String rewrite(File javaFile, String content, Class<? extends Annotation> annotation, Collection<String> paths) {
        String result = content;
        result = this.replace(annotation.getName(), result, "\\b" + annotation.getName().replace(".", "\\.") + "\\b", JsModule.class.getName());
        result = this.replace(annotation.getSimpleName(), result, "(\\s*)@" + annotation.getSimpleName() + "\\b", "$1@" + JsModule.class.getSimpleName());
        for (String path : paths) {
            result = result.replaceAll(String.format("\"%s\"", Pattern.quote(path)), String.format("\"%s\"", this.rewritePath(path, externalComponent -> this.handleBowerComponentImport(javaFile, (String)externalComponent), nonVaadinComponentPath -> this.handleNonVaadinComponent(javaFile, (String)nonVaadinComponentPath))));
        }
        return result;
    }

    private String replace(String patternKey, String content, String regexp, String replacement) {
        Pattern pattern = this.compiledReplacePatterns.computeIfAbsent(patternKey, key -> Pattern.compile(regexp));
        return pattern.matcher(content).replaceAll(replacement);
    }

    private void handleBowerComponentImport(File javaFile, String bowerComponentPath) {
        this.getLogger().warn("External bower component {} is imported in the {} file, a converted '@JsModule' annotation requires also a `@NpmPackage` annotation with a module name and a version. The migrated project won't be built without this information.", (Object)bowerComponentPath, (Object)javaFile.getPath());
    }

    private void handleNonVaadinComponent(File javaFile, String nonVaadinComponentPath) {
        this.getLogger().error("In {} file, added a JS module import '@JsModule(\"{}\")' that you need to manually map to the correct package vendor from npm", (Object)javaFile.getPath(), (Object)nonVaadinComponentPath);
    }

    private String rewritePath(String path, Consumer<String> externalComponentHandler, Consumer<String> nonVaadinComponentHandler) {
        String result = path;
        result = this.rewriteExtension(result, HTML_EXTENSION);
        result = this.rewriteExtension(result, CSS_EXTENSION);
        result = this.removePrefix(result, "base://");
        result = this.removePrefix(result, "frontend://");
        if ((result = this.removePrefix(result, "context://")).startsWith(BOWER_COMPONENT_PREFIX)) {
            result = result.substring("bower_components".length());
            externalComponentHandler.accept(result);
            if (result.startsWith("/vaadin")) {
                result = "@vaadin" + result;
            } else {
                result = "NPM_VENDOR" + result;
                this.getLogger().warn("Don't know how to resolve Html import '{}'", (Object)path);
                nonVaadinComponentHandler.accept(result);
            }
        } else if (result.startsWith("/")) {
            result = "." + result;
        } else if (!result.startsWith("./")) {
            result = "./" + result;
        }
        return result;
    }

    private String rewriteExtension(String path, String extension) {
        if (path.endsWith(extension)) {
            return path.substring(0, path.length() - extension.length()) + ".js";
        }
        return path;
    }

    private String removePrefix(String path, String prefix) {
        if (path.startsWith(prefix)) {
            return path.substring(prefix.length());
        }
        return path;
    }

    private Pattern getClassDeclarationPattern(Class<?> clazz) {
        return Pattern.compile(String.format(CLASS_DECLARATION_PATTERN, clazz.getSimpleName()));
    }

    private Class<?> getTopLevelEnclosingClass(Class<?> clazz) {
        Class<?> enclosingClass = clazz.getEnclosingClass();
        if (enclosingClass == null) {
            return clazz;
        }
        return this.getTopLevelEnclosingClass(enclosingClass);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(RewriteLegacyAnnotationsStep.class);
    }
}

