/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.migration;

import com.vaadin.flow.migration.CopyMigratedResourcesStep;
import com.vaadin.flow.migration.CopyResourcesStep;
import com.vaadin.flow.migration.CreateMigrationJsonsStep;
import com.vaadin.flow.migration.MigrationConfiguration;
import com.vaadin.flow.migration.MigrationFailureException;
import com.vaadin.flow.migration.MigrationToolsException;
import com.vaadin.flow.migration.RewriteLegacyAnnotationsStep;
import com.vaadin.flow.server.frontend.FrontendUtils;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Migration {
    private static final String DEPENDENCIES = "dependencies";
    private final File tempMigrationFolder;
    private final File targetDirectory;
    private final File[] resourceDirectories;
    private final MigrationConfiguration configuration;

    public Migration(MigrationConfiguration configuration) {
        this.configuration = configuration;
        if (this.getTempMigrationFolder() == null) {
            if (configuration.getTempMigrationFolder() != null) {
                this.tempMigrationFolder = configuration.getTempMigrationFolder();
            } else {
                try {
                    this.tempMigrationFolder = Files.createTempDirectory("migration", new FileAttribute[0]).toFile();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not create a new temporary folder for migration. You may specify it manually");
                }
            }
        } else {
            if (!this.getTempMigrationFolder().isDirectory()) {
                String message = String.format("Received temp migration folder value '%s' is not a directory.", this.getTempMigrationFolder());
                throw new IllegalArgumentException(message);
            }
            if (this.getTempMigrationFolder().list().length > 0) {
                String message = String.format("Received non empty directory '%s' for use as the temporary migration folder.", this.getTempMigrationFolder());
                throw new IllegalArgumentException(message);
            }
            this.tempMigrationFolder = this.getTempMigrationFolder();
        }
        if (configuration.getBaseDirectory() == null) {
            throw new IllegalArgumentException("Configuration does not provide a base directory");
        }
        if (configuration.getResourceDirectories() != null && configuration.getResourceDirectories().length == 0) {
            throw new IllegalArgumentException("Configuration does not provide any resource directories");
        }
        this.resourceDirectories = configuration.getResourceDirectories() == null ? new File[]{new File(configuration.getBaseDirectory(), "src/main/webapp")} : configuration.getResourceDirectories();
        this.targetDirectory = configuration.getTargetDirectory() == null ? new File(configuration.getBaseDirectory(), "frontend") : configuration.getTargetDirectory();
        if (configuration.getClassFinder() == null) {
            throw new IllegalArgumentException("Configuration does not provide a class finder");
        }
        if (configuration.getJavaSourceDirectories() == null || configuration.getJavaSourceDirectories().length == 0) {
            throw new IllegalArgumentException("Configuration does not provide any java source directories");
        }
        if (configuration.getCompiledClassDirectory() == null) {
            throw new IllegalArgumentException("Configuration does not provide a compiled class directory");
        }
    }

    public void migrate() throws MigrationToolsException, MigrationFailureException {
        Set<String> externalComponents;
        Map<String, List<String>> paths;
        this.prepareMigrationDirectory();
        List bowerCommands = FrontendUtils.getBowerExecutable((String)this.getTempMigrationFolder().getPath());
        boolean needInstallBower = bowerCommands.isEmpty();
        if (!this.ensureTools(needInstallBower)) {
            throw new MigrationToolsException("Could not install tools required for migration (bower or modulizer)");
        }
        if (needInstallBower) {
            bowerCommands = FrontendUtils.getBowerExecutable((String)this.getTempMigrationFolder().getPath());
        }
        if (bowerCommands.isEmpty()) {
            throw new MigrationToolsException("Could not locate bower. Install it manually on your system and re-run migration goal.");
        }
        CopyResourcesStep copyStep = new CopyResourcesStep(this.getTempMigrationFolder(), this.getResources());
        try {
            paths = copyStep.copyResources();
            externalComponents = copyStep.getBowerComponents();
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Couldn't copy resources from source directories " + Arrays.asList(this.getResources()) + " to the target directory " + this.getTempMigrationFolder(), exception);
        }
        Set<String> migratedTopLevelDirs = Stream.of(this.getTempMigrationFolder().listFiles()).filter(File::isDirectory).map(File::getName).collect(Collectors.toSet());
        ArrayList<String> allPaths = new ArrayList<String>();
        paths.values().stream().forEach(allPaths::addAll);
        try {
            new CreateMigrationJsonsStep(this.getTempMigrationFolder()).createJsons(allPaths);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Couldn't generate json files", exception);
        }
        if (!this.saveBowerComponents(bowerCommands, externalComponents)) {
            throw new MigrationFailureException("Could not install bower components");
        }
        this.installNpmPackages();
        boolean modulizerHasErrors = false;
        if (!this.runModulizer()) {
            modulizerHasErrors = true;
            if (this.configuration.isIgnoreModulizerErrors()) {
                this.getLogger().info("Modulizer has exited with error");
            } else {
                throw new MigrationFailureException("Modulizer has exited with error. Unable to proceed.");
            }
        }
        if (!this.getTargetDirectory().exists()) {
            try {
                FileUtils.forceMkdir((File)this.getTargetDirectory());
            }
            catch (IOException exception) {
                throw new UncheckedIOException("Unable to create a target folder for migrated files: '" + this.getTargetDirectory() + "'", exception);
            }
        }
        CopyMigratedResourcesStep copyMigratedStep = new CopyMigratedResourcesStep(this.getTargetDirectory(), this.getTempMigrationFolder(), migratedTopLevelDirs);
        try {
            copyMigratedStep.copyResources();
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Couldn't copy migrated resources  to the target directory " + this.getTargetDirectory(), exception);
        }
        try {
            FileUtils.forceDelete((File)this.getTempMigrationFolder());
        }
        catch (IOException exception) {
            this.getLogger().debug("Couldn't remove " + this.getTempMigrationFolder().getPath(), (Throwable)exception);
        }
        if (!modulizerHasErrors && !this.configuration.isKeepOriginalFiles()) {
            this.removeOriginalResources(paths);
        }
        switch (this.configuration.getAnnotationRewriteStrategy()) {
            case SKIP: {
                break;
            }
            case ALWAYS: {
                this.rewrite();
                break;
            }
            case SKIP_ON_ERROR: {
                if (modulizerHasErrors) break;
                this.rewrite();
            }
        }
    }

    protected void prepareMigrationDirectory() {
        if (this.getTempMigrationFolder().exists()) {
            try {
                FileUtils.forceDelete((File)this.getTempMigrationFolder());
            }
            catch (IOException exception) {
                String message = String.format("Unable to delete directory '%s'", this.getTempMigrationFolder());
                throw new UncheckedIOException(message, exception);
            }
        }
        try {
            FileUtils.forceMkdir((File)this.getTempMigrationFolder());
        }
        catch (IOException exception) {
            String message = String.format("Failed in creating migration folder '%s'", this.getTempMigrationFolder());
            throw new UncheckedIOException(message, exception);
        }
    }

    private void removeOriginalResources(Map<String, List<String>> paths) {
        for (Map.Entry<String, List<String>> entry : paths.entrySet()) {
            File resourceFolder = new File(entry.getKey());
            entry.getValue().forEach(path -> new File(resourceFolder, (String)path).delete());
        }
    }

    private void installNpmPackages() throws MigrationFailureException {
        List npmExec = FrontendUtils.getNpmExecutable((String)this.configuration.getBaseDirectory().getPath());
        ArrayList<String> npmInstall = new ArrayList<String>(npmExec.size());
        npmInstall.addAll(npmExec);
        npmInstall.add("i");
        if (!this.executeProcess(npmInstall, "Couldn't install packages using npm", "Packages successfully installed", "Error when running `npm install`")) {
            throw new MigrationFailureException("Error during package installation via npm");
        }
    }

    private boolean runModulizer() {
        Collection<String> depMapping = this.makeDependencyMapping();
        ArrayList<String> command = new ArrayList<String>();
        command.add(FrontendUtils.getNodeExecutable((String)this.configuration.getBaseDirectory().getPath()));
        command.add("node_modules/polymer-modulizer/bin/modulizer.js");
        command.add("--force");
        command.add("--out");
        command.add(".");
        command.add("--import-style=name");
        if (!depMapping.isEmpty()) {
            command.add("--dependency-mapping");
            command.addAll(depMapping);
        }
        return this.executeProcess(command, "Migration has finished with errors", "Modulizer has completed successfully", "Error when running moulizer");
    }

    private Collection<String> makeDependencyMapping() {
        File bower = new File(this.getTempMigrationFolder(), "bower.json");
        try {
            HashSet<String> result = new HashSet<String>();
            String content = Files.readAllLines(bower.toPath()).stream().collect(Collectors.joining("\n"));
            JsonObject object = Json.parse((String)content);
            if (object.hasKey(DEPENDENCIES)) {
                JsonObject deps = object.getObject(DEPENDENCIES);
                Stream.of(deps.keys()).filter(key -> key.startsWith("vaadin-")).forEach(key -> result.add(this.makeVaadinDependencyMapping(deps, (String)key)));
            }
            return result;
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Unable to read bower.json", exception);
        }
    }

    private String makeVaadinDependencyMapping(JsonObject deps, String key) {
        JsonValue version = deps.get(key);
        StringBuilder builder = new StringBuilder(key);
        builder.append(',');
        builder.append("@vaadin/");
        builder.append(key).append(',');
        builder.append(version.asString());
        return builder.toString();
    }

    private boolean saveBowerComponents(List<String> bowerCommands, Collection<String> components) {
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(bowerCommands);
        command.add("i");
        command.add("-F");
        command.add("--config.interactive=false");
        command.add("-S");
        command.add("polymer#2.8.0");
        components.stream().filter(component -> !"polymer".equals(component)).forEach(command::add);
        return this.executeProcess(command, "Couldn't install and save bower components", "All components are installed and saved successfully", "Error when running `bower install`");
    }

    private boolean ensureTools(boolean needInstallBower) {
        List npmExecutable = FrontendUtils.getNpmExecutable((String)this.configuration.getBaseDirectory().getPath());
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(npmExecutable);
        command.add("install");
        if (needInstallBower) {
            command.add("bower");
        }
        command.add("polymer-modulizer");
        return this.executeProcess(command, "Couldn't install migration tools", "Bower is installed successfully", "Error when running `npm install`");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeProcess(List<String> command, String errorMsg, String successMsg, String exceptionMsg) {
        ProcessBuilder builder = FrontendUtils.createProcessBuilder(command);
        builder.directory(this.getTempMigrationFolder());
        Process process = null;
        try {
            process = builder.inheritIO().start();
            int errorCode = process.waitFor();
            if (errorCode != 0) {
                this.getLogger().error(errorMsg);
                boolean bl = false;
                return bl;
            }
            this.getLogger().debug(successMsg);
        }
        catch (IOException | InterruptedException e) {
            this.getLogger().error(exceptionMsg, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
        }
        return true;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(Migration.class);
    }

    private File[] getResources() {
        if (this.getResourceDirectories() == null) {
            File webApp = new File(this.configuration.getBaseDirectory(), "src/main/webapp");
            return new File[]{webApp};
        }
        return this.getResourceDirectories();
    }

    private void rewrite() {
        RewriteLegacyAnnotationsStep step = new RewriteLegacyAnnotationsStep(this.configuration.getCompiledClassDirectory(), this.configuration.getClassFinder(), Stream.of(this.configuration.getJavaSourceDirectories()).collect(Collectors.toList()));
        step.rewrite();
    }

    private File getTempMigrationFolder() {
        return this.tempMigrationFolder;
    }

    private File getTargetDirectory() {
        return this.targetDirectory;
    }

    private File[] getResourceDirectories() {
        return this.resourceDirectories;
    }
}

