/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.maven;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.plugin.maven.FlowModeAbstractMojo;
import com.vaadin.flow.plugin.maven.InvocationRequestBuilder;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.NodeTasks;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import java.io.File;
import java.net.URISyntaxException;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;

@Mojo(name="generate-npm-sbom", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class GenerateNpmBOMMojo
extends FlowModeAbstractMojo {
    private static final String GROUP = "org.codehaus.mojo";
    private static final String ARTIFACT = "exec-maven-plugin";
    private static final String VERSION = "3.6.2";
    private static final String GOAL = "exec";
    @Parameter(defaultValue="false")
    private boolean ignoreNpmErrors;
    @Parameter(defaultValue="false")
    private boolean packageLockOnly;
    @Parameter(defaultValue="dev")
    private String omit;
    @Parameter(defaultValue="false")
    private boolean flattenComponents;
    @Parameter(defaultValue="false")
    private boolean shortPURLs;
    @Parameter(defaultValue="false")
    private boolean outputReproducible;
    @Parameter(defaultValue="true")
    private boolean validate;
    @Parameter(defaultValue="false")
    private boolean productionMode;
    @Parameter(defaultValue="application")
    private String mcType;
    @Parameter(defaultValue="json")
    private String outputFormat;
    @Parameter(defaultValue="${project.build.outputDirectory}/resources/bom-npm.json")
    private String outputFilePath;
    @Parameter(defaultValue="./package.json")
    private String packageManifest;
    @Parameter(defaultValue="1.4")
    private String specVersion;

    @Override
    protected void executeInternal() throws MojoExecutionException, MojoFailureException {
        InvocationRequestBuilder requestBuilder = new InvocationRequestBuilder();
        InvocationRequest request = requestBuilder.groupId(GROUP).artifactId(ARTIFACT).version(VERSION).goal(GOAL).createInvocationRequest();
        Properties properties = this.getProperties();
        request.setProperties(properties);
        DefaultInvoker invoker = new DefaultInvoker();
        try {
            InvocationResult result;
            this.createDirectoryIfNotExists();
            File nodeModulesDir = new File(this.npmFolder(), "/node_modules");
            if (!nodeModulesDir.exists()) {
                this.logInfo("No node_modules directory found. Running npm install.");
                ClassFinder classFinder = this.getClassFinder();
                Lookup lookup = this.createLookup(classFinder);
                File jarFrontendResourcesFolder = new File(new File(this.frontendDirectory(), "generated/"), "jar-resources");
                Options options = new Options(lookup, this.npmFolder()).withFrontendDirectory(this.frontendDirectory()).withBuildDirectory(this.buildFolder()).withJarFrontendResourcesFolder(jarFrontendResourcesFolder).createMissingPackageJson(true).enableImportsUpdate(true).enablePackagesUpdate(true).withRunNpmInstall(true).withFrontendGeneratedFolder(this.generatedTsFolder()).withNodeVersion(this.nodeVersion()).withNodeDownloadRoot(this.nodeDownloadRoot()).setNodeAutoUpdate(this.nodeAutoUpdate()).withHomeNodeExecRequired(this.requireHomeNodeExec()).setJavaResourceFolder(this.javaResourceFolder()).withProductionMode(this.productionMode).withReact(this.isReactEnabled()).withNpmExcludeWebComponents(this.isNpmExcludeWebComponents()).withFrontendIgnoreVersionChecks(this.isFrontendIgnoreVersionChecks());
                new NodeTasks(options).execute();
                this.logInfo("SBOM generation created node_modules and all needed metadata. If you don't need it, please run mvn vaadin:clean-frontend");
            }
            if ((result = invoker.execute(request)).getExitCode() != 0) {
                throw new MojoFailureException("Frontend SBOM generation failed.", (Throwable)result.getExecutionException());
            }
        }
        catch (ExecutionFailedException | URISyntaxException | MavenInvocationException e) {
            throw new MojoExecutionException("Error during Frontend SBOM generation", (Exception)e);
        }
    }

    private Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty("exec.executable", "npx");
        properties.setProperty("exec.args", "@cyclonedx/cyclonedx-npm" + (this.ignoreNpmErrors ? " --ignore-npm-errors" : "") + (this.packageLockOnly ? " --package-lock-only" : "") + (this.flattenComponents ? " --flatten-components" : "") + (this.shortPURLs ? " --short-PURLs" : "") + (this.outputReproducible ? " --output-reproducible" : "") + (this.validate ? " --validate" : " --no-validate") + " --mc-type " + this.mcType + " --omit " + this.omit + " --spec-version " + this.specVersion + " --output-file " + this.outputFilePath + " --output-format " + this.outputFormat + " -- " + this.packageManifest);
        return properties;
    }

    private boolean createDirectoryIfNotExists() {
        int lastIndex = this.outputFilePath.lastIndexOf(FrontendUtils.isWindows() ? 92 : 47);
        File directory = new File(this.outputFilePath.substring(0, lastIndex));
        return directory.exists() || directory.mkdirs();
    }
}

