/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.value;

import com.vaadin.flow.dom.DomListenerRegistration;

public enum ValueChangeMode {
    EAGER,
    LAZY,
    TIMEOUT,
    ON_BLUR,
    ON_CHANGE;


    public static String eventForMode(ValueChangeMode mode, String immediateEventName) {
        if (mode == null) {
            return null;
        }
        switch (mode.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                return immediateEventName;
            }
            case 3: {
                return "blur";
            }
            case 4: {
                return "change";
            }
        }
        ValueChangeMode.throwModeNotSupported(mode);
        return null;
    }

    public static void applyChangeTimeout(ValueChangeMode mode, int timeout, DomListenerRegistration registration) {
        if (mode == null || registration == null) {
            return;
        }
        switch (mode.ordinal()) {
            case 1: {
                registration.debounce(timeout);
                break;
            }
            case 2: {
                registration.throttle(timeout);
                break;
            }
            case 0: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                ValueChangeMode.throwModeNotSupported(mode);
            }
        }
    }

    private static void throwModeNotSupported(ValueChangeMode mode) {
        throw new IllegalArgumentException("Value change mode " + mode.name() + " not supported");
    }
}

