/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.QuerySortOrder;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class HierarchicalQuery<T, F>
extends Query<T, F> {
    private final T parent;
    private final Set<Object> expandedItemIds;

    public HierarchicalQuery(F filter, T parent) {
        super(filter);
        this.expandedItemIds = Collections.emptySet();
        this.parent = parent;
    }

    public HierarchicalQuery(F filter, Set<Object> expandedItemIds, T parent) {
        super(filter);
        this.expandedItemIds = expandedItemIds;
        this.parent = parent;
    }

    public HierarchicalQuery(int offset, int limit, List<QuerySortOrder> sortOrders, Comparator<T> inMemorySorting, F filter, T parent) {
        super(offset, limit, sortOrders, inMemorySorting, filter);
        this.expandedItemIds = Collections.emptySet();
        this.parent = parent;
    }

    public HierarchicalQuery(int offset, int limit, List<QuerySortOrder> sortOrders, Comparator<T> inMemorySorting, F filter, Set<Object> expandedItemIds, T parent) {
        super(offset, limit, sortOrders, inMemorySorting, filter);
        this.expandedItemIds = expandedItemIds;
        this.parent = parent;
    }

    public T getParent() {
        return this.parent;
    }

    public Optional<T> getParentOptional() {
        return Optional.ofNullable(this.parent);
    }

    public Set<Object> getExpandedItemIds() {
        return this.expandedItemIds;
    }
}

