/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.converter;

import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.Converter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Objects;

public class LocalDateTimeToInstantConverter
implements Converter<LocalDateTime, Instant> {
    private ZoneId zoneId;

    public LocalDateTimeToInstantConverter(ZoneId zoneId) {
        this.zoneId = Objects.requireNonNull(zoneId, "Zone identifier cannot be null");
    }

    @Override
    public Result<Instant> convertToModel(LocalDateTime localDateTime, ValueContext context) {
        if (localDateTime == null) {
            return Result.ok(null);
        }
        return Result.ok(localDateTime.atZone(this.zoneId).toInstant());
    }

    @Override
    public LocalDateTime convertToPresentation(Instant instant, ValueContext context) {
        if (instant == null) {
            return null;
        }
        return instant.atZone(this.zoneId).toLocalDateTime();
    }
}

