/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.data.binder.BeanPropertySet;
import com.vaadin.flow.data.binder.PropertyDefinition;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.shared.util.SharedUtil;
import java.beans.PropertyDescriptor;

public abstract class AbstractBeanPropertyDefinition<T, V>
implements PropertyDefinition<T, V> {
    private final PropertyDescriptor descriptor;
    private final BeanPropertySet<T> propertySet;
    private final Class<?> propertyHolderType;

    public AbstractBeanPropertyDefinition(BeanPropertySet<T> propertySet, Class<?> propertyHolderType, PropertyDescriptor descriptor) {
        this.propertySet = propertySet;
        this.propertyHolderType = propertyHolderType;
        this.descriptor = descriptor;
        if (descriptor.getReadMethod() == null) {
            throw new IllegalArgumentException("Bean property has no accessible getter: " + propertySet.getBeanType() + "." + descriptor.getName());
        }
    }

    @Override
    public Class<V> getType() {
        return ReflectTools.convertPrimitiveType(this.descriptor.getPropertyType());
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public String getCaption() {
        return SharedUtil.propertyIdToHumanFriendly((Object)this.getName());
    }

    @Override
    public BeanPropertySet<T> getPropertySet() {
        return this.propertySet;
    }

    protected PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Class<?> getPropertyHolderType() {
        return this.propertyHolderType;
    }
}

