/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.function.SerializableBiPredicate;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;

public class InMemoryDataProviderHelpers {
    public static final SerializableSupplier<Locale> CURRENT_LOCALE_SUPPLIER = (SerializableSupplier & Serializable)() -> {
        UI currentUi = UI.getCurrent();
        if (currentUi != null) {
            return currentUi.getLocale();
        }
        return Locale.getDefault();
    };

    private InMemoryDataProviderHelpers() {
    }

    public static <T, V, Q> DataProvider<T, Q> filteringByIgnoreNull(InMemoryDataProvider<T> dataProvider, ValueProvider<T, V> valueProvider, SerializableBiPredicate<V, Q> predicate) {
        Objects.requireNonNull(predicate, "Predicate cannot be null");
        return dataProvider.filteringBy(valueProvider, (SerializableBiPredicate & Serializable)(itemValue, queryFilter) -> itemValue != null && predicate.test(itemValue, queryFilter));
    }

    public static <T> DataProvider<T, String> filteringByCaseInsensitiveString(InMemoryDataProvider<T> dataProvider, ValueProvider<T, String> valueProvider, SerializableBiPredicate<String, String> predicate, SerializableSupplier<Locale> localeSupplier) {
        assert (predicate != null);
        assert (localeSupplier != null);
        return InMemoryDataProviderHelpers.filteringByIgnoreNull(dataProvider, valueProvider, (SerializableBiPredicate & Serializable)(itemString, filterString) -> {
            Locale locale = (Locale)localeSupplier.get();
            assert (locale != null);
            return predicate.test((Object)itemString.toLowerCase(locale), (Object)filterString.toLowerCase(locale));
        });
    }

    public static <V extends Comparable<? super V>, T> SerializableComparator<T> propertyComparator(ValueProvider<T, V> valueProvider, SortDirection sortDirection) {
        Objects.requireNonNull(valueProvider, "Value provider cannot be null");
        Objects.requireNonNull(sortDirection, "Sort direction cannot be null");
        Comparator comparator = InMemoryDataProviderHelpers.getNaturalSortComparator(sortDirection);
        return (SerializableComparator & Serializable)(a, b) -> comparator.compare((Comparable)valueProvider.apply(a), (Comparable)valueProvider.apply(b));
    }

    public static <V extends Comparable<? super V>> Comparator<V> getNaturalSortComparator(SortDirection sortDirection) {
        Comparator comparator = Comparator.naturalOrder();
        if (sortDirection == SortDirection.DESCENDING) {
            comparator = comparator.reversed();
        }
        return comparator;
    }

    public static <T, V> SerializablePredicate<T> createValueProviderFilter(ValueProvider<T, V> valueProvider, SerializablePredicate<V> valueFilter) {
        return (SerializablePredicate & Serializable)item -> valueFilter.test(valueProvider.apply(item));
    }

    public static <T, V> SerializablePredicate<T> createEqualsFilter(ValueProvider<T, V> valueProvider, V requiredValue) {
        Objects.requireNonNull(valueProvider, "Value provider cannot be null");
        return (SerializablePredicate & Serializable)item -> Objects.equals(valueProvider.apply(item), requiredValue);
    }
}

